/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.carnot.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.VariableContext;

public class VariableContextHelper {
    private static VariableContextHelper instance = null;
    private Map<String, VariableContext> contextMap = new HashMap<String, VariableContext>();

    public static synchronized VariableContextHelper getInstance() {
        if (instance == null) {
            instance = new VariableContextHelper();
        }
        return instance;
    }

    public synchronized void clear() {
        this.contextMap.clear();
    }

    public synchronized void createContext(ModelType modelType) {
        if (modelType != null) {
            this.contextMap.put(modelType.getId(), new VariableContext());
        }
    }

    public synchronized void removeContext(ModelType modelType) {
        if (modelType != null) {
            this.contextMap.remove(modelType.getId());
        }
    }

    public synchronized VariableContext getContext(ModelType modelType) {
        if (modelType == null) {
            return null;
        }
        return this.contextMap.get(modelType.getId());
    }

    public synchronized VariableContext getContext(IModelElement element) {
        ModelType modelType = ModelUtils.findContainingModel(element);
        if (modelType != null) {
            VariableContext context = this.contextMap.get(modelType.getId());
            if (context == null) {
                this.createContext(modelType);
            }
            return this.contextMap.get(modelType.getId());
        }
        return null;
    }

    public synchronized void updateContextID(ModelType modelType, String newID) {
        if (modelType != null && this.contextMap.get(modelType.getId()) != null) {
            VariableContext context = this.contextMap.remove(modelType.getId());
            this.contextMap.put(newID, context);
        }
    }

    public synchronized void storeVariables(ModelType workflowModel, boolean save) {
        if (workflowModel != null) {
            this.createContext(workflowModel);
            this.getContext(workflowModel).initializeVariables(workflowModel);
            this.getContext(workflowModel).refreshVariables(workflowModel);
            if (save) {
                this.getContext(workflowModel).saveVariables();
            }
        }
    }
}

