/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.carnot.xpdl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.SAXParser;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.stardust.common.error.InternalException;
import org.eclipse.stardust.common.error.PublicException;
import org.eclipse.stardust.common.log.LogManager;
import org.eclipse.stardust.common.log.Logger;
import org.eclipse.stardust.engine.core.model.xpdl.XpdlUtils;
import org.eclipse.stardust.engine.core.runtime.utils.XmlUtils;
import org.eclipse.stardust.model.xpdl.carnot.Model_Messages;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XpdlSaxParser
extends SAXParser {
    private static final Logger trace = LogManager.getLogger(XpdlSaxParser.class);
    private static Transformer xpdl2cwmTransformer;
    private final SAXParser cwmParser;

    public XpdlSaxParser(SAXParser cwmParser) {
        this.cwmParser = cwmParser;
    }

    @Override
    public XMLReader getXMLReader() throws SAXException {
        return this.cwmParser.getXMLReader();
    }

    @Override
    public Parser getParser() throws SAXException {
        return this.cwmParser.getParser();
    }

    @Override
    public boolean isNamespaceAware() {
        return this.cwmParser.isNamespaceAware();
    }

    @Override
    public boolean isValidating() {
        return this.cwmParser.isValidating();
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.cwmParser.getProperty(name);
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.cwmParser.setProperty(name, value);
    }

    @Override
    public void parse(String uri, DefaultHandler dh) throws SAXException, IOException {
        this.cwmParser.parse(uri, dh);
    }

    @Override
    public void parse(File f, DefaultHandler dh) throws SAXException, IOException {
        this.parse(new InputSource(new FileInputStream(f)), dh);
    }

    @Override
    public void parse(InputSource is, DefaultHandler dh) throws SAXException, IOException {
        final URL xsdURL = XpdlUtils.getXpdl_10_Schema();
        if (xsdURL == null) {
            throw new InternalException(String.valueOf(Model_Messages.MSG_UNABLE_TO_FIND_XPDL_IMPORT) + "TC-1025_schema_10_xpdl.xsd");
        }
        XMLReader xpdlReader = XmlUtils.newXmlReader((boolean)false);
        xpdlReader.setErrorHandler(new ParseErrorHandler());
        xpdlReader.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                if (systemId != null && ("http://wfmc.org/standards/docs/TC-1025_schema_10_xpdl.xsd".equals(systemId) || XpdlUtils.NS_XPDL_1_0.equals(systemId))) {
                    return new InputSource(xsdURL.openStream());
                }
                return null;
            }
        });
        SAXResult result = new SAXResult();
        result.setHandler(dh);
        ClassLoader cclBackup = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(XpdlSaxParser.class.getClassLoader());
                Transformer xpdlTransformer = this.getXpdlTransformer();
                xpdlTransformer.transform(new SAXSource(xpdlReader, is), result);
            }
            catch (TransformerException e) {
                throw new PublicException(Model_Messages.MSG_FAILED_LOADING_MODEL, (Throwable)e);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(cclBackup);
        }
    }

    @Override
    public void parse(InputStream is, DefaultHandler dh) throws SAXException, IOException {
        this.parse(new InputSource(is), dh);
    }

    @Override
    public void parse(InputStream is, DefaultHandler dh, String systemId) throws SAXException, IOException {
        this.parse(new InputSource(is), dh);
    }

    @Override
    public void parse(File f, HandlerBase hb) throws SAXException, IOException {
        this.cwmParser.parse(f, hb);
    }

    @Override
    public void parse(InputSource is, HandlerBase hb) throws SAXException, IOException {
        this.cwmParser.parse(is, hb);
    }

    @Override
    public void parse(InputStream is, HandlerBase hb) throws SAXException, IOException {
        this.cwmParser.parse(is, hb);
    }

    @Override
    public void parse(InputStream is, HandlerBase hb, String systemId) throws SAXException, IOException {
        this.cwmParser.parse(is, hb, systemId);
    }

    @Override
    public void parse(String uri, HandlerBase hb) throws SAXException, IOException {
        this.cwmParser.parse(uri, hb);
    }

    private synchronized Transformer getXpdlTransformer() {
        if (xpdl2cwmTransformer == null) {
            URL xsltURL = XpdlUtils.getXpdl2CarnotStylesheet();
            if (xsltURL == null) {
                throw new InternalException(Model_Messages.MSG_UNABLE_TO_FIND_XPDL_IMPORT);
            }
            try {
                TransformerFactory transformerFactory = XmlUtils.newTransformerFactory();
                try {
                    xpdl2cwmTransformer = transformerFactory.newTransformer(new StreamSource(xsltURL.openStream()));
                }
                catch (IOException e) {
                    throw new PublicException(Model_Messages.MSG_UNABLE_TO_LOAD_XPDL_IMPORT, (Throwable)e);
                }
                xpdl2cwmTransformer.setOutputProperty("indent", "yes");
                xpdl2cwmTransformer.setOutputProperty("method", "xml");
                xpdl2cwmTransformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", Integer.toString(3));
                xpdl2cwmTransformer.setOutputProperty("encoding", "UTF-8");
                xpdl2cwmTransformer.setOutputProperty("cdata-section-elements", "description annotationSymbol expression");
            }
            catch (TransformerConfigurationException e) {
                throw new PublicException(Model_Messages.MSG_INVALID_JAXP_SETUP, (Throwable)e);
            }
        }
        return xpdl2cwmTransformer;
    }

    private static class ParseErrorHandler
    implements ErrorHandler {
        private ParseErrorHandler() {
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            trace.warn((Object)this.formatParseException(Model_Messages.MSG_WARN, exception));
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            trace.error((Object)this.formatParseException(Model_Messages.MSG_ERR, exception));
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            trace.error((Object)this.formatParseException(Model_Messages.MSG_FATAL_ERR, exception));
        }

        private String formatParseException(String label, SAXParseException e) {
            StringBuffer buffer = new StringBuffer(100);
            buffer.append(label).append(" (").append(e.getLineNumber()).append(", ").append(e.getColumnNumber()).append(") ");
            buffer.append(e.getMessage());
            return buffer.toString();
        }
    }
}

