/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.xpdl2.util;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDAttributeUseCategory;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDConstrainingFacet;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTerm;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDWildcard;
import org.eclipse.xsd.util.XSDSwitch;

public class XsdTextProvider
extends XSDSwitch<String> {
    private static final String[] DEFAULT_CARDINALITY_LABELS = new String[]{"required", "optional", "many", "at least one"};
    private int column;
    public String[] CARDINALITY_LABELS = DEFAULT_CARDINALITY_LABELS;

    public void setColumn(int column) {
        this.column = column;
    }

    public String caseXSDSchema(XSDSchema schema) {
        switch (this.column) {
            case 0: {
                return "schema";
            }
            case 1: {
                return schema.getTargetNamespace();
            }
        }
        return "";
    }

    public String caseXSDElementDeclaration(XSDElementDeclaration element) {
        XSDElementDeclaration ref = null;
        if (element.isElementDeclarationReference()) {
            ref = element.getResolvedElementDeclaration();
        }
        switch (this.column) {
            case 0: {
                return ref == null ? element.getName() : ref.getName();
            }
            case 1: {
                if (ref != null) {
                    return ref.getQName((XSDConcreteComponent)element);
                }
                XSDTypeDefinition type = element.getTypeDefinition();
                if (type == null) break;
                return type.getQName((XSDConcreteComponent)element);
            }
            case 2: {
                int cardinalityIndex = XsdTextProvider.getCardinalityIndex((XSDConcreteComponent)element);
                if (cardinalityIndex >= 0) {
                    return this.CARDINALITY_LABELS[cardinalityIndex];
                }
                if (!(element.eContainer() instanceof XSDParticle)) break;
                XSDParticle particle = (XSDParticle)element.eContainer();
                int minOccurs = particle.getMinOccurs();
                int maxOccurs = particle.getMaxOccurs();
                if (maxOccurs == -1) {
                    return String.valueOf(Integer.toString(minOccurs)) + "..*";
                }
                return String.valueOf(Integer.toString(minOccurs)) + ".." + Integer.toString(maxOccurs);
            }
        }
        return "";
    }

    public String caseXSDSimpleTypeDefinition(XSDSimpleTypeDefinition simpleType) {
        switch (this.column) {
            case 0: {
                return simpleType.getName();
            }
            case 1: {
                return simpleType.getBaseTypeDefinition().getName();
            }
        }
        return "";
    }

    public String caseXSDComplexTypeDefinition(XSDComplexTypeDefinition complexType) {
        switch (this.column) {
            case 0: {
                return complexType.getName();
            }
            case 1: {
                XSDComplexTypeContent content = complexType.getContent();
                if (content instanceof XSDParticle) {
                    return "";
                }
                return complexType.getBaseTypeDefinition().getName();
            }
        }
        return "";
    }

    public String caseXSDConstrainingFacet(XSDConstrainingFacet facet) {
        switch (this.column) {
            case 0: {
                return facet.getLexicalValue();
            }
        }
        return "";
    }

    public String caseXSDModelGroup(XSDModelGroup model) {
        switch (this.column) {
            case 0: {
                return String.valueOf('<') + model.getCompositor().getName() + '>';
            }
        }
        return "";
    }

    public String caseXSDAttributeDeclaration(XSDAttributeDeclaration attribute) {
        switch (this.column) {
            case 0: {
                return attribute.getName();
            }
            case 1: {
                if (attribute.getTypeDefinition() == null) {
                    return "<unresolved>";
                }
                return attribute.getTypeDefinition().getName();
            }
            case 2: {
                int cardinalityIndex = XsdTextProvider.getCardinalityIndex((XSDConcreteComponent)attribute);
                if (cardinalityIndex < 0) break;
                return XSDAttributeUseCategory.get((int)cardinalityIndex).getLiteral();
            }
        }
        return "";
    }

    public String caseXSDWildcard(XSDWildcard wildcard) {
        switch (this.column) {
            case 0: {
                String label = "any";
                if (wildcard.eContainer() instanceof XSDComplexTypeDefinition) {
                    label = String.valueOf(label) + "Attribute";
                }
                return String.valueOf('<') + label + '>';
            }
        }
        return "";
    }

    public String defaultCase(EObject object) {
        return this.column == 0 ? object.toString() : "";
    }

    public static int getCardinalityIndex(XSDConcreteComponent term) {
        XSDAttributeUseCategory category;
        XSDAttributeUse xsdAttributeUse;
        if (term instanceof XSDTerm && term.eContainer() instanceof XSDParticle) {
            XSDParticle particle = (XSDParticle)term.eContainer();
            int minOccurs = particle.getMinOccurs();
            int maxOccurs = particle.getMaxOccurs();
            if (maxOccurs == -1 || maxOccurs > 1) {
                if (minOccurs == 0) {
                    return 2;
                }
                return 3;
            }
            if (minOccurs == 0) {
                return 1;
            }
            return 0;
        }
        if (term instanceof XSDAttributeDeclaration && (xsdAttributeUse = (XSDAttributeUse)term.eContainer()) != null && (category = xsdAttributeUse.getUse()) != null) {
            return category.getValue();
        }
        return -1;
    }
}

