/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.common.platform.utils;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.stardust.common.StringUtils;
import org.osgi.framework.Bundle;

public class BundleUtils {
    public static IPath getBundleLocation(String bundleId) {
        Bundle bundle = Platform.getBundle((String)bundleId);
        return bundle != null ? BundleUtils.getBundleLocation(bundle) : null;
    }

    public static IPath getBundleLocation(Bundle bundle) {
        IPath result = null;
        if (bundle != null) {
            URL local = null;
            try {
                local = FileLocator.toFileURL((URL)bundle.getEntry("/"));
            }
            catch (IOException iOException) {
                result = null;
            }
            String fullPath = new File(local.getPath()).getAbsolutePath();
            result = Path.fromOSString((String)fullPath);
        }
        return result;
    }

    public static String resolveLibrary(String bundleId, String baseName) {
        IPath resolvedLib = BundleUtils.resolveLibraryLocation(bundleId, baseName);
        return resolvedLib != null ? resolvedLib.lastSegment() : null;
    }

    public static IPath resolveLibraryLocation(String bundleId, String baseName) {
        IPath resolvedFile = null;
        IPath root = BundleUtils.getBundleLocation(bundleId);
        if (root != null) {
            IPath libRoot;
            if (baseName.endsWith(".jar")) {
                baseName = baseName.substring(0, baseName.length() - ".jar".length());
            }
            if ((resolvedFile = BundleUtils.resolveFile(libRoot = root.append("lib").addTrailingSeparator(), baseName, ".jar")) == null) {
                resolvedFile = BundleUtils.resolveFile(root.addTrailingSeparator(), baseName, ".jar");
            }
        }
        return resolvedFile;
    }

    public static IPath resolveFile(IPath root, String baseName, String extension) {
        IPath result = null;
        File rootFolder = root.toFile();
        if (rootFolder.isDirectory()) {
            String[] files = rootFolder.list();
            int i = 0;
            while (i < files.length) {
                String suffix;
                if (files[i].startsWith(baseName) && !StringUtils.isEmpty((String)extension) && files[i].endsWith(extension) && !files[i].endsWith("-src" + extension) && (extension.equals(suffix = files[i].substring(baseName.length())) || (suffix.startsWith("-") || suffix.startsWith("_")) && Character.isDigit(suffix.charAt(1)))) {
                    result = Path.fromOSString((String)new File(rootFolder, files[i]).getAbsolutePath());
                    break;
                }
                ++i;
            }
        }
        return result;
    }
}

