/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.common.projectnature.classpath;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.stardust.common.Base64;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.error.InternalException;
import org.eclipse.stardust.modeling.common.projectnature.classpath.BpmCoreLibrariesClasspathContainer;
import org.eclipse.stardust.modeling.common.projectnature.classpath.BpmSpringLibrariesClasspathContainer;

public class BpmClasspathUtils {
    public static final IPath[] IPATH_ARRAY = new IPath[0];
    public static final IClasspathEntry[] CLASSPATH_ENTRY_ARRAY = new IClasspathEntry[0];
    public static final IRuntimeClasspathEntry[] RT_CLASSPATH_ENTRY_ARRAY = new IRuntimeClasspathEntry[0];

    public static IJavaProject getJavaProject(IProject project) {
        return JavaCore.create((IProject)project);
    }

    public static void addBpmCoreLibsContainer(IProject project) {
        IJavaProject javaProject = BpmClasspathUtils.getJavaProject(project);
        if (javaProject != null) {
            try {
                boolean containsBpmCoreLibsCpEntry = false;
                ArrayList<IClasspathEntry> cpEntries = new ArrayList<IClasspathEntry>(Arrays.asList(javaProject.getRawClasspath()));
                for (IClasspathEntry entry : cpEntries) {
                    if (!entry.getPath().equals((Object)BpmCoreLibrariesClasspathContainer.PATH_BPM_CORE_LIBS_CP)) continue;
                    containsBpmCoreLibsCpEntry = true;
                }
                if (!containsBpmCoreLibsCpEntry) {
                    int idxJreContainer = -1;
                    int i = 0;
                    while (i < cpEntries.size()) {
                        IClasspathEntry entry = (IClasspathEntry)cpEntries.get(i);
                        if (5 == entry.getEntryKind() && entry.getPath().toString().startsWith(JavaRuntime.JRE_CONTAINER)) {
                            idxJreContainer = i;
                            break;
                        }
                        ++i;
                    }
                    IClasspathEntry bpmCoreLibsEntry = JavaCore.newContainerEntry((IPath)BpmCoreLibrariesClasspathContainer.PATH_BPM_CORE_LIBS_CP, (boolean)false);
                    if (-1 != idxJreContainer) {
                        cpEntries.add(1 + idxJreContainer, bpmCoreLibsEntry);
                    } else {
                        cpEntries.add(bpmCoreLibsEntry);
                    }
                    javaProject.setRawClasspath(cpEntries.toArray(CLASSPATH_ENTRY_ARRAY), null);
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean hasBpmSpringLibsContainer(IProject project) {
        boolean containsBpmSpringLibsCpEntry = false;
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject != null) {
            try {
                ArrayList<IClasspathEntry> cpEntries = new ArrayList<IClasspathEntry>(Arrays.asList(javaProject.getRawClasspath()));
                for (IClasspathEntry entry : cpEntries) {
                    if (!entry.getPath().equals((Object)BpmSpringLibrariesClasspathContainer.PATH_BPM_SPRING_LIBS_CP)) continue;
                    containsBpmSpringLibsCpEntry = true;
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        return containsBpmSpringLibsCpEntry;
    }

    public static void addBpmSpringLibsContainer(IProject project) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject != null) {
            try {
                boolean containsBpmSpringLibsCpEntry = false;
                ArrayList<IClasspathEntry> cpEntries = new ArrayList<IClasspathEntry>(Arrays.asList(javaProject.getRawClasspath()));
                for (IClasspathEntry entry : cpEntries) {
                    if (!entry.getPath().equals((Object)BpmSpringLibrariesClasspathContainer.PATH_BPM_SPRING_LIBS_CP)) continue;
                    containsBpmSpringLibsCpEntry = true;
                }
                if (!containsBpmSpringLibsCpEntry) {
                    int idxBpmCoreContainer = -1;
                    int i = 0;
                    while (i < cpEntries.size()) {
                        IClasspathEntry entry = (IClasspathEntry)cpEntries.get(i);
                        if (5 == entry.getEntryKind() && entry.getPath().toString().startsWith("org.eclipse.stardust.modeling.common.projectnature.carnotBpmCoreLibraries")) {
                            idxBpmCoreContainer = i;
                            break;
                        }
                        ++i;
                    }
                    IClasspathEntry bpmSpringLibsEntry = JavaCore.newContainerEntry((IPath)BpmSpringLibrariesClasspathContainer.PATH_BPM_SPRING_LIBS_CP, (boolean)false);
                    if (-1 != idxBpmCoreContainer) {
                        cpEntries.add(1 + idxBpmCoreContainer, bpmSpringLibsEntry);
                    } else {
                        cpEntries.add(bpmSpringLibsEntry);
                    }
                    javaProject.setRawClasspath(cpEntries.toArray(CLASSPATH_ENTRY_ARRAY), null);
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
    }

    public static void removeBpmCoreLibsContainer(IProject project) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject != null) {
            try {
                boolean containedBpmCoreLibsCpEntry = false;
                ArrayList<IClasspathEntry> cpEntries = new ArrayList<IClasspathEntry>(Arrays.asList(javaProject.getRawClasspath()));
                Iterator i = cpEntries.iterator();
                while (i.hasNext()) {
                    IClasspathEntry entry = (IClasspathEntry)i.next();
                    if (!entry.getPath().equals((Object)BpmCoreLibrariesClasspathContainer.PATH_BPM_CORE_LIBS_CP)) continue;
                    containedBpmCoreLibsCpEntry = true;
                    i.remove();
                }
                if (containedBpmCoreLibsCpEntry) {
                    javaProject.setRawClasspath(cpEntries.toArray(CLASSPATH_ENTRY_ARRAY), null);
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
    }

    public static void removeBpmSpringLibsContainer(IProject project) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject != null) {
            try {
                boolean containedBpmSpringLibsCpEntry = false;
                ArrayList<IClasspathEntry> cpEntries = new ArrayList<IClasspathEntry>(Arrays.asList(javaProject.getRawClasspath()));
                Iterator i = cpEntries.iterator();
                while (i.hasNext()) {
                    IClasspathEntry entry = (IClasspathEntry)i.next();
                    if (!entry.getPath().equals((Object)BpmSpringLibrariesClasspathContainer.PATH_BPM_SPRING_LIBS_CP)) continue;
                    containedBpmSpringLibsCpEntry = true;
                    i.remove();
                }
                if (containedBpmSpringLibsCpEntry) {
                    javaProject.setRawClasspath(cpEntries.toArray(CLASSPATH_ENTRY_ARRAY), null);
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
    }

    public static IClasspathEntry[] getCarnotHomeClasspathEntries(String baseFolder) {
        return BpmClasspathUtils.createClasspathEntries(BpmClasspathUtils.findCarnotHomeClasspathEntries(baseFolder, true));
    }

    public static IRuntimeClasspathEntry[] getCarnotHomeRtClasspathEntries(String baseFolder) {
        return BpmClasspathUtils.createRtClasspathEntries(BpmClasspathUtils.findCarnotHomeClasspathEntries(baseFolder, true));
    }

    public static IClasspathEntry[] getCarnotWorkClasspathEntries(String baseFolder) {
        return BpmClasspathUtils.createClasspathEntries(BpmClasspathUtils.findCarnotWorkClasspathEntries(baseFolder, false));
    }

    public static IRuntimeClasspathEntry[] getCarnotWorkRtClasspathEntries(String baseFolder) {
        return BpmClasspathUtils.createRtClasspathEntries(BpmClasspathUtils.findCarnotWorkClasspathEntries(baseFolder, true));
    }

    public static IPath[] findCarnotHomeClasspathEntries(String baseFolder, boolean includeExt) {
        ArrayList<IPath> entries = new ArrayList<IPath>();
        File homeDir = new File(baseFolder);
        if (homeDir.exists() && homeDir.canRead()) {
            File libDir = new File(homeDir, "lib");
            entries.addAll(Arrays.asList(BpmClasspathUtils.findFilesInFolder(libDir)));
            if (includeExt) {
                entries.addAll(Arrays.asList(BpmClasspathUtils.findFilesInFolder(new File(libDir, "ext"))));
            }
        }
        return entries.toArray(IPATH_ARRAY);
    }

    public static IPath[] findCarnotWorkClasspathEntries(String baseFolder, boolean includeEtc) {
        ArrayList<Object> entries = new ArrayList<Object>();
        File workDir = new File(baseFolder);
        if (workDir.exists() && workDir.canRead()) {
            File libDir = new File(workDir, "lib");
            entries.addAll(Arrays.asList(BpmClasspathUtils.findFilesInFolder(libDir)));
        }
        if (includeEtc) {
            entries.add(new Path(new File(workDir, "etc").getAbsolutePath()));
        }
        return entries.toArray(IPATH_ARRAY);
    }

    public static String retrieveEncodedClasspathEntryHint(IPath entryPath) {
        String result = null;
        if (1 < entryPath.segmentCount()) {
            IPath path = entryPath.removeFirstSegments(1);
            try {
                result = new String(Base64.decode((byte[])path.toString().getBytes()));
            }
            catch (InternalException internalException) {}
        }
        return result;
    }

    public static IPath encodeClasspathEntryHint(IPath firstSegment, String hint) {
        String encodedHint = null;
        try {
            encodedHint = new String(Base64.encode((byte[])hint.getBytes()));
        }
        catch (InternalException internalException) {}
        return !StringUtils.isEmpty(encodedHint) ? firstSegment.append(encodedHint) : firstSegment;
    }

    protected static IPath[] findFilesInFolder(File folder) {
        ArrayList<Path> result = new ArrayList<Path>();
        if (folder.exists() && folder.canRead() && folder.isDirectory()) {
            File[] files = folder.listFiles();
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                if (file.exists() && file.canRead() && file.isFile()) {
                    result.add(new Path(file.getAbsolutePath()));
                }
                ++i;
            }
        }
        return result.toArray(IPATH_ARRAY);
    }

    private static IClasspathEntry[] createClasspathEntries(IPath[] paths) {
        IClasspathEntry[] result = new IClasspathEntry[paths.length];
        int i = 0;
        while (i < paths.length) {
            result[i] = JavaCore.newLibraryEntry((IPath)paths[i], null, null);
            ++i;
        }
        return result;
    }

    protected static IRuntimeClasspathEntry[] createRtClasspathEntries(IPath[] paths) {
        IRuntimeClasspathEntry[] result = new IRuntimeClasspathEntry[paths.length];
        int i = 0;
        while (i < paths.length) {
            result[i] = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)paths[i]);
            ++i;
        }
        return result;
    }
}

