/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.common.projectnature.classpath;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.StandardClasspathProvider;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.modeling.common.projectnature.classpath.BpmClasspathUtils;
import org.eclipse.stardust.modeling.common.projectnature.classpath.BpmCoreLibrariesClasspathContainer;
import org.eclipse.stardust.modeling.common.projectnature.classpath.BpmToolLibrariesClasspathContainer;
import org.eclipse.stardust.modeling.common.projectnature.classpath.CarnotHomeLocationClasspathContainer;
import org.eclipse.stardust.modeling.common.projectnature.classpath.CarnotWorkLocationClasspathContainer;

public class CarnotToolClasspathProvider
extends StandardClasspathProvider {
    public static final String ATTR_HOME_LOCATION = "CARNOT_HOME";
    public static final String ATTR_WORK_LOCATION = "CARNOT_WORK";
    public static final String ATTR_EXTRA_LOCATION = "CARNOT_EXTRA_LOCATION";

    public IRuntimeClasspathEntry[] computeUnresolvedClasspath(ILaunchConfiguration configuration) throws CoreException {
        String extraLocation;
        ArrayList<IRuntimeClasspathEntry> entries = new ArrayList<IRuntimeClasspathEntry>(Arrays.asList(super.computeUnresolvedClasspath(configuration)));
        String homeLocation = configuration.getAttribute(ATTR_HOME_LOCATION, null);
        if (!StringUtils.isEmpty((String)homeLocation)) {
            entries.add(JavaRuntime.newRuntimeContainerClasspathEntry((IPath)BpmClasspathUtils.encodeClasspathEntryHint((IPath)CarnotHomeLocationClasspathContainer.PATH_CARNOT_HOME_LOCATION_CP, homeLocation), (int)3));
        } else {
            entries.add(JavaRuntime.newRuntimeContainerClasspathEntry((IPath)BpmCoreLibrariesClasspathContainer.PATH_BPM_CORE_LIBS_CP, (int)3));
            entries.add(JavaRuntime.newRuntimeContainerClasspathEntry((IPath)BpmToolLibrariesClasspathContainer.PATH_BPM_TOOL_LIBS_CP, (int)3));
        }
        String workLocation = configuration.getAttribute(ATTR_WORK_LOCATION, null);
        if (!StringUtils.isEmpty((String)workLocation)) {
            entries.add(JavaRuntime.newRuntimeContainerClasspathEntry((IPath)BpmClasspathUtils.encodeClasspathEntryHint((IPath)CarnotWorkLocationClasspathContainer.PATH_CARNOT_WORK_LOCATION_CP, workLocation), (int)3));
            File homeDir = new File(homeLocation);
            File springJtaLibDir = new File(homeDir, "lib/spring");
            IPath[] springLibs = BpmClasspathUtils.findFilesInFolder(springJtaLibDir);
            IRuntimeClasspathEntry[] springLibsClasspathEntries = BpmClasspathUtils.createRtClasspathEntries(springLibs);
            entries.addAll(Arrays.asList(springLibsClasspathEntries));
        }
        if (!StringUtils.isEmpty((String)(extraLocation = configuration.getAttribute(ATTR_EXTRA_LOCATION, null)))) {
            entries.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)new Path(extraLocation)));
        }
        return entries.toArray(BpmClasspathUtils.RT_CLASSPATH_ENTRY_ARRAY);
    }
}

