/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.common.ui.jface.utils;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledCombo;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledText;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledViewer;
import org.eclipse.stardust.modeling.common.ui.jface.widgets.LabelWithStatus;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class FormBuilder {
    private static final ArrayContentProvider ARRAY_CONTENT_PROVIDER = new ArrayContentProvider();
    public static final int DEFAULT_TEXT_FIELD_CHARS = 50;

    public static Composite createLabeledControlsComposite(Composite parent) {
        return FormBuilder.createLabeledControlsComposite(parent, 1);
    }

    public static Composite createLabeledControlsComposite(Composite parent, int nLabeledControlsColumns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2 * nLabeledControlsColumns;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)FormBuilder.createDefaultMultiLineWidgetGridData());
        return composite;
    }

    public static Composite createComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)FormBuilder.createDefaultMultiLineWidgetGridData());
        return composite;
    }

    public static Composite createComposite(Composite parent, int numColumns, int span) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)FormBuilder.createDefaultMultiLineWidgetGridData(span));
        return composite;
    }

    public static Combo createCombo(Composite composite) {
        return FormBuilder.createCombo(composite, 1);
    }

    public static Combo createCombo(Composite composite, int span) {
        return FormBuilder.createCombo(composite, 8, span);
    }

    public static Combo createCombo(Composite composite, int style, int span) {
        Combo combo = new Combo(composite, style);
        combo.setLayoutData((Object)FormBuilder.createDefaultSingleLineWidgetGridData(span));
        return combo;
    }

    public static Button createRadioButton(Composite composite, String label) {
        return FormBuilder.createRadioButton(composite, label, 1);
    }

    public static Button createRadioButton(Composite composite, String label, int span) {
        Button button = new Button(composite, 16);
        button.setText(label);
        button.setLayoutData((Object)FormBuilder.createDefaultSingleLineWidgetGridData(span));
        return button;
    }

    public static Group createGroup(Composite composite, String title, int numColumns) {
        return FormBuilder.createGroup(composite, title, numColumns, 1);
    }

    public static Group createGroup(Composite composite, String title, int numColumns, int span) {
        Group group = new Group(composite, 0);
        GridLayout groupLayout = new GridLayout();
        groupLayout.horizontalSpacing = 0;
        groupLayout.numColumns = numColumns;
        group.setLayout((Layout)groupLayout);
        group.setText(title);
        group.setLayoutData((Object)FormBuilder.createDefaultMultiLineWidgetGridData(span));
        return group;
    }

    public static org.eclipse.swt.widgets.List createList(Composite composite) {
        return FormBuilder.createList(composite, 1);
    }

    public static org.eclipse.swt.widgets.List createList(Composite composite, int span) {
        org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List(composite, 2816);
        list.setLayoutData((Object)FormBuilder.createDefaultMultiLineWidgetGridData(span));
        return list;
    }

    public static Label createHorizontalSeparator(Composite composite, int span) {
        Label separator = new Label(composite, 258);
        separator.setLayoutData((Object)FormBuilder.createDefaultSingleLineWidgetGridData(span));
        return separator;
    }

    public static Button createCheckBox(Composite composite, String label) {
        return FormBuilder.createCheckBox(composite, label, 1);
    }

    public static Button createCheckBox(Composite composite, String label, int span) {
        return FormBuilder.createCheckBox(composite, label, FormBuilder.createDefaultButtonGridData(span));
    }

    public static Button createCheckBox(Composite composite, String label, GridData gd) {
        Button checkBox = new Button(composite, 32);
        checkBox.setText(label);
        checkBox.setLayoutData((Object)gd);
        return checkBox;
    }

    public static Button createButton(Composite parent, String label, SelectionListener listener) {
        Button button = new Button(parent, 8);
        if (label != null) {
            button.setText(label);
        }
        Dialog.applyDialogFont((Control)button);
        GridData data = new GridData(4, 4, false, false);
        button.setLayoutData((Object)data);
        FormBuilder.applyDefaultButtonWidth(button);
        if (listener != null) {
            button.addSelectionListener(listener);
        }
        return button;
    }

    public static Text createText(Composite composite) {
        return FormBuilder.createText(composite, 1);
    }

    public static Text createText(Composite composite, boolean password) {
        return FormBuilder.createText(composite, 1, password);
    }

    public static Text createText(Composite composite, int span) {
        return FormBuilder.createText(composite, span, false);
    }

    public static Text createText(Composite composite, int span, boolean password) {
        Text text = new Text(composite, password ? 0x400800 : 2048);
        text.setLayoutData((Object)FormBuilder.createDefaultSingleLineWidgetGridData(span));
        FormBuilder.applyDefaultTextControlWidth((Control)text);
        return text;
    }

    public static Text createTextArea(Composite composite, int span) {
        Text text = new Text(composite, 2626);
        text.setLayoutData((Object)FormBuilder.createDefaultMultiLineWidgetGridData(span));
        FormBuilder.applyDefaultTextControlWidth((Control)text);
        return text;
    }

    public static Tree createTree(Composite composite, int style) {
        Tree tree = new Tree(composite, style);
        tree.setLayoutData((Object)FormBuilder.createDefaultMultiLineWidgetGridData());
        return tree;
    }

    public static Tree createTree(Composite composite, int style, String[] columnNames, final int[] columnSizes, int span) {
        final Tree tree = new Tree(composite, style);
        tree.setLayoutData((Object)FormBuilder.createDefaultMultiLineWidgetGridData());
        tree.setLayoutData((Object)FormBuilder.createDefaultMultiLineWidgetGridData(span));
        if (columnNames != null) {
            tree.setHeaderVisible(true);
            int i = 0;
            while (i < columnSizes.length) {
                TreeColumn column = new TreeColumn(tree, 0);
                column.setText(columnNames[i]);
                ++i;
            }
            tree.addControlListener(new ControlListener(){
                private boolean realized;

                public void controlMoved(ControlEvent e) {
                }

                public void controlResized(ControlEvent e) {
                    if (!this.realized) {
                        Point tableSize = tree.getSize();
                        this.realized = true;
                        int i = 0;
                        while (i < columnSizes.length) {
                            TreeColumn column = tree.getColumn(i);
                            column.setWidth(tableSize.x * columnSizes[i] / 100);
                            ++i;
                        }
                    }
                }
            });
        }
        return tree;
    }

    public static Table createTable(Composite composite, int style, String[] columnNames, int[] columnSizes, int span) {
        return FormBuilder.createTable(composite, style, columnNames, columnSizes, span, false);
    }

    public static Table createTable(Composite composite, int style, String[] columnNames, final int[] columnSizes, int span, final boolean absoluteColumnSizes) {
        final Table table = new Table(composite, style);
        table.setLayoutData((Object)FormBuilder.createDefaultMultiLineWidgetGridData(span));
        if (columnNames != null) {
            table.setHeaderVisible(true);
            int i = 0;
            while (i < columnSizes.length) {
                TableColumn column = new TableColumn(table, 0);
                column.setText(columnNames[i]);
                ++i;
            }
            table.addControlListener(new ControlListener(){
                private boolean realized;

                public void controlMoved(ControlEvent e) {
                }

                public void controlResized(ControlEvent e) {
                    if (!this.realized) {
                        Point tableSize = table.getSize();
                        this.realized = true;
                        int i = 0;
                        while (i < columnSizes.length) {
                            TableColumn column = table.getColumn(i);
                            if (absoluteColumnSizes) {
                                column.setWidth(columnSizes[i]);
                            } else {
                                column.setWidth(tableSize.x * columnSizes[i] / 100);
                            }
                            ++i;
                        }
                    }
                }
            });
        }
        return table;
    }

    public static Table createTable(Composite composite, int style, String title) {
        Table table = new Table(composite, style);
        table.setLayoutData((Object)FormBuilder.createDefaultMultiLineWidgetGridData());
        table.setHeaderVisible(true);
        TableColumn column = new TableColumn(table, 0x1000000);
        column.setText(title);
        return table;
    }

    public static Link createLink(Composite composite, String text) {
        return FormBuilder.createLink(composite, text, 1);
    }

    public static Link createLink(Composite composite, String text, int span) {
        Link link = new Link(composite, 0);
        link.setText(text);
        link.setLayoutData((Object)FormBuilder.createDefaultLabelGridData(span));
        return link;
    }

    public static Label createLabel(Composite composite, String text) {
        return FormBuilder.createLabel(composite, text, 1);
    }

    public static Label createLabel(Composite composite, String text, int span) {
        Label label = new Label(composite, 0);
        label.setText(text);
        label.setLayoutData((Object)FormBuilder.createDefaultLabelGridData(span));
        return label;
    }

    public static Label createLabel(Composite composite, String text, int span, int style) {
        Label label = new Label(composite, style);
        label.setText(text);
        label.setLayoutData((Object)FormBuilder.createDefaultLabelGridData(span));
        return label;
    }

    public static LabelWithStatus createLabelWithLeftAlignedStatus(Composite composite, String name) {
        return FormBuilder.createLabelWithLeftAlignedStatus(composite, name, 1);
    }

    public static LabelWithStatus createLabelWithLeftAlignedStatus(Composite composite, String name, int span) {
        LabelWithStatus label = new LabelWithStatus(composite, name, 16384);
        label.setLayoutData(FormBuilder.createDefaultLabelGridData(span));
        return label;
    }

    public static LabelWithStatus createLabelWithRightAlignedStatus(Composite composite, String name) {
        return FormBuilder.createLabelWithRightAlignedStatus(composite, name, 1);
    }

    public static LabelWithStatus createLabelWithRightAlignedStatus(Composite composite, String name, int span) {
        LabelWithStatus label = new LabelWithStatus(composite, name, 131072);
        label.setLayoutData(FormBuilder.createDefaultLabelGridData(span));
        return label;
    }

    public static LabeledText createLabeledText(Composite composite, String txtLabel) {
        LabelWithStatus label = FormBuilder.createLabelWithRightAlignedStatus(composite, txtLabel);
        Text text = FormBuilder.createText(composite);
        return new LabeledText(text, label);
    }

    public static LabeledText createLabeledText(Composite composite, String txtLabel, boolean password) {
        LabelWithStatus label = FormBuilder.createLabelWithRightAlignedStatus(composite, txtLabel);
        Text text = FormBuilder.createText(composite, password);
        return new LabeledText(text, label);
    }

    public static LabeledText createLabeledTextLeftAlignedStatus(Composite composite, String txtLabel) {
        LabelWithStatus label = FormBuilder.createLabelWithLeftAlignedStatus(composite, txtLabel);
        Text text = FormBuilder.createText(composite);
        return new LabeledText(text, label);
    }

    public static LabeledText createPasswordText(Composite composite, String txtLabel) {
        LabelWithStatus label = FormBuilder.createLabelWithRightAlignedStatus(composite, txtLabel);
        Text text = FormBuilder.createText(composite, true);
        return new LabeledText(text, label);
    }

    public static LabeledCombo createLabeledCombo(Composite composite, String txtLabel) {
        LabelWithStatus label = FormBuilder.createLabelWithRightAlignedStatus(composite, txtLabel);
        Combo combo = FormBuilder.createCombo(composite);
        return new LabeledCombo(combo, label);
    }

    public static LabeledText createLabeledTextArea(Composite composite, String txtLabel) {
        LabelWithStatus label = FormBuilder.createLabelWithLeftAlignedStatus(composite, txtLabel, 2);
        Text text = FormBuilder.createTextArea(composite, 2);
        return new LabeledText(text, label);
    }

    public static GridData createDefaultLabelGridData() {
        return new GridData(4, 0x1000000, false, false);
    }

    public static GridData createDefaultLabelGridData(int horizonalSpan) {
        GridData gd = FormBuilder.createDefaultLabelGridData();
        gd.horizontalSpan = horizonalSpan;
        return gd;
    }

    public static GridData createDefaultSingleLineWidgetGridData() {
        return new GridData(4, 0x1000000, true, false);
    }

    public static GridData createDefaultSingleLineWidgetGridData(int horizonalSpan) {
        GridData gd = FormBuilder.createDefaultSingleLineWidgetGridData();
        gd.horizontalSpan = horizonalSpan;
        return gd;
    }

    public static GridData createDefaultMultiLineWidgetGridData() {
        return new GridData(4, 4, true, true);
    }

    public static GridData createDefaultLimitedMultiLineWidgetGridData(int hHint) {
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = hHint;
        return gd;
    }

    public static GridData createDefaultMultiLineWidgetGridData(int horizonalSpan) {
        GridData gd = FormBuilder.createDefaultMultiLineWidgetGridData();
        gd.horizontalSpan = horizonalSpan;
        return gd;
    }

    public static GridData createDefaultButtonGridData() {
        return new GridData(16384, 0x1000000, false, false);
    }

    public static GridData createDefaultButtonGridData(int horizonalSpan) {
        GridData gd = FormBuilder.createDefaultButtonGridData();
        gd.horizontalSpan = horizonalSpan;
        return gd;
    }

    public static void applyDefaultTextControlWidth(Control control) {
        Object layoutData = control.getLayoutData();
        if (layoutData instanceof GridData) {
            ((GridData)layoutData).widthHint = FormBuilder.getDefaultTextSize(control);
        }
    }

    public static void applyDefaultButtonWidth(Button button) {
        Object layoutData = button.getLayoutData();
        if (layoutData instanceof GridData) {
            Point minButtonSize = button.computeSize(-1, -1, true);
            ((GridData)layoutData).widthHint = Math.max(FormBuilder.getDefaultButtonSize((Control)button.getParent()), minButtonSize.x);
        }
    }

    public static int getDefaultTextSize(Control parent) {
        return FormBuilder.getTextSize(parent, 50);
    }

    public static int getTextSize(Control parent, int numChars) {
        return Dialog.convertWidthInCharsToPixels((FontMetrics)FormBuilder.getFontMetrics(parent), (int)numChars);
    }

    public static int getDefaultButtonSize(Control parent) {
        return Dialog.convertHorizontalDLUsToPixels((FontMetrics)FormBuilder.getFontMetrics(parent), (int)61);
    }

    public static FontMetrics getFontMetrics(Control parent) {
        GC gc = new GC((Drawable)parent);
        gc.setFont(parent.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        return fontMetrics;
    }

    public static void defaultControlLayout(Control control) {
        control.setLayoutData((Object)FormBuilder.createDefaultSingleLineWidgetGridData());
        FormBuilder.applyDefaultTextControlWidth(control);
    }

    public static LabeledViewer createComboViewer(Composite parent, String label, List<?> values) {
        LabeledCombo targetCombo = FormBuilder.createLabeledCombo(parent, label);
        ComboViewer targetViewer = new ComboViewer(targetCombo.getCombo());
        targetViewer.setContentProvider((IContentProvider)ARRAY_CONTENT_PROVIDER);
        targetViewer.setInput(values);
        return new LabeledViewer((StructuredViewer)targetViewer, targetCombo.getLabel());
    }

    public static ComboViewer createComboViewer(Composite parent, List<?> values) {
        Combo targetCombo = FormBuilder.createCombo(parent);
        ComboViewer targetViewer = new ComboViewer(targetCombo);
        targetViewer.setContentProvider((IContentProvider)ARRAY_CONTENT_PROVIDER);
        targetViewer.setInput(values);
        return targetViewer;
    }
}

