/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.common.ui.swt;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class MultiLineTableCellListener
implements Listener {
    Table table;

    public MultiLineTableCellListener(Table table) {
        this.table = table;
        table.addListener(41, (Listener)this);
        table.addListener(42, (Listener)this);
        table.addListener(40, (Listener)this);
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 41: {
                TableItem item = (TableItem)event.item;
                String text = this.getText(item, event.index);
                Point size = event.gc.textExtent(text);
                event.width = size.x;
                event.height = Math.max(event.height, size.y);
                break;
            }
            case 42: {
                TableItem item = (TableItem)event.item;
                String text = this.getText(item, event.index);
                Point size = event.gc.textExtent(text);
                int offset2 = event.index == 0 ? Math.max(0, (event.height - size.y) / 2) : 0;
                event.gc.drawText(text, event.x, event.y + offset2, true);
                break;
            }
            case 40: {
                event.detail &= 0xFFFFFFEF;
            }
        }
    }

    private String getText(TableItem item, int column) {
        String text = item.getText(column);
        return text;
    }
}

