/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.common.worktime;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import org.eclipse.stardust.common.log.LogManager;
import org.eclipse.stardust.common.log.Logger;
import org.eclipse.stardust.modeling.common.worktime.Holiday;

public class Holidays {
    private static final Logger log = LogManager.getLogger(Holidays.class);
    public static Holidays[] HOLIDAYS = new Holidays[]{new Holidays(2001), new Holidays(2002), new Holidays(2003), new Holidays(2004), new Holidays(2005), new Holidays(2006), new Holidays(2007), new Holidays(2008), new Holidays(2009), new Holidays(2010), new Holidays(2011), new Holidays(2012), new Holidays(2013), new Holidays(2014), new Holidays(2015), new Holidays(2016), new Holidays(2017), new Holidays(2018), new Holidays(2019), new Holidays(2020), new Holidays(2021), new Holidays(2022), new Holidays(2023), new Holidays(2024), new Holidays(2025), new Holidays(2026), new Holidays(2027), new Holidays(2028), new Holidays(2029), new Holidays(2030)};
    private List<Holiday> days = new ArrayList<Holiday>(34);

    public Holidays(int year) {
        log.debug((Object)("Creating holidays for year " + year));
        GregorianCalendar eastern = Holidays.eastern(year);
        this.days.add(new Holiday("Neujahr", new GregorianCalendar(year, 0, 1).getTimeInMillis(), true, true, null));
        this.days.add(new Holiday("Heilige drei K\ufffdnige", new GregorianCalendar(year, 0, 6).getTimeInMillis(), true, true, new String[]{"Bayern", "Baden-Wuerttemberg", "Sachsen-Anhalt"}));
        GregorianCalendar temp = (GregorianCalendar)eastern.clone();
        temp.add(5, -2);
        this.days.add(new Holiday("Karfreitag", temp.getTimeInMillis(), true, true, null));
        temp.add(5, 2);
        this.days.add(new Holiday("Ostersonntag", temp.getTimeInMillis(), true, true, null));
        temp.add(5, 1);
        this.days.add(new Holiday("Ostermontag", temp.getTimeInMillis(), true, true, null));
        this.days.add(new Holiday("Tag der Arbeit", new GregorianCalendar(year, 4, 1).getTimeInMillis(), true, true, null));
        temp = (GregorianCalendar)eastern.clone();
        temp.add(5, 39);
        this.days.add(new Holiday("Himmelfahrt", temp.getTimeInMillis(), true, true, null));
        temp = (GregorianCalendar)eastern.clone();
        temp.add(5, 49);
        this.days.add(new Holiday("Pfingssonntag", temp.getTimeInMillis(), true, true, null));
        temp.add(5, 1);
        this.days.add(new Holiday("Pfingsmontag", temp.getTimeInMillis(), true, true, null));
        temp = (GregorianCalendar)eastern.clone();
        temp.add(5, 60);
        this.days.add(new Holiday("Fronleichnam", temp.getTimeInMillis(), true, true, new String[]{"Bayern", "Baden-Wuerttemberg", "Nordrhein-Westfalen", "Hessen", "Rheinland-Pfalz", "Saarland", "Sachsen", "Thueringen"}));
        this.days.add(new Holiday("Tag der deutschen Einheit", new GregorianCalendar(year, 9, 3).getTimeInMillis(), true, true, null));
        this.days.add(new Holiday("Reformationstag", new GregorianCalendar(year, 9, 31).getTimeInMillis(), true, true, new String[]{"Brandenburg", "Mecklenburg-Vorpommern", "Sachsen", "Sachsen-Anhalt", "Thueringen"}));
        this.days.add(new Holiday("Allerheiligen", new GregorianCalendar(year, 10, 1).getTimeInMillis(), true, true, new String[]{"Baden-Wuerttemberg", "Bayern", "Nordrhein-Westfalen", "Rheinland-Pfalz", "Saarland"}));
        this.days.add(new Holiday("Heiligabend", new GregorianCalendar(year, 11, 24).getTimeInMillis(), true, true, null));
        this.days.add(new Holiday("1. Weihnachtstag", new GregorianCalendar(year, 11, 25).getTimeInMillis(), true, true, null));
        this.days.add(new Holiday("2. Weihnachtstage", new GregorianCalendar(year, 11, 26).getTimeInMillis(), true, true, null));
    }

    public static boolean isNationalHoliday(Calendar day) {
        Holiday calendarDay = Holidays.getHolidaysForYear(day).findHoliday(day);
        return calendarDay != null;
    }

    public static boolean isRegionalHoliday(Calendar day, String region) {
        Holiday calendarDay = Holidays.getHolidaysForYear(day).findHoliday(day);
        if (calendarDay == null) {
            return false;
        }
        if (calendarDay.getStates() == null) {
            return true;
        }
        int n = 0;
        while (n < calendarDay.getStates().length) {
            if (calendarDay.getStates()[n].equals(region)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private Holiday findHoliday(Calendar day) {
        int n = 0;
        while (n < this.days.size()) {
            Holiday currentDay = this.days.get(n);
            if (currentDay.getTime() == day.getTimeInMillis()) {
                log.debug((Object)("Day found " + currentDay.getName()));
                return currentDay;
            }
            ++n;
        }
        return null;
    }

    private static Holidays getHolidaysForYear(Calendar day) {
        int year = day.get(1);
        if (year < 2001 || year > 2030) {
            throw new UnsupportedOperationException("Year " + year + " is not supported.");
        }
        return HOLIDAYS[year - 2001];
    }

    private static GregorianCalendar eastern(int year) {
        int a = year % 19;
        int b = year / 100;
        int c = year % 100;
        int d = b / 4;
        int e = b % 4;
        int f = (b + 8) / 25;
        int g = (b - f + 1) / 3;
        int h = (19 * a + b - d - g + 15) % 30;
        int i = c / 4;
        int j = c % 4;
        int k = (32 + 2 * e + 2 * i - h - j) % 7;
        int l = (a + 11 * h + 22 * k) / 451;
        int x = h + k - 7 * l + 114;
        int mon = x / 31;
        int tag = x % 31 + 1;
        return new GregorianCalendar(year, mon - 1, tag);
    }
}

