/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core;

import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.marker.ActivityResolutionGenerator;
import org.eclipse.stardust.modeling.core.marker.ConditionalPerformerResolutionGenerator;
import org.eclipse.stardust.modeling.core.marker.DanglingReferencesResolutionGenerator;
import org.eclipse.stardust.modeling.core.marker.DataMappingResolutionGenerator;
import org.eclipse.stardust.modeling.core.marker.DataResolutionGenerator;
import org.eclipse.stardust.modeling.core.marker.DiagramResolutionGenerator;
import org.eclipse.stardust.modeling.core.marker.IResolutionGenerator;
import org.eclipse.stardust.modeling.core.marker.IdentifiableResolutionGenerator;
import org.eclipse.stardust.modeling.core.marker.ModelResolutionGenerator;
import org.eclipse.stardust.modeling.core.marker.OrganizationResolutionGenerator;
import org.eclipse.stardust.modeling.core.marker.ProcessDefinitionResolutionGenerator;
import org.eclipse.stardust.modeling.core.marker.ReferencingModelIDMismatchResolutionGenerator;
import org.eclipse.stardust.modeling.core.marker.TransitionResolutionGenerator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationService;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class MarkerResolutionGenerator
implements IMarkerResolutionGenerator2 {
    private IResolutionGenerator[] generators = new IResolutionGenerator[]{new IdentifiableResolutionGenerator(), new ActivityResolutionGenerator(), new DataMappingResolutionGenerator(), new DiagramResolutionGenerator(), new ConditionalPerformerResolutionGenerator(), new TransitionResolutionGenerator(), new ProcessDefinitionResolutionGenerator(), new DataResolutionGenerator(), new OrganizationResolutionGenerator(), new ModelResolutionGenerator(), new DanglingReferencesResolutionGenerator(), new ReferencingModelIDMismatchResolutionGenerator()};

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasResolutions(IMarker marker) {
        try {
            if (!"org.eclipse.stardust.modeling.validation.wfModelValidationMarker".equals(marker.getType())) return false;
            Issue issue = ValidationService.getInstance().resolveMapping(marker);
            if (issue == null) {
                return false;
            }
            ModelType model = ModelUtils.findContainingModel((EObject)issue.getModelElement());
            WorkflowModelEditor editor = MarkerResolutionGenerator.getWorkflowModelEditor(model);
            if (editor == null) return false;
            int i = 0;
            while (true) {
                if (i >= this.generators.length) {
                    return false;
                }
                IResolutionGenerator generator = this.generators[i];
                if (generator.hasResolutions(editor, issue)) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public IMarkerResolution[] getResolutions(IMarker marker) {
        try {
            Issue issue;
            ModelType model;
            WorkflowModelEditor editor;
            if ("org.eclipse.stardust.modeling.validation.wfModelValidationMarker".equals(marker.getType()) && (editor = MarkerResolutionGenerator.getWorkflowModelEditor(model = ModelUtils.findContainingModel((EObject)(issue = ValidationService.getInstance().resolveMapping(marker)).getModelElement()))) != null) {
                List list = CollectionUtils.newList();
                int i = 0;
                while (i < this.generators.length) {
                    IResolutionGenerator generator = this.generators[i];
                    if (generator.hasResolutions(editor, issue)) {
                        generator.addResolutions(list, editor, issue);
                    }
                    ++i;
                }
                return list.toArray(new IMarkerResolution[list.size()]);
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public static WorkflowModelEditor getWorkflowModelEditor(ModelType model) {
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchWindow window = windows[i];
            IWorkbenchPage[] pages = window.getPages();
            int j = 0;
            while (j < pages.length) {
                IWorkbenchPage page = pages[j];
                IEditorReference[] editors = page.getEditorReferences();
                int k = 0;
                while (k < editors.length) {
                    IWorkbenchPart part = editors[k].getPart(false);
                    if (part instanceof WorkflowModelEditor && model == ((WorkflowModelEditor)part).getWorkflowModel()) {
                        return (WorkflowModelEditor)part;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }
}

