/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.modeling.core.editors.DynamicConnectionCommand;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.modelserver.ModelServer;

public class DynamicConnectionFactory
implements CreationFactory {
    private DynamicConnectionCommand cmd;
    private WorkflowModelEditor editor;
    private String targetAnchorType;
    private String sourceAnchorType;

    public DynamicConnectionFactory(WorkflowModelEditor editor) {
        this.editor = editor;
    }

    public Command getStartCommand(INodeSymbol sourceSymbol) {
        ModelServer server = this.editor.getModelServer();
        if (server != null && server.requireLock((EObject)sourceSymbol)) {
            return null;
        }
        this.cmd = new DynamicConnectionCommand(this.editor);
        this.cmd.setSourceSymbol(sourceSymbol);
        this.cmd.setSourceAnchorType(this.sourceAnchorType);
        this.cmd.setTargetAnchorType(this.targetAnchorType);
        return this.cmd.canExecute() ? this.cmd : null;
    }

    public Command getCompleteCommand(INodeSymbol targetSymbol) {
        this.cmd.setTargetSymbol(targetSymbol);
        return this.cmd;
    }

    public Object getNewObject() {
        return this;
    }

    public Object getObjectType() {
        return CarnotWorkflowModelPackage.eINSTANCE.getIConnectionSymbol();
    }

    public void setTargetAnchorType(String anchorType) {
        this.targetAnchorType = anchorType;
        if (this.cmd != null) {
            this.cmd.setTargetAnchorType(anchorType);
        }
    }

    public void setSourceAnchorType(String anchorType) {
        this.sourceAnchorType = anchorType;
        if (this.cmd != null) {
            this.cmd.setSourceAnchorType(anchorType);
        }
    }
}

