/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.dnd;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.CompareHelper;
import org.eclipse.stardust.common.Pair;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.ConditionalPerformerType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.FlowControlType;
import org.eclipse.stardust.model.xpdl.carnot.GatewaySymbol;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IGraphicalObject;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ISymbolContainer;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ModelerType;
import org.eclipse.stardust.model.xpdl.carnot.OrganizationType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.RoleType;
import org.eclipse.stardust.model.xpdl.carnot.TriggerType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.util.IObjectReference;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlPackage;
import org.eclipse.stardust.modeling.common.ui.IdFactory;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.dnd.IGatewayLocator;
import org.eclipse.stardust.modeling.core.editors.dnd.SymbolCreationFactory;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractNodeSymbolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.ReloadConnectionsAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.UpdateDiagramAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CompoundDiagramCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CreateConnectionSymbolCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CreateSymbolCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DelegateCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DelegatingCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.policies.SymbolContainerLayoutEditPolicy;
import org.eclipse.stardust.modeling.repository.common.ConnectionManager;
import org.eclipse.stardust.modeling.repository.common.IObjectDescriptor;
import org.eclipse.stardust.modeling.repository.common.descriptors.ModelElementDescriptor;

public class ModelElementSymbolCreationFactory {
    private static CarnotWorkflowModelPackage PKG = CarnotWorkflowModelPackage.eINSTANCE;
    private static XpdlPackage XPKG = XpdlPackage.eINSTANCE;

    public static SymbolCreationFactory getFactory(Object transferElement) {
        return ModelElementSymbolCreationFactory.getFactory(transferElement, null);
    }

    public static SymbolCreationFactory getFactory(final Object transferElement, final IGatewayLocator locator) {
        final EClass eClass = ModelElementSymbolCreationFactory.getSymbolEClass(transferElement);
        return new SymbolCreationFactory(){

            public Object getNewObject() {
                if (eClass == null) {
                    return UnexecutableCommand.INSTANCE;
                }
                final boolean hasConnectionToReload = eClass == CarnotWorkflowModelPackage.eINSTANCE.getActivitySymbolType() || eClass == CarnotWorkflowModelPackage.eINSTANCE.getOrganizationSymbolType() || eClass == CarnotWorkflowModelPackage.eINSTANCE.getRoleSymbolType() || eClass == CarnotWorkflowModelPackage.eINSTANCE.getApplicationSymbolType();
                CompoundDiagramCommand compound = new CompoundDiagramCommand(Diagram_Messages.DIAGRAM_CreateSymbol);
                if (transferElement instanceof IObjectDescriptor) {
                    ModelType model = this.editor.getWorkflowModel();
                    ConnectionManager cm = this.editor.getConnectionManager();
                    try {
                        Command cmd = cm.linkObject(model, new IObjectDescriptor[]{(IObjectDescriptor)transferElement});
                        if (cmd == null) {
                            return UnexecutableCommand.INSTANCE;
                        }
                        compound.add(cmd);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                final DelegateCommand update = new DelegateCommand();
                final DelegateCommand reload = new DelegateCommand();
                final IdFactory id = new IdFactory("Symbol", Diagram_Messages.BASENAME_Symbol, null);
                CreateSymbolCommand cmd = new CreateSymbolCommand(0, id, eClass){

                    @Override
                    public void execute() {
                        if (transferElement instanceof IObjectDescriptor) {
                            ModelType model = editor.getWorkflowModel();
                            Object content = null;
                            content = CarnotWorkflowModelPackage.eINSTANCE.getDataSymbolType() == eClass ? model.getData().iterator() : model.eAllContents();
                            modelElement = ModelElementSymbolCreationFactory.findMatchingItem((IObjectDescriptor)transferElement, (Iterator<? extends EObject>)content);
                        }
                        id.setReferingElement((IIdentifiableModelElement)modelElement);
                        ISymbolContainer container = this.getSymbolContainer();
                        this.setTargetEditPart(editor.findEditPart(container));
                        this.setTransferElement(transferElement);
                        super.execute();
                        if (hasConnectionToReload && reloadConnections) {
                            DelegateCommand delegate = new DelegateCommand(){

                                @Override
                                public void execute() {
                                    super.execute();
                                    this.setReloadConnectionsCommand(reload, (INodeSymbol)this.getModelElement());
                                }
                            };
                            update.setDelegate(delegate);
                            this.setUpdateDiagramCommand(delegate, (INodeSymbol)this.getModelElement(), locator);
                        }
                    }
                };
                cmd.setParent((EObject)this.symbolContainer);
                cmd.setLocation(new Rectangle(this.dropLocation.x, this.dropLocation.y, -1, -1));
                compound.add(cmd);
                if (hasConnectionToReload) {
                    compound.add(update);
                    compound.add(reload);
                }
                return compound;
            }

            private void setUpdateDiagramCommand(DelegateCommand compound, final INodeSymbol symbol, final IGatewayLocator locator2) {
                UpdateDiagramAction update = new UpdateDiagramAction(this.editor){

                    protected List<?> getSelectedObjects() {
                        return Collections.singletonList(editor.findEditPart(ModelUtils.findContainingDiagram((IGraphicalObject)symbol)));
                    }

                    @Override
                    protected Dimension getGatewayDelta(FlowControlType flowType, Dimension activitySize, int gatewaySize) {
                        if (locator2 != null) {
                            return locator2.getGatewayLocation(flowType, activitySize, gatewaySize);
                        }
                        return IGatewayLocator.getDefaultLocator(symbol).getGatewayLocation(flowType, activitySize, gatewaySize);
                    }

                    @Override
                    public Command createGatewayUpdateCommand(final GatewaySymbol[] gateway) {
                        return new DelegatingCommand(){

                            @Override
                            public Command createDelegate() {
                                ISymbolContainer container = this.getSymbolContainer();
                                WorkflowModelEditor editor = this.getEditor();
                                AbstractGraphicalEditPart host = (AbstractGraphicalEditPart)editor.findEditPart(container);
                                AbstractNodeSymbolEditPart part = (AbstractNodeSymbolEditPart)editor.findEditPart(gateway[0]);
                                Point location = new Point((double)gateway[0].getXPos(), (double)gateway[0].getYPos());
                                return SymbolContainerLayoutEditPolicy.getSnapToGridCommand(host, (INodeSymbol)gateway[0], location, part);
                            }
                        };
                    }
                };
                update.runEmbedded(compound);
            }

            private void setReloadConnectionsCommand(DelegateCommand compound, final INodeSymbol symbol) {
                ReloadConnectionsAction reload = new ReloadConnectionsAction(this.editor){

                    protected List<?> getSelectedObjects() {
                        return Collections.singletonList(editor.findEditPart(symbol));
                    }
                };
                CompoundCommand command = reload.createReloadCommand();
                ConnectionFilter connectionFilter = new ConnectionFilter(this.editor, symbol);
                connectionFilter.filter(command);
                if (!command.isEmpty()) {
                    compound.setDelegate((Command)command);
                }
            }
        };
    }

    public static EClass getSymbolEClass(Object transferElement) {
        EClass eClass = null;
        if (transferElement instanceof IObjectDescriptor) {
            transferElement = ((IObjectDescriptor)transferElement).getType();
        }
        if (transferElement instanceof ActivityType || PKG.getActivityType().equals(transferElement)) {
            eClass = PKG.getActivitySymbolType();
        } else if (transferElement instanceof ApplicationType || PKG.getApplicationType().equals(transferElement)) {
            eClass = PKG.getApplicationSymbolType();
        } else if (transferElement instanceof ProcessDefinitionType || PKG.getProcessDefinitionType().equals(transferElement)) {
            eClass = PKG.getProcessSymbolType();
        } else if (transferElement instanceof DataType || PKG.getDataType().equals(transferElement)) {
            eClass = PKG.getDataSymbolType();
        } else if (transferElement instanceof TypeDeclarationType || XPKG.getTypeDeclarationType().equals(transferElement)) {
            eClass = PKG.getDataSymbolType();
        } else if (transferElement instanceof RoleType || PKG.getRoleType().equals(transferElement)) {
            eClass = PKG.getRoleSymbolType();
        } else if (transferElement instanceof OrganizationType || PKG.getOrganizationType().equals(transferElement)) {
            eClass = PKG.getOrganizationSymbolType();
        } else if (transferElement instanceof ConditionalPerformerType || PKG.getConditionalPerformerType().equals(transferElement)) {
            eClass = PKG.getConditionalPerformerSymbolType();
        } else if (transferElement instanceof ModelerType || PKG.getModelerType().equals(transferElement)) {
            eClass = PKG.getModelerSymbolType();
        } else if (transferElement instanceof TriggerType || PKG.getTriggerType().equals(transferElement)) {
            eClass = PKG.getStartEventSymbol();
        }
        return eClass;
    }

    public static EObject findMatchingItem(IObjectDescriptor descriptor, Iterator<? extends EObject> elements) {
        IIdentifiableModelElement identifiable = null;
        IIdentifiableModelElement similar = null;
        while (elements.hasNext()) {
            EObject object = elements.next();
            if (object instanceof IIdentifiableModelElement) {
                if (ModelElementSymbolCreationFactory.matchesURI((IIdentifiableModelElement)object, descriptor)) {
                    identifiable = (IIdentifiableModelElement)object;
                    continue;
                }
                if (!ModelElementSymbolCreationFactory.isSimilar((IIdentifiableModelElement)object, descriptor)) continue;
                similar = (IIdentifiableModelElement)object;
                continue;
            }
            if (!(object instanceof TypeDeclarationType) || !CompareHelper.areEqual((Object)((IObjectReference)descriptor).getId(), (Object)((TypeDeclarationType)object).getId())) continue;
            similar = (TypeDeclarationType)object;
        }
        return identifiable == null ? similar : identifiable;
    }

    private static boolean isSimilar(IIdentifiableModelElement element, IObjectDescriptor descriptor) {
        if (descriptor instanceof ModelElementDescriptor) {
            return ModelElementSymbolCreationFactory.isSimilar(((ModelElementDescriptor)descriptor).getIdentifiable(), element);
        }
        return false;
    }

    private static boolean isSimilar(IIdentifiableModelElement identifiable, IIdentifiableModelElement other) {
        return CompareHelper.areEqual((Object)other.eClass(), (Object)identifiable.eClass()) && CompareHelper.areEqual((Object)other.getId(), (Object)identifiable.getId());
    }

    private static boolean matchesURI(IIdentifiableModelElement element, IObjectDescriptor descriptor) {
        if (element.eIsProxy() && element instanceof InternalEObject) {
            return CompareHelper.areEqual((Object)descriptor.getURI(), (Object)((InternalEObject)element).eProxyURI());
        }
        String uri = AttributeUtil.getAttributeValue((IExtensibleElement)element, (String)"carnot:connection:uri");
        if (uri != null) {
            Object classifier = descriptor.getType();
            if (XpdlPackage.eINSTANCE.getTypeDeclarationType() == classifier) {
                classifier = CarnotWorkflowModelPackage.eINSTANCE.getDataType();
            }
            return element.eClass().equals(classifier) && descriptor.getURI() != null && uri.equals(descriptor.getURI().toString());
        }
        return false;
    }

    private static class ConnectionFilter {
        private WorkflowModelEditor editor;
        private INodeSymbol symbol;
        private boolean userWasAsked = false;
        private boolean onlyClosest = false;
        private Map<EClass, Pair<List<Command>, CreateConnectionSymbolCommand>> connectionMap = CollectionUtils.newMap();
        private int returnCode = -1;

        public ConnectionFilter(WorkflowModelEditor editor, INodeSymbol symbol) {
            this.editor = editor;
            this.symbol = symbol;
        }

        public void filter(CompoundCommand compoundCommand) {
            List commands = compoundCommand.getCommands();
            int commandCounter = commands.size() - 1;
            while (commandCounter >= 0) {
                Command command = (Command)commands.get(commandCounter);
                if (command instanceof CreateConnectionSymbolCommand) {
                    if (!this.isValidCommand(commands, (CreateConnectionSymbolCommand)command)) {
                        commands.remove(commandCounter);
                    }
                } else if (command instanceof CompoundCommand) {
                    this.filter((CompoundCommand)command);
                    if (((CompoundCommand)command).isEmpty()) {
                        commands.remove(commandCounter);
                    }
                }
                --commandCounter;
            }
        }

        private boolean isValidClass(EClass eClass) {
            return eClass == CarnotWorkflowModelPackage.eINSTANCE.getTransitionConnectionType() || eClass == CarnotWorkflowModelPackage.eINSTANCE.getPartOfConnectionType() || eClass == CarnotWorkflowModelPackage.eINSTANCE.getWorksForConnectionType() || eClass == CarnotWorkflowModelPackage.eINSTANCE.getPerformsConnectionType() || eClass == CarnotWorkflowModelPackage.eINSTANCE.getTeamLeadConnectionType() || eClass == CarnotWorkflowModelPackage.eINSTANCE.getExecutedByConnectionType();
        }

        private boolean isValidCommand(List<Command> commands, CreateConnectionSymbolCommand command) {
            EClass eClass = command.getEClass();
            if (!this.isValidClass(eClass)) {
                return false;
            }
            INodeSymbol other = command.getSourceSymbol();
            if (other == this.symbol) {
                other = command.getTargetSymbol();
            }
            if (other == this.symbol) {
                return false;
            }
            if (other instanceof IModelElementNodeSymbol && (!this.userWasAsked || this.onlyClosest)) {
                double otherDistance2;
                Pair pair = this.connectionMap.get(eClass);
                if (pair == null) {
                    pair = new Pair(commands, (Object)command);
                    this.connectionMap.put(eClass, (Pair<List<Command>, CreateConnectionSymbolCommand>)pair);
                }
                if (!this.userWasAsked) {
                    MessageDialog dialog = new MessageDialog(this.editor.getSite().getShell(), Diagram_Messages.DIA_MULTIPLE_CONNECTION_DETECTED, null, Diagram_Messages.DIA_DO_YOU_WANT_TO_CREATE_CONNECTION_TO_ALL_SYMBOLS_NOR_TO_THE_CLOSEST_CLOSSEST_SYMBOL_ONLY, 3, new String[]{Diagram_Messages.MSG_DIA_NONE, Diagram_Messages.MSG_DIA_ALL_SYMBOLS, Diagram_Messages.MSG_DIA_CLOSEST_ONLY}, 0);
                    this.returnCode = dialog.open();
                    this.userWasAsked = true;
                    if (this.returnCode <= 0) {
                        return false;
                    }
                    boolean bl = this.onlyClosest = this.returnCode == 2;
                    if (!this.onlyClosest) {
                        return true;
                    }
                }
                CreateConnectionSymbolCommand otherCommand = (CreateConnectionSymbolCommand)pair.getSecond();
                double distance2 = this.getDistance2(command.getSourceSymbol(), command.getTargetSymbol());
                if (distance2 < (otherDistance2 = this.getDistance2(otherCommand.getSourceSymbol(), otherCommand.getTargetSymbol()))) {
                    List otherCommands = (List)pair.getFirst();
                    otherCommands.remove(otherCommand);
                    pair = new Pair(commands, (Object)command);
                    this.connectionMap.put(eClass, (Pair<List<Command>, CreateConnectionSymbolCommand>)pair);
                } else {
                    return false;
                }
            }
            return !this.userWasAsked || this.returnCode > 0;
        }

        private double getDistance2(INodeSymbol first, INodeSymbol second) {
            if (first.eContainer() != second.eContainer()) {
                return Double.MAX_VALUE;
            }
            EditPart firstEP = this.editor.findEditPart(first);
            EditPart secondEP = this.editor.findEditPart(second);
            if (firstEP instanceof GraphicalEditPart && secondEP instanceof GraphicalEditPart) {
                Rectangle fixed;
                Rectangle firstBounds = ((GraphicalEditPart)firstEP).getFigure().getBounds().getCopy();
                Rectangle secondBounds = ((GraphicalEditPart)secondEP).getFigure().getBounds().getCopy();
                Object object = first == this.symbol ? firstBounds : (fixed = second == this.symbol ? secondBounds : null);
                if (fixed != null) {
                    fixed.x -= fixed.width / 2;
                    fixed.y -= fixed.height / 2;
                }
                double dx1 = firstBounds.x - secondBounds.x;
                dx1 *= dx1;
                double dx2 = firstBounds.x - secondBounds.right();
                dx2 *= dx2;
                double dx3 = firstBounds.right() - secondBounds.x;
                dx3 *= dx3;
                double dx4 = firstBounds.right() - secondBounds.right();
                dx4 *= dx4;
                double minX = Math.min(Math.min(dx1, dx2), Math.min(dx3, dx4));
                double dy1 = firstBounds.y - secondBounds.y;
                dy1 *= dy1;
                double dy2 = firstBounds.y - secondBounds.bottom();
                dy2 *= dy2;
                double dy3 = firstBounds.bottom() - secondBounds.y;
                dy3 *= dy3;
                double dy4 = firstBounds.bottom() - secondBounds.bottom();
                dy4 *= dy4;
                double minY = Math.min(Math.min(dy1, dy2), Math.min(dy3, dy4));
                double dist = minX + minY;
                return dist;
            }
            double dx = first.getXPos() - second.getXPos();
            double dy = first.getYPos() - second.getYPos();
            double dist = dx * dx + dy * dy;
            return dist;
        }
    }
}

