/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.dnd;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.dnd.AbstractTransferDropTargetListener;
import org.eclipse.gef.dnd.SimpleObjectTransfer;
import org.eclipse.stardust.common.reflect.Reflect;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.ISymbolContainer;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.util.IObjectReference;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlPackage;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.dnd.CreateSymbolRequest;
import org.eclipse.stardust.modeling.core.editors.dnd.ModelElementTransfer;
import org.eclipse.stardust.modeling.core.editors.parts.tree.ModelTreeEditPart;
import org.eclipse.stardust.modeling.core.modelserver.ModelServerUtils;
import org.eclipse.stardust.modeling.repository.common.ConnectionManager;
import org.eclipse.stardust.modeling.repository.common.IObjectDescriptor;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Tree;

public class ModelElementTransferDropTargetListener
extends AbstractTransferDropTargetListener {
    private static CarnotWorkflowModelPackage PKG = CarnotWorkflowModelPackage.eINSTANCE;
    private static XpdlPackage XPKG = XpdlPackage.eINSTANCE;
    private WorkflowModelEditor editor;
    private boolean isEnabled;
    private boolean isChild;

    public ModelElementTransferDropTargetListener(WorkflowModelEditor editor, EditPartViewer viewer) {
        super(viewer, (Transfer)ModelElementTransfer.getInstance());
        this.editor = editor;
    }

    protected void updateTargetRequest() {
        ((CreateSymbolRequest)this.getTargetRequest()).setLocation(this.getDropLocation());
    }

    protected void updateTargetEditPart() {
        super.updateTargetEditPart();
        if (this.getTargetEditPart() != null && this.getTargetEditPart().getModel() instanceof ISymbolContainer) {
            ((CreateSymbolRequest)this.getTargetRequest()).setSymbolContainer((ISymbolContainer)this.getTargetEditPart().getModel());
        }
    }

    protected Request createTargetRequest() {
        return new CreateSymbolRequest(this.editor, (ModelElementTransfer)this.getTransfer(), this.getViewer().getEditDomain());
    }

    protected void handleDragOver() {
        this.getCurrentEvent().detail = 1;
        super.handleDragOver();
    }

    public boolean isEnabled(DropTargetEvent event) {
        Object object = ((SimpleObjectTransfer)this.getTransfer()).getObject();
        if (object instanceof TransitionType) {
            return false;
        }
        if (object instanceof IObjectDescriptor && object instanceof IObjectReference) {
            Boolean lockedByCurrentUser;
            IObjectDescriptor descriptor = (IObjectDescriptor)object;
            String uri = String.valueOf(descriptor.getURI().scheme().toString()) + "://" + descriptor.getURI().authority() + "/";
            ModelType model = this.editor.getWorkflowModel();
            ConnectionManager cm = this.editor.getConnectionManager();
            if (cm.mustLink(descriptor) && ModelUtils.referenceToAnotherVersionExists((ModelType)model, (String)uri)) {
                return false;
            }
            if (this.editor.getModelServer().isModelShared() && (lockedByCurrentUser = ModelServerUtils.isLockedByCurrentUser((EObject)model)) != null && lockedByCurrentUser.equals(Boolean.FALSE)) {
                return false;
            }
        }
        CreateSymbolRequest request = (CreateSymbolRequest)this.getTargetRequest();
        this.isEnabled = super.isEnabled(event) && request.isEnabled();
        boolean bl = this.isChild = !this.isEnabled && !request.isLockRequired() && this.isChildCreated();
        return this.isEnabled || this.isChild;
    }

    protected void handleDrop() {
        if (this.isChild) {
            CreateSymbolRequest request = (CreateSymbolRequest)this.getTargetRequest();
            Object transferElement = ((ModelElementTransfer)this.getTransfer()).getObject();
            if (transferElement instanceof IObjectDescriptor) {
                request.setFactoryForDescriptor((IObjectDescriptor)transferElement);
            } else {
                request.setFactoryForProcess((ProcessDefinitionType)transferElement);
            }
        }
        super.handleDrop();
        this.refreshTree();
        this.editor.setFocus();
    }

    private void refreshTree() {
        Tree tree = (Tree)Reflect.getFieldValue((Object)((Object)this.editor.getOutlinePage().getOutlineTreeEditor()), (String)"tree");
        if (tree != null && tree.getItems().length > 0 && tree.getItem(0) != null && tree.getItem(0).getData() instanceof ModelTreeEditPart) {
            ModelTreeEditPart editPart = (ModelTreeEditPart)tree.getItem(0).getData();
            editPart.refresh();
        }
    }

    private boolean isChildCreated() {
        Object transferElement = ((ModelElementTransfer)this.getTransfer()).getObject();
        if (transferElement instanceof IObjectDescriptor) {
            Object type = ((IObjectDescriptor)transferElement).getType();
            if (PKG.getProcessDefinitionType().equals(type)) {
                return true;
            }
            if (XPKG.getTypeDeclarationType().equals(type)) {
                return true;
            }
            return PKG.getApplicationType().equals(type);
        }
        return ((ModelElementTransfer)this.getTransfer()).getObject() instanceof ProcessDefinitionType;
    }
}

