/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.IGraphicalObject;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;
import org.eclipse.stardust.model.xpdl.carnot.LaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.OrientationType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.editors.DiagramEditorPage;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.figures.AbstractSwimlaneFigure;
import org.eclipse.stardust.modeling.core.editors.figures.IconFigure;
import org.eclipse.stardust.modeling.core.editors.figures.SwimlaneBorder;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractSwimlaneEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.LaneEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.SetValueCmd;
import org.eclipse.stardust.modeling.core.utils.PoolLaneUtils;
import org.eclipse.stardust.modeling.core.utils.SnapGridUtils;
import org.eclipse.ui.PlatformUI;

public class LaneFigure
extends AbstractSwimlaneFigure {
    private static final CarnotWorkflowModelPackage CWM_PKG = CarnotWorkflowModelPackage.eINSTANCE;
    private boolean collapsed = false;
    private static int collapsedSize = 75;
    private IFigure button = null;

    public LaneFigure(LaneEditPart part) {
        super(part);
        this.collapsed = part.getLaneModel().isCollapsed();
        this.button = new IconFigure("icons/figures/min.gif");
        if (this.collapsed) {
            ((IconFigure)this.button).setIconPath("icons/figures/max.gif");
        }
        this.addMouseListener(new MyMouseLister());
        this.setBorder((Border)new CompoundBorder((Border)new SwimlaneBorder((IIdentifiableElement)this.getLaneEditPart().getLaneModel(), this.button), (Border)new MarginBorder(0, 3, 0, 3)));
    }

    public static int getCollapsedSize(EditPart part) {
        if (part == null || part.getParent() == null) {
            DiagramEditorPage diagramEditorPage = (DiagramEditorPage)((WorkflowModelEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()).getCurrentPage();
            part = diagramEditorPage.findEditPart(diagramEditorPage.getDiagram());
        }
        if (SnapGridUtils.getSnapToHelper((AbstractGraphicalEditPart)part) != null) {
            return SnapGridUtils.getNextSnapSize(collapsedSize);
        }
        return collapsedSize;
    }

    public void setCollapsed(boolean collapsed) {
        this.collapsed = collapsed;
        if (collapsed) {
            ((IconFigure)this.button).setIconPath("icons/figures/max.gif");
        } else {
            ((IconFigure)this.button).setIconPath("icons/figures/min.gif");
        }
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public Rectangle getBounds() {
        Rectangle laneBounds = this.bounds.getCopy();
        LaneEditPart laneEP = this.getLaneEditPart();
        DiagramType diagram = ModelUtils.findContainingDiagram((IGraphicalObject)((IGraphicalObject)laneEP.getModel()));
        if (diagram == null) {
            return laneBounds;
        }
        OrientationType direction = diagram.getOrientation();
        if (this.isCollapsed()) {
            if (OrientationType.HORIZONTAL_LITERAL.equals((Object)direction)) {
                laneBounds.height = LaneFigure.getCollapsedSize((EditPart)this.getLaneEditPart());
            } else {
                laneBounds.width = LaneFigure.getCollapsedSize((EditPart)this.getLaneEditPart());
            }
        }
        return laneBounds;
    }

    public LaneEditPart getLaneEditPart() {
        return (LaneEditPart)this.getEditPart();
    }

    class MyMouseLister
    implements MouseListener {
        MyMouseLister() {
        }

        public void mouseDoubleClicked(MouseEvent me) {
        }

        public void mousePressed(MouseEvent me) {
            if (me.button != 1) {
                return;
            }
            Rectangle mouseBounds = LaneFigure.this.button.getBounds();
            Point eventLocation = me.getLocation();
            if (eventLocation.x <= mouseBounds.x || eventLocation.x >= mouseBounds.x + mouseBounds.width || eventLocation.y <= mouseBounds.y || eventLocation.y >= mouseBounds.y + mouseBounds.height) {
                return;
            }
            WorkflowModelEditor editor = (WorkflowModelEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            LaneSymbol symbol = LaneFigure.this.getLaneEditPart().getLaneModel();
            ProcessDefinitionType container = ModelUtils.findContainingProcess((EObject)symbol);
            if (container != null && editor.getModelServer().requireLock((EObject)container)) {
                return;
            }
            LaneFigure.this.setCollapsed(!LaneFigure.this.isCollapsed());
            CompoundCommand command = new CompoundCommand();
            SetValueCmd setValueCmd = new SetValueCmd((EObject)LaneFigure.this.getLaneEditPart().getLaneModel(), (EStructuralFeature)CWM_PKG.getISwimlaneSymbol_Collapsed(), LaneFigure.this.collapsed);
            command.add((Command)setValueCmd);
            PoolLaneUtils.setResizeFlags(-1);
            CompoundCommand changeContainer = PoolLaneUtils.reorderLanes((AbstractSwimlaneEditPart)LaneFigure.this.getLaneEditPart().getParent(), new Integer(4));
            command.add((Command)changeContainer);
            editor.getEditDomain().getCommandStack().execute((Command)command);
        }

        public void mouseReleased(MouseEvent me) {
        }
    }
}

