/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.engine.core.model.beans.QNameUtil;
import org.eclipse.stardust.model.xpdl.carnot.AbstractEventAction;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityImplementationType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationContextTypeType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationTypeType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.ConditionalPerformerType;
import org.eclipse.stardust.model.xpdl.carnot.ContextType;
import org.eclipse.stardust.model.xpdl.carnot.DataMappingType;
import org.eclipse.stardust.model.xpdl.carnot.DataPathType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DataTypeType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.EventHandlerType;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IMetaType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.LinkTypeType;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ModelerType;
import org.eclipse.stardust.model.xpdl.carnot.OrganizationType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.RoleType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;
import org.eclipse.stardust.model.xpdl.carnot.TriggerType;
import org.eclipse.stardust.model.xpdl.carnot.TriggerTypeType;
import org.eclipse.stardust.model.xpdl.carnot.ViewType;
import org.eclipse.stardust.model.xpdl.carnot.spi.SpiExtensionRegistry;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackages;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalReferenceType;
import org.eclipse.stardust.model.xpdl.xpdl2.SchemaTypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationsType;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlTypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.util.TypeDeclarationUtils;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;

public class IconFactory
implements org.eclipse.stardust.model.xpdl.carnot.util.IconFactory {
    private static final String ORG_ECLIPSE_XSD_EDIT = "org.eclipse.xsd.edit";
    private static final CarnotWorkflowModelPackage PKG_CWM = CarnotWorkflowModelPackage.eINSTANCE;
    private static IconFactory defaultFactory = new IconFactory(null);
    private boolean simpleIcon = false;
    private boolean keepSimpleIconState = false;
    private WorkflowModelEditor editor;

    public void keepSimpleIconState() {
        this.keepSimpleIconState = true;
    }

    public IconFactory(WorkflowModelEditor editor) {
        this.editor = editor;
    }

    public String getIconFor(EObject model) {
        if (model instanceof EClass) {
            return IconFactory.getIconFor((EClass)model);
        }
        if (!this.keepSimpleIconState) {
            boolean bl = this.simpleIcon = this.editor == null;
        }
        if (model instanceof IModelElementNodeSymbol) {
            IIdentifiableModelElement newModel = ((IModelElementNodeSymbol)model).getModelElement();
            model = newModel;
        }
        if (model instanceof DataTypeType) {
            return IconFactory.getIcon((IMetaType)((DataTypeType)model), "icons/full/obj16/data.gif");
        }
        if (model instanceof DataType) {
            if (this.simpleIcon) {
                return "icons/full/obj16/data.gif";
            }
            return IconFactory.getIcon((IMetaType)((DataType)model).getType(), "icons/full/obj16/data.gif");
        }
        if (model instanceof TypeDeclarationsType) {
            return "icons/full/obj16/data_structured_definition.gif";
        }
        if (model instanceof TypeDeclarationType) {
            TypeDeclarationType declaration = (TypeDeclarationType)model;
            XpdlTypeType xpdlType = declaration.getDataType();
            if (xpdlType instanceof SchemaTypeType) {
                String icon = IconFactory.getXSDIcon(declaration);
                if (icon != null) {
                    return icon;
                }
            } else if (xpdlType instanceof ExternalReferenceType) {
                String icon;
                ExternalReferenceType externalReference = (ExternalReferenceType)xpdlType;
                String location = externalReference.getLocation();
                if (location.startsWith("urn:internal:") && (icon = IconFactory.getXSDIcon(declaration)) != null) {
                    return icon;
                }
                return QNameUtil.toString((String)ORG_ECLIPSE_XSD_EDIT, (String)"icons/full/obj16/XSDSchema.gif");
            }
            return IconFactory.getIconFor(declaration.eClass());
        }
        if (model instanceof AccessPointType) {
            if (this.simpleIcon) {
                return "icons/full/obj16/data.gif";
            }
            return IconFactory.getIcon((IMetaType)((AccessPointType)model).getType(), "icons/full/obj16/data.gif");
        }
        if (model instanceof TriggerTypeType) {
            return IconFactory.getIcon((IMetaType)((TriggerTypeType)model), "icons/full/obj16/trigger.gif");
        }
        if (model instanceof TriggerType) {
            if (this.simpleIcon) {
                return "icons/full/obj16/start_event.gif";
            }
            return IconFactory.getIcon((IMetaType)((TriggerType)model).getType(), "icons/full/obj16/trigger.gif");
        }
        if (model instanceof ApplicationTypeType) {
            return IconFactory.getIcon((IMetaType)((ApplicationTypeType)model), "icons/full/obj16/application.gif");
        }
        if (model instanceof ApplicationType) {
            if (((ApplicationType)model).isInteractive() && ((ApplicationType)model).getContext().size() > 0) {
                model = (EObject)((ApplicationType)model).getContext().get(0);
            } else {
                if (this.simpleIcon) {
                    return "icons/full/obj16/application.gif";
                }
                return IconFactory.getIcon((IMetaType)((ApplicationType)model).getType(), "icons/full/obj16/application.gif");
            }
        }
        if (model instanceof ApplicationContextTypeType) {
            return IconFactory.getIcon((IMetaType)((ApplicationContextTypeType)model), "icons/full/obj16/context.gif");
        }
        if (model instanceof ContextType) {
            if (this.simpleIcon) {
                return "icons/full/obj16/context.gif";
            }
            return IconFactory.getIcon((IMetaType)((ContextType)model).getType(), "icons/full/obj16/context.gif");
        }
        if (model instanceof AbstractEventAction) {
            if (this.simpleIcon) {
                return "icons/full/obj16/event_action.gif";
            }
            return IconFactory.getIcon((IMetaType)((AbstractEventAction)model).getType(), "icons/full/obj16/event_action.gif");
        }
        if (model instanceof ActivityType) {
            if (this.simpleIcon) {
                return "icons/full/obj16/activity.gif";
            }
            ActivityType activity = (ActivityType)model;
            ActivityImplementationType type = activity.getImplementation();
            if (ActivityImplementationType.ROUTE_LITERAL.equals((Object)type)) {
                return "icons/full/obj16/activity_route.gif";
            }
            if (ActivityImplementationType.MANUAL_LITERAL.equals((Object)type)) {
                return "icons/full/obj16/activity_manual.gif";
            }
            if (ActivityImplementationType.SUBPROCESS_LITERAL.equals((Object)type)) {
                return "icons/full/obj16/activity_subprocess.gif";
            }
            if (ActivityImplementationType.APPLICATION_LITERAL.equals((Object)type)) {
                return "icons/full/obj16/activity_application.gif";
            }
            return "icons/full/obj16/activity.gif";
        }
        if (model instanceof ConditionalPerformerType) {
            return "icons/full/obj16/conditional.gif";
        }
        if (model instanceof DataMappingType) {
            return DirectionType.IN_LITERAL.equals((Object)((DataMappingType)model).getDirection()) ? "icons/full/obj16/in_datamapping.gif" : "icons/full/obj16/out_datamapping.gif";
        }
        if (model instanceof DataPathType) {
            DataPathType dataPath = (DataPathType)model;
            if (dataPath.isDescriptor()) {
                return "icons/full/obj16/descriptor.gif";
            }
            DirectionType direction = dataPath.getDirection();
            if (DirectionType.IN_LITERAL.equals((Object)direction)) {
                return "icons/full/obj16/in_datapath.gif";
            }
            if (DirectionType.OUT_LITERAL.equals((Object)direction)) {
                return "icons/full/obj16/out_datapath.gif";
            }
            return "icons/full/obj16/datapath.gif";
        }
        if (model instanceof DiagramType) {
            return "icons/full/obj16/diagram.gif";
        }
        if (model instanceof EventHandlerType) {
            if (this.simpleIcon) {
                return "icons/full/obj16/event_handler.gif";
            }
            return IconFactory.getIcon((IMetaType)((EventHandlerType)model).getType(), "icons/full/obj16/event_handler.gif");
        }
        if (model instanceof ModelerType) {
            return "icons/full/obj16/modeler.gif";
        }
        if (model instanceof ModelType) {
            return "icons/full/obj16/model.gif";
        }
        if (model instanceof OrganizationType) {
            return "icons/full/obj16/organization.gif";
        }
        if (model instanceof ProcessDefinitionType) {
            return "icons/full/obj16/process.gif";
        }
        if (model instanceof RoleType) {
            return "icons/full/obj16/role.gif";
        }
        if (model instanceof TransitionType) {
            return "icons/full/obj16/transition.gif";
        }
        if (model instanceof LinkTypeType) {
            return "icons/full/obj16/link_type.gif";
        }
        if (model instanceof ViewType) {
            return "icons/full/obj16/view.gif";
        }
        if (model instanceof ExternalPackages) {
            return "icons/full/obj16/view.gif";
        }
        if (model instanceof ExternalPackage) {
            return "icons/full/obj16/view.gif";
        }
        return null;
    }

    private static String getXSDIcon(TypeDeclarationType declaration) {
        XSDNamedComponent component = TypeDeclarationUtils.findElementOrTypeDeclaration((TypeDeclarationType)declaration);
        if (component instanceof XSDElementDeclaration) {
            XSDElementDeclaration element = (XSDElementDeclaration)component;
            component = element.getTypeDefinition();
        }
        if (component instanceof XSDSimpleTypeDefinition) {
            return QNameUtil.toString((String)ORG_ECLIPSE_XSD_EDIT, (String)"icons/full/obj16/XSDSimpleTypeDefinition.gif");
        }
        if (component instanceof XSDComplexTypeDefinition) {
            return QNameUtil.toString((String)ORG_ECLIPSE_XSD_EDIT, (String)"icons/full/obj16/XSDComplexTypeDefinition.gif");
        }
        return null;
    }

    private static String getIconFor(EClass model) {
        if (PKG_CWM.getDataTypeType().equals(model) || PKG_CWM.getDataType().equals(model)) {
            return "icons/full/obj16/data.gif";
        }
        if (PKG_CWM.getAccessPointType().equals(model)) {
            return "icons/full/obj16/data.gif";
        }
        if (PKG_CWM.getTriggerTypeType().equals(model) || PKG_CWM.getTriggerType().equals(model)) {
            return "icons/full/obj16/trigger.gif";
        }
        if (PKG_CWM.getApplicationTypeType().equals(model) || PKG_CWM.getApplicationType().equals(model)) {
            return "icons/full/obj16/application.gif";
        }
        if (PKG_CWM.getApplicationContextTypeType().equals(model) || PKG_CWM.getContextType().equals(model)) {
            return "icons/full/obj16/context.gif";
        }
        if (PKG_CWM.getActivityType().equals(model)) {
            return "icons/full/obj16/activity.gif";
        }
        if (PKG_CWM.getConditionalPerformerType().equals(model)) {
            return "icons/full/obj16/conditional.gif";
        }
        if (PKG_CWM.getDataMappingConnectionType().equals(model)) {
            return "icons/full/obj16/draw_datamapping.gif";
        }
        if (PKG_CWM.getDataMappingType().equals(model)) {
            return "icons/full/obj16/datamapping.gif";
        }
        if (PKG_CWM.getDataPathType().equals(model)) {
            return "icons/full/obj16/datapath.gif";
        }
        if (PKG_CWM.getDiagramType().equals(model)) {
            return "icons/full/obj16/diagram.gif";
        }
        if (PKG_CWM.getEventHandlerType().equals(model)) {
            return "icons/full/obj16/event_handler.gif";
        }
        if (PKG_CWM.getExecutedByConnectionType().equals(model)) {
            return "icons/full/obj16/executedBy.gif";
        }
        if (PKG_CWM.getModelerType().equals(model)) {
            return "icons/full/obj16/modeler.gif";
        }
        if (PKG_CWM.getModelType().equals(model)) {
            return "icons/full/obj16/model.gif";
        }
        if (PKG_CWM.getOrganizationType().equals(model)) {
            return "icons/full/obj16/organization.gif";
        }
        if (PKG_CWM.getPartOfConnectionType().equals(model)) {
            return "icons/full/obj16/part_of.gif";
        }
        if (PKG_CWM.getPerformsConnectionType().equals(model)) {
            return "icons/full/obj16/performedBy.gif";
        }
        if (PKG_CWM.getProcessDefinitionType().equals(model)) {
            return "icons/full/obj16/process.gif";
        }
        if (PKG_CWM.getRoleType().equals(model)) {
            return "icons/full/obj16/role.gif";
        }
        if (PKG_CWM.getTeamLeadConnectionType().equals(model)) {
            return "icons/full/obj16/team_lead.gif";
        }
        if (PKG_CWM.getTransitionConnectionType().equals(model)) {
            return "icons/full/obj16/draw_transition.gif";
        }
        if (PKG_CWM.getTransitionType().equals(model)) {
            return "icons/full/obj16/transition.gif";
        }
        if (PKG_CWM.getLinkTypeType().equals(model) || PKG_CWM.getGenericLinkConnectionType().equals(model)) {
            return "icons/full/obj16/link_type.gif";
        }
        if (PKG_CWM.getViewType().equals(model)) {
            return "icons/full/obj16/view.gif";
        }
        if (PKG_CWM.getWorksForConnectionType().equals(model)) {
            return "icons/full/obj16/works_for.gif";
        }
        if (PKG_CWM.getIModelParticipant().equals(model)) {
            return "icons/full/obj16/participants.gif";
        }
        if (XpdlPackage.eINSTANCE.getTypeDeclarationsType().equals(model)) {
            return "icons/full/obj16/data_structured_definition.gif";
        }
        return null;
    }

    private static String getIcon(IMetaType type, String defaultIcon) {
        if (type == null) {
            return defaultIcon;
        }
        SpiExtensionRegistry registry = SpiExtensionRegistry.instance();
        String icon = registry.getTypeIcon(type.getExtensionPointId(), type.getId());
        return icon == null ? defaultIcon : icon;
    }

    public static IconFactory getDefault() {
        return defaultFactory;
    }
}

