/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.stardust.model.xpdl.carnot.ActivityImplementationType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DescriptionType;
import org.eclipse.stardust.model.xpdl.carnot.IConnectionSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.JoinSplitType;
import org.eclipse.stardust.model.xpdl.carnot.LaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.LoopType;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.TextSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.TextType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.SetValueCmd;
import org.eclipse.stardust.modeling.core.editors.parts.properties.ActivityCommandFactory;
import org.eclipse.stardust.modeling.core.editors.parts.properties.AnyTextCommandFactory;
import org.eclipse.stardust.modeling.core.editors.parts.properties.ApplicationCommandFactory;
import org.eclipse.stardust.modeling.core.editors.parts.properties.BoundEObjectPropertyId;
import org.eclipse.stardust.modeling.core.editors.parts.properties.CmdFactoryPropertyDescriptorDecorator;
import org.eclipse.stardust.modeling.core.editors.parts.properties.ConnectionRoutingCommandFactory;
import org.eclipse.stardust.modeling.core.editors.parts.properties.DataCommandFactory;
import org.eclipse.stardust.modeling.core.editors.parts.properties.DefaultPropSheetCmdFactory;
import org.eclipse.stardust.modeling.core.editors.parts.properties.EObjectPropertySource;
import org.eclipse.stardust.modeling.core.editors.parts.properties.IPropSheetCmdFactory;
import org.eclipse.stardust.modeling.core.editors.parts.properties.LaneParticipantCommandFactory;
import org.eclipse.stardust.modeling.core.editors.parts.properties.UndoablePropSheetEntry;
import org.eclipse.stardust.modeling.core.ui.EEnumPropertyDescriptor;
import org.eclipse.stardust.modeling.core.ui.ModelElementListPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class PropertySourceFactory {
    public static final String CATEGORY_BASE = Diagram_Messages.CATEGORY_BASE;
    public static final String CATEGORY_DIAGRAM = Diagram_Messages.CATEGORY_DIAGRAM;
    public static final String CATEGORY_ALL = Diagram_Messages.CATEGORY_ALL;
    private static final IPropertyDescriptor[] EMPTY_PROP_DESC_ARRAY = new IPropertyDescriptor[0];
    private static IPropSheetCmdFactory nameCommandFactoryInstance = new DefaultPropSheetCmdFactory(){

        @Override
        public Command createSetValueCommand(UndoablePropSheetEntry entry, IPropertyDescriptor descriptor, IPropertySource target, Object value) {
            if (value == null) {
                return this.createResetValueCommand(descriptor, target);
            }
            CompoundCommand result = new CompoundCommand(descriptor.getDisplayName());
            result.add(super.createSetValueCommand(entry, descriptor, target, value));
            this.addUpdateCommand(result, (BoundEObjectPropertyId)descriptor.getId(), target, value);
            return result.unwrap();
        }

        @Override
        public Command createResetValueCommand(IPropertyDescriptor descriptor, IPropertySource target) {
            CompoundCommand result = new CompoundCommand(descriptor.getDisplayName());
            result.add(super.createResetValueCommand(descriptor, target));
            this.addUpdateCommand(result, (BoundEObjectPropertyId)descriptor.getId(), target, null);
            return result.unwrap();
        }

        private void addUpdateCommand(CompoundCommand result, BoundEObjectPropertyId id, IPropertySource target, Object value) {
            result.add((Command)new SetValueCmd((EObject)((IIdentifiableElement)target.getEditableValue()), (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getIIdentifiableElement_Id(), (Object)ModelUtils.computeId((String)((String)value))));
        }
    };

    public static IPropertySource getPropertySource(EditPart part, EObject object) {
        IIdentifiableModelElement model;
        EObjectPropertySource propSource = null;
        if (object instanceof IModelElementNodeSymbol && (model = ((IModelElementNodeSymbol)object).getModelElement()) != null) {
            ArrayList descriptors = new ArrayList();
            PropertySourceFactory.addBasicProperties(part, (EObject)model, descriptors);
            PropertySourceFactory.addSymbolProperties(part, object, descriptors);
            PropertySourceFactory.addOtherEmfDescriptors(part, (EObject)model, descriptors);
            propSource = new EObjectPropertySource((EObject)model, descriptors.toArray(EMPTY_PROP_DESC_ARRAY));
        }
        if (propSource == null) {
            ArrayList descriptors = new ArrayList();
            PropertySourceFactory.addBasicProperties(part, object, descriptors);
            PropertySourceFactory.addSymbolProperties(part, object, descriptors);
            PropertySourceFactory.addOtherEmfDescriptors(part, object, descriptors);
            propSource = new EObjectPropertySource(object, descriptors.toArray(EMPTY_PROP_DESC_ARRAY));
        }
        return propSource;
    }

    public static IPropertySource getSimplePropertySource(EditPart part, EObject model, EStructuralFeature feature) {
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
        descriptors.add(new PropertyDescriptor((Object)new BoundEObjectPropertyId(model, feature, part), feature.getName()));
        return new EObjectPropertySource(model, descriptors.toArray(EMPTY_PROP_DESC_ARRAY));
    }

    private static void addBasicProperties(EditPart part, EObject object, List descriptors) {
        ModelElementListPropertyDescriptor typeDescr;
        ModelType model;
        PropertyDescriptor composite;
        TextPropertyDescriptor idDescr;
        CarnotWorkflowModelPackage CWM_PKG = CarnotWorkflowModelPackage.eINSTANCE;
        if (object instanceof IModelElement) {
            PropertyDescriptor elementOidDescr = new PropertyDescriptor((Object)new BoundEObjectPropertyId(object, (EStructuralFeature)CWM_PKG.getIModelElement_ElementOid(), part), Diagram_Messages.DISPL_NAME_ElementOID);
            elementOidDescr.setCategory(CATEGORY_BASE);
            descriptors.add(elementOidDescr);
        }
        if (object instanceof IIdentifiableElement) {
            idDescr = new TextPropertyDescriptor((Object)new BoundEObjectPropertyId(object, (EStructuralFeature)CWM_PKG.getIIdentifiableElement_Id(), part), Diagram_Messages.DISPL_NAME_ID);
            idDescr.setCategory(CATEGORY_BASE);
            descriptors.add(idDescr);
            TextPropertyDescriptor nameDescr = new TextPropertyDescriptor((Object)new BoundEObjectPropertyId(object, (EStructuralFeature)CWM_PKG.getIIdentifiableElement_Name(), part), Diagram_Messages.DISPL_NAME_Name);
            composite = CmdFactoryPropertyDescriptorDecorator.create((PropertyDescriptor)nameDescr, nameCommandFactoryInstance);
            composite.setCategory(CATEGORY_BASE);
            descriptors.add(composite);
        }
        if (object instanceof ActivityType) {
            ModelElementListPropertyDescriptor joinDescr = new ModelElementListPropertyDescriptor(new BoundEObjectPropertyId(object, (EStructuralFeature)CWM_PKG.getActivityType_Join(), part), Diagram_Messages.DISPL_NAME_JoinMode, Arrays.asList(JoinSplitType.NONE_LITERAL, JoinSplitType.XOR_LITERAL, JoinSplitType.AND_LITERAL));
            PropertyDescriptor composite2 = CmdFactoryPropertyDescriptorDecorator.create(joinDescr, ActivityCommandFactory.INSTANCE);
            composite2.setCategory(Diagram_Messages.CATEGEGORY_FlowControl);
            descriptors.add(composite2);
            ModelElementListPropertyDescriptor splitDescr = new ModelElementListPropertyDescriptor(new BoundEObjectPropertyId(object, (EStructuralFeature)CWM_PKG.getActivityType_Split(), part), Diagram_Messages.DISPL_NAME_SplitMode, Arrays.asList(JoinSplitType.NONE_LITERAL, JoinSplitType.XOR_LITERAL, JoinSplitType.AND_LITERAL));
            composite2 = CmdFactoryPropertyDescriptorDecorator.create(splitDescr, ActivityCommandFactory.INSTANCE);
            composite2.setCategory(Diagram_Messages.CATEGEGORY_FlowControl);
            descriptors.add(composite2);
            ModelElementListPropertyDescriptor loopDescr = new ModelElementListPropertyDescriptor(new BoundEObjectPropertyId(object, (EStructuralFeature)CWM_PKG.getActivityType_LoopType(), part), Diagram_Messages.DISPL_NAME_LoopMode, Arrays.asList(LoopType.NONE_LITERAL, LoopType.WHILE_LITERAL, LoopType.REPEAT_LITERAL));
            loopDescr.setCategory(Diagram_Messages.CATEGORY_FlowControl);
            descriptors.add(loopDescr);
            PropertyDescriptor loopCondDescr = new PropertyDescriptor((Object)new BoundEObjectPropertyId(object, (EStructuralFeature)CWM_PKG.getActivityType_LoopCondition(), part), Diagram_Messages.DISPL_NAME_LoopCondition);
            loopCondDescr.setCategory(Diagram_Messages.CATEGORY_FlowControl);
            descriptors.add(loopCondDescr);
            ModelElementListPropertyDescriptor implementationDescr = new ModelElementListPropertyDescriptor(new BoundEObjectPropertyId(object, (EStructuralFeature)CWM_PKG.getActivityType_Implementation(), part), Diagram_Messages.DISPL_NAME_Implementation, ActivityImplementationType.VALUES);
            composite2 = CmdFactoryPropertyDescriptorDecorator.create(implementationDescr, ActivityCommandFactory.INSTANCE);
            composite2.setCategory(CATEGORY_BASE);
            descriptors.add(composite2);
        }
        if (object instanceof LaneSymbol) {
            LaneSymbol lane = (LaneSymbol)object;
            ModelType model2 = ModelUtils.findContainingModel((EObject)lane);
            ArrayList participants = new ArrayList();
            participants.addAll(model2.getRole());
            participants.addAll(model2.getOrganization());
            participants.addAll(model2.getConditionalPerformer());
            ModelElementListPropertyDescriptor participantDescr = new ModelElementListPropertyDescriptor(new BoundEObjectPropertyId(object, (EStructuralFeature)CWM_PKG.getISwimlaneSymbol_ParticipantReference(), part), Diagram_Messages.DISPL_NAME_Participant, participants);
            PropertyDescriptor composite3 = CmdFactoryPropertyDescriptorDecorator.create(participantDescr, LaneParticipantCommandFactory.INSTANCE);
            composite3.setCategory(CATEGORY_BASE);
            descriptors.add(composite3);
        }
        if (object instanceof TextSymbolType) {
            idDescr = new TextPropertyDescriptor((Object)new BoundEObjectPropertyId(object, (EStructuralFeature)CWM_PKG.getTextSymbolType_Text(), part), Diagram_Messages.DISPL_NAME_Text);
            idDescr.setCategory(CATEGORY_BASE);
            descriptors.add(idDescr);
        }
        if (object instanceof DataType) {
            model = (ModelType)object.eContainer();
            typeDescr = new ModelElementListPropertyDescriptor(new BoundEObjectPropertyId(object, (EStructuralFeature)CWM_PKG.getDataType_Type(), part), Diagram_Messages.LB_PropertyType, (List)model.getDataType());
            composite = CmdFactoryPropertyDescriptorDecorator.create(typeDescr, DataCommandFactory.INSTANCE);
            composite.setCategory(Diagram_Messages.CATEGORY_BASE);
            descriptors.add(composite);
        }
        if (object instanceof ApplicationType && !((ApplicationType)object).isInteractive()) {
            model = (ModelType)object.eContainer();
            typeDescr = new ModelElementListPropertyDescriptor(new BoundEObjectPropertyId(object, (EStructuralFeature)CWM_PKG.getApplicationType_Type(), part), Diagram_Messages.LB_PropertyType, (List)model.getApplicationType());
            composite = CmdFactoryPropertyDescriptorDecorator.create(typeDescr, ApplicationCommandFactory.INSTANCE);
            composite.setCategory(Diagram_Messages.CATEGORY_BASE);
            descriptors.add(composite);
        }
    }

    private static void addSymbolProperties(EditPart part, EObject object, List descriptors) {
        CarnotWorkflowModelPackage CWM_PKG = CarnotWorkflowModelPackage.eINSTANCE;
        if (object instanceof IModelElement) {
            PropertyDescriptor elementOidDescr = new PropertyDescriptor((Object)new BoundEObjectPropertyId(object, (EStructuralFeature)CWM_PKG.getIModelElement_ElementOid(), part), Diagram_Messages.DISPL_NAME_SymbolElementOID);
            elementOidDescr.setCategory(CATEGORY_DIAGRAM);
            descriptors.add(elementOidDescr);
        }
        if (object instanceof INodeSymbol) {
            PropertyDescriptor xPosDescr = new PropertyDescriptor((Object)new BoundEObjectPropertyId(object, (EStructuralFeature)CWM_PKG.getINodeSymbol_XPos(), part), "X Pos");
            xPosDescr.setCategory(CATEGORY_DIAGRAM);
            descriptors.add(xPosDescr);
            PropertyDescriptor yPosDescr = new PropertyDescriptor((Object)new BoundEObjectPropertyId(object, (EStructuralFeature)CWM_PKG.getINodeSymbol_YPos(), part), "Y Pos");
            yPosDescr.setCategory(CATEGORY_DIAGRAM);
            descriptors.add(yPosDescr);
            PropertyDescriptor widthDescr = new PropertyDescriptor((Object)new BoundEObjectPropertyId(object, (EStructuralFeature)CWM_PKG.getINodeSymbol_Width(), part), Diagram_Messages.DISPL_NAME_Width);
            widthDescr.setCategory(CATEGORY_DIAGRAM);
            descriptors.add(widthDescr);
            PropertyDescriptor heightDescr = new PropertyDescriptor((Object)new BoundEObjectPropertyId(object, (EStructuralFeature)CWM_PKG.getINodeSymbol_Height(), part), Diagram_Messages.DISPL_NAME_Height);
            heightDescr.setCategory(CATEGORY_DIAGRAM);
            descriptors.add(heightDescr);
        }
        if (object instanceof IConnectionSymbol) {
            PropertyDescriptor routingDescr = CmdFactoryPropertyDescriptorDecorator.create(new EEnumPropertyDescriptor(new BoundEObjectPropertyId(object, (EStructuralFeature)CWM_PKG.getIConnectionSymbol_Routing(), part), Diagram_Messages.DISPL_NAME_Routing, CarnotWorkflowModelPackage.eINSTANCE.getRoutingType()), ConnectionRoutingCommandFactory.INSTANCE);
            routingDescr.setCategory(CATEGORY_DIAGRAM);
            descriptors.add(routingDescr);
        }
    }

    private static void addOtherEmfDescriptors(EditPart part, EObject object, List descriptors) {
        CarnotWorkflowModelPackage CWM_PKG = CarnotWorkflowModelPackage.eINSTANCE;
        HashSet<Object> handledDescriptors = new HashSet<Object>(descriptors.size());
        for (PropertyDescriptor descr : descriptors) {
            Object id = descr.getId();
            if (id instanceof BoundEObjectPropertyId && ((BoundEObjectPropertyId)id).getObject() == object) {
                handledDescriptors.add(((BoundEObjectPropertyId)id).getId());
                continue;
            }
            if (!(id instanceof EStructuralFeature)) continue;
            handledDescriptors.add(id);
        }
        EClass cls = object.eClass();
        if (cls != null) {
            for (EReference reference : cls.getEAllReferences()) {
                if (handledDescriptors.contains(reference) || !reference.getEReferenceType().equals(CWM_PKG.getTextType()) && !reference.getEReferenceType().equals(CWM_PKG.getDescriptionType())) continue;
                PropertyDescriptor textDescr = new PropertyDescriptor((Object)reference, reference.getName());
                textDescr.setLabelProvider((ILabelProvider)new LabelProvider(){

                    public String getText(Object element) {
                        if (element instanceof TextType) {
                            return ModelUtils.getCDataString((FeatureMap)((TextType)element).getMixed());
                        }
                        if (element instanceof DescriptionType) {
                            return ModelUtils.getCDataString((FeatureMap)((DescriptionType)element).getMixed());
                        }
                        return super.getText(element);
                    }
                });
                PropertyDescriptor composite = CmdFactoryPropertyDescriptorDecorator.create(textDescr, AnyTextCommandFactory.INSTANCE);
                composite.setCategory(CATEGORY_BASE);
                descriptors.add(composite);
            }
        }
    }
}

