/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram;

import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.stardust.model.xpdl.carnot.ActivitySymbolType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.GatewaySymbol;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.TransitionConnectionType;
import org.eclipse.stardust.modeling.core.editors.DynamicConnectionFactory;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.figures.ActivitySymbolFigure;
import org.eclipse.stardust.modeling.core.editors.figures.anchors.TransitionConnectionAnchor;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractModelElementNodeSymbolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.GatewaySymbolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.IConnectionCommand;

public class ActivitySymbolNodeEditPart
extends AbstractModelElementNodeSymbolEditPart {
    public ActivitySymbolNodeEditPart(WorkflowModelEditor editor, IModelElementNodeSymbol model, EStructuralFeature[] features, EStructuralFeature[] features2) {
        super(editor, model, ActivitySymbolFigure.class, features, features2);
    }

    @Override
    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        if (connection.getModel() instanceof TransitionConnectionType) {
            TransitionConnectionType tc = (TransitionConnectionType)connection.getModel();
            return new TransitionConnectionAnchor(this.getFigure(), tc.getSourceAnchor());
        }
        return super.getSourceConnectionAnchor(connection);
    }

    @Override
    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        if (connection.getModel() instanceof TransitionConnectionType) {
            TransitionConnectionType tc = (TransitionConnectionType)connection.getModel();
            return new TransitionConnectionAnchor(this.getFigure(), tc.getTargetAnchor());
        }
        return super.getTargetConnectionAnchor(connection);
    }

    @Override
    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        if (request instanceof CreateConnectionRequest && ((CreateConnectionRequest)request).getNewObject() instanceof DynamicConnectionFactory) {
            DynamicConnectionFactory factory = (DynamicConnectionFactory)((CreateConnectionRequest)request).getNewObject();
            Point location = ((CreateConnectionRequest)request).getLocation();
            TransitionConnectionAnchor anchor = new TransitionConnectionAnchor(this.getFigure(), location);
            factory.setSourceAnchorType(anchor.getType());
            return anchor;
        }
        if (request instanceof CreateConnectionRequest && ((CreateConnectionRequest)request).getNewObjectType().equals(CarnotWorkflowModelPackage.eINSTANCE.getTransitionConnectionType())) {
            IConnectionCommand cmd = (IConnectionCommand)((CreateConnectionRequest)request).getNewObject();
            Point location = ((CreateConnectionRequest)request).getLocation();
            TransitionConnectionAnchor anchor = new TransitionConnectionAnchor(this.getFigure(), location);
            cmd.setSourceAnchorType(anchor.getType());
            return anchor;
        }
        if (request instanceof ReconnectRequest && ((ReconnectRequest)request).getConnectionEditPart().getModel() instanceof TransitionConnectionType) {
            Point location = ((ReconnectRequest)request).getLocation();
            TransitionConnectionAnchor anchor = new TransitionConnectionAnchor(this.getFigure(), location);
            request.getExtendedData().put("org.eclipse.stardust.modeling.core.sourceAnchor", anchor.getType());
            return anchor;
        }
        return super.getSourceConnectionAnchor(request);
    }

    @Override
    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        if (request instanceof CreateConnectionRequest && ((CreateConnectionRequest)request).getNewObject() instanceof DynamicConnectionFactory) {
            DynamicConnectionFactory factory = (DynamicConnectionFactory)((CreateConnectionRequest)request).getNewObject();
            Point location = ((CreateConnectionRequest)request).getLocation();
            TransitionConnectionAnchor anchor = new TransitionConnectionAnchor(this.getFigure(), location);
            factory.setTargetAnchorType(anchor.getType());
            return anchor;
        }
        if (request instanceof CreateConnectionRequest && ((CreateConnectionRequest)request).getNewObjectType().equals(CarnotWorkflowModelPackage.eINSTANCE.getTransitionConnectionType())) {
            IConnectionCommand cmd = (IConnectionCommand)((CreateConnectionRequest)request).getNewObject();
            Point location = ((CreateConnectionRequest)request).getLocation();
            TransitionConnectionAnchor anchor = new TransitionConnectionAnchor(this.getFigure(), location);
            cmd.setTargetAnchorType(anchor.getType());
            return anchor;
        }
        if (request instanceof ReconnectRequest && ((ReconnectRequest)request).getConnectionEditPart().getModel() instanceof TransitionConnectionType) {
            Point location = ((ReconnectRequest)request).getLocation();
            TransitionConnectionAnchor anchor = new TransitionConnectionAnchor(this.getFigure(), location);
            request.getExtendedData().put("org.eclipse.stardust.modeling.core.targetAnchor", anchor.getType());
            return anchor;
        }
        return super.getTargetConnectionAnchor(request);
    }

    @Override
    public void handleNotification(Notification notification) {
        int featureId = notification.getFeatureID(CarnotWorkflowModelPackage.class);
        switch (featureId) {
            case 12: 
            case 17: {
                ActivitySymbolType symbol = (ActivitySymbolType)this.getModel();
                EList gatewaySymbols = symbol.getGatewaySymbols();
                for (GatewaySymbol gatewaySymbol : gatewaySymbols) {
                    GatewaySymbolEditPart editPart = (GatewaySymbolEditPart)this.getEditor().findEditPart(gatewaySymbol);
                    if (editPart == null) continue;
                    editPart.refreshVisuals();
                }
                break;
            }
        }
        super.handleNotification(notification);
    }
}

