/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.stardust.model.xpdl.carnot.ISwimlaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.LaneSymbol;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.figures.LaneFigure;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractSwimlaneEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.policies.DiagramComponentEditPolicy;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.policies.SymbolContainerEditPolicy;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.policies.SymbolContainerLayoutEditPolicy;
import org.eclipse.stardust.modeling.core.utils.LaneConnections;

public class LaneEditPart
extends AbstractSwimlaneEditPart {
    public LaneEditPart(WorkflowModelEditor editor, LaneSymbol lane) {
        super(editor, (ISwimlaneSymbol)lane);
        if (lane.getParticipantReference() != null) {
            lane.getParticipantReference().eAdapters().add((Object)this.getNotificationAdapter());
        }
    }

    public LaneSymbol getLaneModel() {
        return (LaneSymbol)this.getModel();
    }

    public LaneFigure getLaneFigure() {
        return (LaneFigure)this.getFigure();
    }

    protected IFigure createFigure() {
        return new LaneFigure(this);
    }

    @Override
    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new DiagramComponentEditPolicy());
        this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new SymbolContainerEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new SymbolContainerLayoutEditPolicy());
    }

    @Override
    public List getModelChildren() {
        ArrayList nodes = new ArrayList(this.getLaneModel().getNodes().size() + this.getLaneModel().getChildLanes().size());
        nodes.addAll(this.getLaneModel().getChildLanes());
        nodes.addAll(this.getLaneModel().getActivitySymbol());
        nodes.addAll(this.getLaneModel().getAnnotationSymbol());
        nodes.addAll(this.getLaneModel().getApplicationSymbol());
        nodes.addAll(this.getLaneModel().getConditionalPerformerSymbol());
        nodes.addAll(this.getLaneModel().getDataSymbol());
        nodes.addAll(this.getLaneModel().getEndEventSymbols());
        nodes.addAll(this.getLaneModel().getGatewaySymbol());
        nodes.addAll(this.getLaneModel().getGroupSymbol());
        nodes.addAll(this.getLaneModel().getIntermediateEventSymbols());
        nodes.addAll(this.getLaneModel().getModelerSymbol());
        nodes.addAll(this.getLaneModel().getOrganizationSymbol());
        nodes.addAll(this.getLaneModel().getProcessSymbol());
        nodes.addAll(this.getLaneModel().getRoleSymbol());
        nodes.addAll(this.getLaneModel().getStartEventSymbols());
        nodes.addAll(this.getLaneModel().getTextSymbol());
        nodes.addAll(this.getLaneModel().getProcessInterfaceSymbols());
        return nodes;
    }

    @Override
    public void handleNotification(Notification notification) {
        switch (notification.getFeatureID(LaneSymbol.class)) {
            case 46: {
                this.getLaneFigure().setCollapsed(this.getLaneModel().isCollapsed());
                this.refreshFigure((IFigure)this.getLaneFigure());
                this.refreshContent();
                break;
            }
            case 47: {
                Object oldValue = notification.getOldValue();
                Object newValue = notification.getNewValue();
                if (oldValue != null) {
                    ((EObject)oldValue).eAdapters().remove((Object)this.getNotificationAdapter());
                }
                if (newValue != null) {
                    ((EObject)newValue).eAdapters().add((Object)this.getNotificationAdapter());
                }
                this.getLaneFigure().refresh();
                break;
            }
            case 1: 
            case 48: {
                this.refreshChildren();
                break;
            }
            default: {
                super.handleNotification(notification);
            }
        }
    }

    @Override
    protected void refreshFigure(IFigure figure) {
        super.refreshFigure(figure);
    }

    public void refreshContent() {
        this.setLaneChildren();
        this.switchLaneConnections();
    }

    private void setLaneChildren() {
        boolean childrenVisible = false;
        childrenVisible = !this.getLaneFigure().isCollapsed();
        List children = this.getLaneFigure().getChildren();
        int i = 0;
        while (i < children.size()) {
            Object child = children.get(i);
            if (child instanceof Figure) {
                ((Figure)child).setVisible(childrenVisible);
            }
            ++i;
        }
    }

    public void switchLaneConnections() {
        boolean parentCollapsed = false;
        EditPart parentEP = this.getParent();
        while (parentEP != null) {
            if (parentEP instanceof LaneEditPart && ((LaneEditPart)parentEP).getLaneModel().isCollapsed()) {
                parentCollapsed = true;
                break;
            }
            parentEP = parentEP.getParent();
        }
        if (!parentCollapsed) {
            LaneConnections laneConnections = new LaneConnections(this, this.getLaneFigure().isCollapsed());
            laneConnections.handleConnections();
        }
    }
}

