/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ViewType;
import org.eclipse.stardust.model.xpdl.carnot.ViewableType;
import org.eclipse.stardust.modeling.common.ui.IdFactory;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CreateModelElementCommand;

public class AddViewAction
extends Action {
    private static final String ACTION_NAME = Diagram_Messages.NAME_AddViewAction;
    private ModelType model;
    private EditDomain editDomain;
    private TreeViewer treeViewer;
    private EObject parent;

    public AddViewAction(ModelType model, EditDomain editDomain, TreeViewer treeViewer) {
        super(ACTION_NAME);
        this.model = model;
        this.editDomain = editDomain;
        this.treeViewer = treeViewer;
    }

    public void run() {
        Object element = ((IStructuredSelection)this.treeViewer.getSelection()).getFirstElement();
        if (element instanceof ViewType) {
            this.parent = (EObject)element;
        } else if (element instanceof ViewableType) {
            this.parent = ((EObject)element).eContainer();
        }
        this.editDomain.getCommandStack().execute((Command)this.createCommand());
        this.parent = null;
    }

    private CreateModelElementCommand createCommand() {
        if (this.parent == null) {
            this.parent = this.model;
        }
        IdFactory idFactory = new IdFactory("View", "View");
        CreateModelElementCommand command = new CreateModelElementCommand(0, idFactory, CarnotWorkflowModelPackage.eINSTANCE.getViewType()){

            @Override
            public void execute() {
                super.execute();
                AddViewAction.this.treeViewer.refresh();
                AddViewAction.this.treeViewer.expandToLevel((Object)AddViewAction.this.model, -1);
            }

            @Override
            public void redo() {
                super.redo();
                AddViewAction.this.treeViewer.refresh();
            }

            @Override
            public void undo() {
                super.undo();
                AddViewAction.this.treeViewer.refresh();
            }
        };
        command.setParent(this.parent);
        return command;
    }
}

