/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.stardust.model.xpdl.carnot.ActivityImplementationType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.SubProcessModeType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.IdFactory;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.createUtils.CreationUtils;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CreateModelElementCommand;
import org.eclipse.stardust.modeling.core.modelserver.ModelServerUtils;
import org.eclipse.ui.IWorkbenchPart;

public class CreateActivityAction
extends SelectionAction {
    private ActivityImplementationType implementation;
    private IModelElement activity;

    public CreateActivityAction(ActivityImplementationType implementation, String actionID, WorkflowModelEditor editor) {
        super((IWorkbenchPart)editor);
        this.setId(actionID);
        if (implementation == null) {
            this.setText(Diagram_Messages.LB_SUBMENU_NewActivity);
            this.setImageDescriptor(DiagramPlugin.getImageDescriptor("icons/full/obj16/activity.gif"));
        } else {
            this.setText(String.valueOf(ModelUtils.getActivityImplementationTypeText((ActivityImplementationType)implementation)) + Diagram_Messages.TXT_Activity);
            this.setImageDescriptor(DiagramPlugin.getImageDescriptor("icons/full/obj16/activity_" + implementation.getName().toLowerCase() + ".gif"));
        }
        this.implementation = implementation;
    }

    protected boolean calculateEnabled() {
        return this.implementation != null && this.getSelectedObjects().size() == 1 && this.getProcess() != null;
    }

    private ProcessDefinitionType getProcess() {
        Object model;
        Object selection = this.getSelectedObjects().get(0);
        if (selection instanceof EditPart && (model = ((EditPart)selection).getModel()) instanceof ProcessDefinitionType) {
            return (ProcessDefinitionType)model;
        }
        return null;
    }

    public void run() {
        ProcessDefinitionType process = this.getProcess();
        Boolean lockedByCurrentUser = ModelServerUtils.isLockedByCurrentUser((EObject)process);
        if (lockedByCurrentUser == null || lockedByCurrentUser.equals(Boolean.TRUE)) {
            this.execute(this.createCommand(process));
            CreationUtils.showInOutlineAndEdit((EObject)this.activity);
        } else {
            ModelServerUtils.showMessageBox(Diagram_Messages.MSG_LOCK_NEEDED);
        }
    }

    private CreateModelElementCommand createCommand(ProcessDefinitionType process) {
        IdFactory id = new IdFactory(Diagram_Messages.ID_Activity, this.implementation == null ? Diagram_Messages.BASENAME_Activity : String.valueOf(ModelUtils.getActivityImplementationTypeText((ActivityImplementationType)this.implementation)) + Diagram_Messages.BASENAME_Activity);
        CreateModelElementCommand command = new CreateModelElementCommand(1, id, CarnotWorkflowModelPackage.eINSTANCE.getActivityType()){

            @Override
            protected IModelElement createModelElement() {
                IModelElement modelElement = super.createModelElement();
                if (modelElement instanceof ActivityType && CreateActivityAction.this.implementation != null) {
                    ((ActivityType)modelElement).setImplementation(CreateActivityAction.this.implementation);
                }
                if (modelElement instanceof ActivityType && ActivityImplementationType.SUBPROCESS_LITERAL.equals((Object)CreateActivityAction.this.implementation)) {
                    ((ActivityType)modelElement).setSubProcessMode(SubProcessModeType.SYNC_SHARED_LITERAL);
                }
                CreateActivityAction.this.activity = modelElement;
                return modelElement;
            }
        };
        command.setParent((EObject)process);
        return command;
    }
}

