/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationTypeType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.spi.IApplicationInitializer;
import org.eclipse.stardust.model.xpdl.carnot.spi.SpiExtensionRegistry;
import org.eclipse.stardust.modeling.common.ui.IdFactory;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.createUtils.CreationUtils;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CompoundDiagramCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CreateMetaTypeCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CreateTypedModelElementCommand;
import org.eclipse.stardust.modeling.core.editors.parts.tree.ChildCategoryNode;
import org.eclipse.ui.IWorkbenchPart;

public class CreateApplicationAction
extends SelectionAction {
    private IConfigurationElement config;
    private ApplicationType application;

    public CreateApplicationAction(IConfigurationElement config, WorkflowModelEditor part) {
        super((IWorkbenchPart)part);
        this.config = config;
        if (config == null) {
            this.setId("org.eclipse.stardust.modeling.core.createGenericApplication");
            this.setText(Diagram_Messages.LB_EXTMENU_NewApplication);
            this.setImageDescriptor(DiagramPlugin.getImageDescriptor("icons/full/obj16/application.gif"));
        } else {
            this.setId("org.eclipse.stardust.modeling.core.createApplication." + config.getAttribute("id"));
            this.setText(config.getAttribute("name"));
            this.setImageDescriptor(DiagramPlugin.getImageDescriptor(config));
        }
    }

    protected boolean calculateEnabled() {
        return this.config != null && this.getSelectedObjects().size() == 1 && (this.getModel() != null || this.isApplicationCategoryNode());
    }

    private boolean isApplicationCategoryNode() {
        Object selection = this.getSelectedObjects().get(0);
        return selection instanceof ChildCategoryNode && Arrays.asList(((ChildCategoryNode)selection).getChildrenFeatures()).contains(CarnotWorkflowModelPackage.eINSTANCE.getModelType_Application());
    }

    public void run() {
        this.execute((Command)this.createCommand());
        CreationUtils.showInOutlineAndEdit((EObject)this.application);
    }

    private CompoundDiagramCommand createCommand() {
        IdFactory id = new IdFactory(this.config == null ? "application" : this.config.getAttribute("id"), this.config == null ? Diagram_Messages.NodeCreationFactory_BASENAME_Application : this.config.getAttribute("name"));
        CompoundDiagramCommand command = new CompoundDiagramCommand();
        if (this.config != null) {
            command.add(new CreateMetaTypeCommand(this.config, CarnotWorkflowModelPackage.eINSTANCE.getApplicationTypeType(), new EStructuralFeature[]{CarnotWorkflowModelPackage.eINSTANCE.getApplicationTypeType_Synchronous()}));
        }
        command.add(new CreateTypedModelElementCommand(2, id, this.config == null ? null : this.config.getAttribute("id"), (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getModelType_ApplicationType(), CarnotWorkflowModelPackage.eINSTANCE.getApplicationType()){

            @Override
            protected IModelElement createModelElement() {
                List attributes;
                ApplicationType element = (ApplicationType)super.createModelElement();
                IApplicationInitializer initializer = CreateApplicationAction.this.getInitializer(element.getType());
                if (initializer != null && (attributes = initializer.initialize(element, new ArrayList())) != null) {
                    element.getAttribute().addAll((Collection)attributes);
                }
                CreateApplicationAction.this.application = element;
                return element;
            }
        });
        command.setParent((EObject)(this.getModel() == null ? ((EditPart)this.getSelectedObjects().get(0)).getParent().getModel() : this.getModel()));
        return command;
    }

    private IApplicationInitializer getInitializer(ApplicationTypeType type) {
        SpiExtensionRegistry registry;
        Map extensions;
        IConfigurationElement config;
        if (type != null && (config = (IConfigurationElement)(extensions = (registry = SpiExtensionRegistry.instance()).getExtensions("applicationTypes")).get(type.getId())) != null) {
            try {
                return (IApplicationInitializer)config.createExecutableExtension("initializerClass");
            }
            catch (CoreException coreException) {
            }
            catch (ClassCastException classCastException) {}
        }
        return null;
    }

    private ModelType getModel() {
        Object model;
        Object selection = this.getSelectedObjects().get(0);
        if (selection instanceof EditPart && (model = ((EditPart)selection).getModel()) instanceof ModelType) {
            return (ModelType)model;
        }
        return null;
    }
}

