/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.util.Collections;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.ShowPropertiesAction;
import org.eclipse.stardust.modeling.core.editors.parts.tree.ChildCategoryNode;
import org.eclipse.stardust.modeling.core.modelserver.ModelServer;
import org.eclipse.stardust.modeling.core.modelserver.ModelServerUtils;
import org.eclipse.stardust.modeling.repository.common.Connection;
import org.eclipse.stardust.modeling.repository.common.ConnectionManager;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class CreateRepositoryConnectionAction
extends SelectionAction {
    private IConfigurationElement config;
    protected DataType data;
    private ConnectionManager manager;
    private ModelType modelType;

    public CreateRepositoryConnectionAction(IConfigurationElement config, WorkflowModelEditor part) {
        super((IWorkbenchPart)part);
        this.modelType = (ModelType)part.getModel();
        this.config = config;
        this.setId("org.eclipse.stardust.modeling.repository.common.create." + config.getAttribute("id"));
        this.setText(config.getAttribute("name"));
        this.setImageDescriptor(DiagramPlugin.getImageDescriptor(config));
    }

    protected boolean calculateEnabled() {
        return !this.getSelectedObjects().isEmpty() && this.isConnectionCategory();
    }

    private boolean isConnectionCategory() {
        String label;
        Object model;
        Object selection = this.getSelectedObjects().get(0);
        return selection instanceof ChildCategoryNode && (model = ((ChildCategoryNode)selection).getModel()) instanceof ChildCategoryNode.Spec && (label = ((ChildCategoryNode.Spec)model).label).equals(Diagram_Messages.LBL_EXTERNAL_MD_INFORMATION);
    }

    public void run() {
        Boolean lockedByCurrentUser;
        WorkflowModelEditor editor = (WorkflowModelEditor)this.getWorkbenchPart();
        this.manager = editor.getConnectionManager();
        ModelServer modelServer = editor.getModelServer();
        if (modelServer.isModelShared() && (lockedByCurrentUser = ModelServerUtils.isLockedByCurrentUser((EObject)this.modelType)) != null && lockedByCurrentUser.equals(Boolean.FALSE)) {
            MessageDialog.openInformation(null, (String)Diagram_Messages.MSG_DIA_REPOSITORY_CONNECTION, (String)Diagram_Messages.MSG_DIA_THIS_OPERATION_REQUIRES_THE_MD_TO_BE_LOCKED_YOU_MUST_LOCK_THE_MD_TO_PROCEED);
            return;
        }
        boolean create = true;
        try {
            ChangeRecorder recorder = new ChangeRecorder();
            recorder.beginRecording(Collections.singleton(this.manager.getRepository()));
            Connection connection = this.manager.create(this.config.getAttribute("id"));
            EditPart part = editor.findEditPart(connection);
            final StructuredSelection selection = new StructuredSelection((Object)part);
            ShowPropertiesAction propDlgAction = new ShowPropertiesAction(editor, new ISelectionProvider(){

                public void addSelectionChangedListener(ISelectionChangedListener listener) {
                }

                public ISelection getSelection() {
                    return selection;
                }

                public void removeSelectionChangedListener(ISelectionChangedListener listener) {
                }

                public void setSelection(ISelection selection2) {
                }
            });
            String contributor = this.config.getNamespace();
            if (contributor != null) {
                Bundle bundle = Platform.getBundle((String)contributor);
                try {
                    bundle.start();
                }
                catch (BundleException bundleException) {
                    ErrorDialog.openError((Shell)editor.getSite().getShell(), (String)Diagram_Messages.ERROR_DIA_ERROR, (String)Diagram_Messages.ERROR_DIA_CANNOT_START_BUNDLE, (IStatus)new Status(4, contributor, 0, Diagram_Messages.ERROR_DIA_CANNOT_START_BUNDLE, null));
                    create = false;
                }
            }
            if (!create) {
                if (recorder.isRecording()) {
                    ChangeDescription changes = recorder.endRecording();
                    changes.apply();
                }
                return;
            }
            PreferenceDialog dlg = propDlgAction.createDialog(recorder);
            if (dlg != null) {
                dlg.setBlockOnOpen(true);
                if (dlg.open() == 0) {
                    connection.setProperty("ConnectionManager.CREATED", (Object)"false");
                    connection.setProperty("ConnectionManager", (Object)this.manager);
                    connection.eNotify((Notification)new NotificationImpl(1, null, null));
                }
            }
        }
        catch (InvalidRegistryObjectException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

