/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.gef.ui.actions.DeleteAction;
import org.eclipse.stardust.model.xpdl.carnot.AbstractEventSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ActivitySymbolType;
import org.eclipse.stardust.model.xpdl.carnot.AnnotationSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.GatewaySymbol;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.LaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.TextSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.cap.CopyPasteUtil;
import org.eclipse.stardust.modeling.core.editors.cap.CreateSubprocess;
import org.eclipse.stardust.modeling.core.editors.cap.DiagramMerger;
import org.eclipse.stardust.modeling.core.editors.cap.StoreObject;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractNodeSymbolEditPart;
import org.eclipse.stardust.modeling.core.modelserver.ModelServer;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;
import org.eclipse.stardust.modeling.core.utils.PoolLaneUtils;
import org.eclipse.ui.IWorkbenchPart;

public class CreateSubprocessFromSelectionAction
extends DeleteAction {
    private WorkflowModelEditor editor;
    private StoreObject storage;
    protected List copySet;

    public CreateSubprocessFromSelectionAction(IWorkbenchPart part) {
        super(part);
        this.editor = (WorkflowModelEditor)part;
        this.setId("org.eclipse.stardust.modeling.core.createSubprocessFromSelection");
        this.setText(Diagram_Messages.LB_CreateSubprocess);
        this.setImageDescriptor(DiagramPlugin.getImageDescriptor("icons/full/obj16/process.gif"));
        this.setToolTipText(Diagram_Messages.LB_CreateSubprocess);
    }

    protected boolean calculateEnabled() {
        List selection = this.getSelectedObjects();
        if (selection == null || selection.size() <= 0) {
            return false;
        }
        if (CopyPasteUtil.validateSelectionForSubprocess(selection)) {
            AbstractNodeSymbolEditPart ep = (AbstractNodeSymbolEditPart)selection.get(0);
            EObject modelElement = (EObject)ep.getModel();
            WorkflowModelEditor editor = GenericUtils.getWorkflowModelEditor(ModelUtils.findContainingModel((EObject)modelElement));
            ModelServer server = editor.getModelServer();
            return server == null || !server.requireLock((EObject)ep.getModel());
        }
        return false;
    }

    public void run() {
        List content = CopyPasteUtil.createCopySet(new Integer(2), this.getSelectedObjects(), this.editor, false);
        this.copySet = this.extractStorage(content);
        EditPart targetEP = PoolLaneUtils.findTargetEditPart((WorkflowModelEditor)this.getWorkbenchPart());
        this.setPosition(targetEP);
        LaneSymbol lane = this.getLane(targetEP);
        List selection = this.getSelectedObjects();
        ArrayList symbols = new ArrayList();
        ArrayList modelSymbols = new ArrayList();
        CreateSubprocessFromSelectionAction.filterSelection(symbols, modelSymbols, selection);
        CreateSubprocess createSubprocess = new CreateSubprocess(selection, this.storage, this.editor);
        createSubprocess.setLaneSymbol(lane);
        ChangeRecorder targetRecorder = new ChangeRecorder();
        targetRecorder.beginRecording(Collections.singleton(this.storage.getSourceModel()));
        createSubprocess.deleteSymbols(symbols);
        createSubprocess.deleteElements(modelSymbols);
        createSubprocess.createElements();
        createSubprocess.updateStorage();
        createSubprocess.reconnectConnections();
        DiagramMerger util = new DiagramMerger(this.storage.getTargetModel(), this.copySet, this.storage, DiagramMerger.CREATE_SUBPROCESS);
        util.merge();
        final ChangeDescription change = targetRecorder.endRecording();
        targetRecorder.dispose();
        Command cmd = new Command(){

            public void execute() {
            }

            public void undo() {
                change.applyAndReverse();
            }

            public void redo() {
                change.applyAndReverse();
            }
        };
        this.getCommandStack().execute(cmd);
    }

    private void setPosition(EditPart targetEP) {
        if (targetEP.getModel() != null) {
            INodeSymbol model = (INodeSymbol)targetEP.getModel();
            Point location = new Point((double)model.getXPos(), (double)model.getYPos());
            this.storage.setLocation(location);
        }
    }

    private LaneSymbol getLane(EditPart targetEP) {
        if (targetEP.getModel() != null) {
            EObject container;
            INodeSymbol model = (INodeSymbol)targetEP.getModel();
            Point location = new Point((double)model.getXPos(), (double)model.getYPos());
            this.storage.setLocation(location);
            if (model.eContainer() != null && (container = model.eContainer()) instanceof LaneSymbol) {
                return (LaneSymbol)container;
            }
        }
        return null;
    }

    private List extractStorage(List currentContent) {
        ArrayList copySet = new ArrayList();
        int i = 0;
        while (i < currentContent.size()) {
            Object entry = currentContent.get(i);
            if (entry instanceof StoreObject) {
                this.storage = (StoreObject)entry;
            } else {
                copySet.add(entry);
            }
            ++i;
        }
        return copySet;
    }

    public static void filterSelection(List symbols, List modelSymbols, List selectionList) {
        ArrayList gateways = new ArrayList();
        int i = 0;
        while (i < selectionList.size()) {
            Object entry = selectionList.get(i);
            EObject symbol = (EObject)((AbstractEditPart)entry).getModel();
            if (symbol instanceof AnnotationSymbolType || symbol instanceof TextSymbolType) {
                symbols.add(symbol);
            } else if ((symbol instanceof ActivitySymbolType || symbol instanceof AbstractEventSymbol) && ((IModelElementNodeSymbol)symbol).getModelElement() != null) {
                EList gatewaySymbols;
                modelSymbols.add(symbol);
                if (symbol instanceof ActivitySymbolType && !(gatewaySymbols = ((ActivitySymbolType)symbol).getGatewaySymbols()).isEmpty()) {
                    gateways.addAll(gatewaySymbols);
                }
            } else {
                symbols.add(symbol);
            }
            ++i;
        }
        i = 0;
        while (i < gateways.size()) {
            GatewaySymbol gatewaySymbol = (GatewaySymbol)gateways.get(i);
            if (!symbols.contains(gatewaySymbol)) {
                symbols.add(gatewaySymbol);
            }
            ++i;
        }
    }
}

