/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.gef.ui.actions.Clipboard;
import org.eclipse.gef.ui.actions.DeleteAction;
import org.eclipse.stardust.model.xpdl.carnot.AnnotationSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.IConnectionSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.TextSymbolType;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.cap.CopyPasteUtil;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractNodeSymbolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DeleteConnectionSymbolCmd;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DeleteSymbolCommandFactory;
import org.eclipse.stardust.modeling.core.modelserver.ModelServerUtils;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class CutAction
extends DeleteAction {
    private Clipboard clipboard;
    private Integer isValid;

    public CutAction(IWorkbenchPart part) {
        super(part);
        this.setId(ActionFactory.CUT.getId());
        this.setText(Diagram_Messages.LB_CutElement);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT"));
        this.setToolTipText(Diagram_Messages.LB_CutElement);
        this.setAccelerator(262232);
        this.clipboard = Clipboard.getDefault();
    }

    protected boolean calculateEnabled() {
        List selection = this.getSelectedObjects();
        if (CopyPasteUtil.containsGateway(selection)) {
            return false;
        }
        this.isValid = CopyPasteUtil.validateSelection(selection, true);
        return this.isValid != null;
    }

    public void run() {
        List selectedObjects = this.getSelectedObjects();
        int i = 0;
        while (i < selectedObjects.size()) {
            Boolean lockedByCurrentUser;
            Object entry = selectedObjects.get(i);
            EObject checkSelection = CopyPasteUtil.getEObjectFromSelection(entry);
            if (!(checkSelection instanceof ModelType) && (lockedByCurrentUser = ModelServerUtils.isLockedByCurrentUser(checkSelection)) != null && lockedByCurrentUser.equals(Boolean.FALSE)) {
                ModelServerUtils.showMessageBox(Diagram_Messages.MSG_LOCK_NEEDED);
                return;
            }
            ++i;
        }
        WorkflowModelEditor editor = (WorkflowModelEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        List contentList = CopyPasteUtil.createCopySet(this.isValid, this.getSelectedObjects(), editor, false);
        this.clipboard.setContents((Object)contentList);
        ArrayList symbols = new ArrayList();
        ArrayList modelSymbols = new ArrayList();
        this.filterSelection(symbols, modelSymbols, this.getSelectedObjects());
        CompoundCommand cmd = new CompoundCommand();
        if (symbols.size() == 0 && modelSymbols.size() == 0) {
            cmd.add(super.createDeleteCommand(this.getSelectedObjects()));
        } else {
            cmd.add(super.createDeleteCommand(modelSymbols));
            cmd.add(this.createDeleteSymbolsCommand(symbols));
        }
        this.execute((Command)cmd);
    }

    public void filterSelection(List symbols, List modelSymbols, List selectionList) {
        int i = 0;
        while (i < selectionList.size()) {
            Object entry = selectionList.get(i);
            EObject symbol = (EObject)((AbstractEditPart)entry).getModel();
            IIdentifiableModelElement modelElement = null;
            if (symbol instanceof AnnotationSymbolType || symbol instanceof TextSymbolType) {
                symbols.add(entry);
            } else if (symbol instanceof IModelElementNodeSymbol) {
                modelElement = ((IModelElementNodeSymbol)symbol).getModelElement();
                if (modelElement != null) {
                    modelSymbols.add(entry);
                } else {
                    symbols.add(entry);
                }
            }
            ++i;
        }
    }

    public Command createDeleteSymbolsCommand(List objects) {
        CompoundCommand cmd = new CompoundCommand();
        if (objects.isEmpty()) {
            return null;
        }
        for (EditPart editPart : objects) {
            if (editPart instanceof AbstractConnectionEditPart) {
                cmd.add((Command)new DeleteConnectionSymbolCmd((IConnectionSymbol)editPart.getModel()));
                continue;
            }
            if (!(editPart instanceof AbstractNodeSymbolEditPart)) continue;
            cmd.add(DeleteSymbolCommandFactory.createDeleteSymbolCommand((INodeSymbol)editPart.getModel()));
        }
        return cmd;
    }
}

