/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackage;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.modelserver.ModelServer;
import org.eclipse.stardust.modeling.core.search.ElementReferenceSearcher;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class DeleteExternalReferenceAction
extends SelectionAction {
    private List<ExternalPackage> selectedPackages;
    private WorkflowModelEditor editor;
    private ModelType modelType;

    public DeleteExternalReferenceAction(WorkflowModelEditor part) {
        super((IWorkbenchPart)part);
        this.setId("org.eclipse.stardust.modeling.repository.common.deleteReferences");
        this.setText(Diagram_Messages.TXT_DELETE);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.editor = part;
        this.modelType = (ModelType)this.editor.getModel();
    }

    protected boolean calculateEnabled() {
        this.selectedPackages = this.getSelectedPackages();
        if (this.selectedPackages != null && this.selectedPackages.size() == 1) {
            ModelServer server = this.editor.getModelServer();
            return server == null || !server.requireLock((EObject)this.modelType);
        }
        return false;
    }

    private List<ExternalPackage> getSelectedPackages() {
        if (this.getSelectedObjects().size() == 0) {
            return null;
        }
        List selection = this.getSelectedObjects();
        ArrayList<ExternalPackage> result = new ArrayList<ExternalPackage>();
        int i = 0;
        while (i < selection.size()) {
            Object entry = this.getSelectedObjects().get(i);
            if (entry instanceof EditPart) {
                Object model = ((EditPart)entry).getModel();
                if (model instanceof ExternalPackage) {
                    result.add((ExternalPackage)model);
                } else {
                    return null;
                }
            }
            ++i;
        }
        return result.size() == 0 ? null : result;
    }

    public void run() {
        MessageBox messageBox = new MessageBox(Display.getDefault().getActiveShell(), 296);
        messageBox.setText(Diagram_Messages.TXT_WR);
        String message = Diagram_Messages.MSG_THIS_OPERATION_WILL_REMOVE_ALL_REFERENCES_TO_NULL_FROM_MODEL;
        messageBox.setMessage(MessageFormat.format(message, this.selectedPackages.get(0).getHref()));
        if (messageBox.open() == 32) {
            EditDomain domain = this.editor.getEditDomain();
            CompoundCommand command = new CompoundCommand();
            ChangeRecorder targetRecorder = new ChangeRecorder();
            targetRecorder.beginRecording(Collections.singleton(this.modelType.eContainer()));
            this.removeReferences();
            final ChangeDescription change = targetRecorder.endRecording();
            targetRecorder.dispose();
            Command cmd = new Command(){

                public void execute() {
                }

                public void undo() {
                    change.applyAndReverse();
                }

                public void redo() {
                    change.applyAndReverse();
                }
            };
            command.add(cmd);
            domain.getCommandStack().execute((Command)command);
        }
    }

    private void removeReferences() {
        ElementReferenceSearcher searcher = new ElementReferenceSearcher();
        Iterator<ExternalPackage> i = this.selectedPackages.iterator();
        while (i.hasNext()) {
            ArrayList<Object> list = new ArrayList<Object>();
            ExternalPackage externalPackage = i.next();
            Map resultMap = searcher.search((EObject)externalPackage);
            for (Object v : resultMap.values()) {
                if (v instanceof ArrayList) {
                    ArrayList elements = (ArrayList)v;
                    Iterator k = elements.iterator();
                    while (k.hasNext()) {
                        list.add(k.next());
                    }
                    continue;
                }
                list.add(v);
            }
            for (Object object : list) {
                if (object instanceof DataType) {
                    DataType dataType = (DataType)object;
                    AttributeUtil.setAttribute((List)dataType.getAttribute(), (String)"carnot:connection:uri", null);
                    dataType.setExternalReference(null);
                }
                if (object instanceof ProcessDefinitionType) {
                    ProcessDefinitionType processDefinitionType = (ProcessDefinitionType)object;
                    processDefinitionType.setExternalRef(null);
                }
                if (!(object instanceof ActivityType)) continue;
                ActivityType activityType = (ActivityType)object;
                activityType.setExternalRef(null);
            }
            this.modelType.getExternalPackages().getExternalPackage().remove((Object)externalPackage);
            if (!this.modelType.getExternalPackages().getExternalPackage().isEmpty()) continue;
            this.modelType.setExternalPackages(null);
        }
    }
}

