/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.modelserver.ModelServerUtils;
import org.eclipse.stardust.modeling.deploy.DeployUtil;
import org.eclipse.ui.IWorkbenchPart;

public class DeployModelAction
extends SelectionAction {
    public DeployModelAction(WorkflowModelEditor editor) {
        super((IWorkbenchPart)editor);
        this.setId("org.eclipse.stardust.modeling.core.deployModel");
        this.setText(Diagram_Messages.LB_DeployModel);
        this.setToolTipText(Diagram_Messages.LB_DeployModel);
        this.setImageDescriptor(DiagramPlugin.getImageDescriptor("icons/full/obj16/model.gif"));
    }

    protected boolean calculateEnabled() {
        return this.getSelectedObjects().size() == 1 && this.getModel() != null;
    }

    public void run() {
        DeployModelAction.deploy(this.getModel());
    }

    public static boolean deploy(ModelType model) {
        IFile modelFile = ModelServerUtils.getModelFile(model);
        return DeployUtil.deployModel(Collections.singletonList(modelFile), null, null);
    }

    private ModelType getModel() {
        Object selection = this.getSelectedObjects().get(0);
        if (!(selection instanceof EditPart)) {
            return null;
        }
        Object element = ((EditPart)selection).getModel();
        return (ModelType)(element instanceof ModelType ? element : null);
    }
}

