/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.text.MessageFormat;
import java.util.HashSet;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DataMappingType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.AutomaticIdentifierDialog;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.InvalidIdentifierDialog;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.SetValueCmd;
import org.eclipse.stardust.modeling.core.modelserver.ModelServer;
import org.eclipse.swt.widgets.Shell;

public class FixInvalidIdsAction {
    private WorkflowModelEditor editor;
    private IModelElement element;
    private boolean autoCreate;
    private boolean autoReplace;
    private boolean autoPrefix;
    private InvalidIdentifierDialog replaceDialog;
    private InvalidIdentifierDialog prefixDialog;
    private AutomaticIdentifierDialog noidDialog;
    private boolean fixCreate = true;
    private boolean fixReplace = true;
    private boolean fixPrefix = true;

    public FixInvalidIdsAction(WorkflowModelEditor editor, IModelElement element) {
        this.editor = editor;
        this.element = element;
        this.autoCreate = false;
        this.autoReplace = false;
        this.autoPrefix = false;
        this.replaceDialog = new InvalidIdentifierDialog(editor.getSite().getShell(), this.element == null, true);
        this.prefixDialog = new InvalidIdentifierDialog(editor.getSite().getShell(), this.element == null, false);
        this.noidDialog = new AutomaticIdentifierDialog(editor.getSite().getShell(), this.element == null);
    }

    private void fixAll() {
        ModelType model = this.editor.getWorkflowModel();
        if (model == null) {
            return;
        }
        CompoundCommand command = new CompoundCommand();
        HashSet<EObject> visited = new HashSet<EObject>();
        TreeIterator itr = model.eAllContents();
        while (itr.hasNext()) {
            EObject item = (EObject)itr.next();
            if (visited.contains(item)) continue;
            visited.add(item);
            if (!(item instanceof DataType) && !(item instanceof AccessPointType)) continue;
            this.fixIdentifiable(command, (IModelElement)item, false);
        }
        if (command.canExecute()) {
            this.editor.getEditDomain().getCommandStack().execute((Command)command);
        }
    }

    private void fixOne() {
        CompoundCommand command = new CompoundCommand();
        this.fixIdentifiable(command, this.element, true);
        if (command.canExecute()) {
            this.editor.getEditDomain().getCommandStack().execute((Command)command);
        }
    }

    private void fixIdentifiable(CompoundCommand command, IModelElement identifiable, boolean showLockMessage) {
        boolean notFixed;
        ModelServer server = this.editor.getModelServer();
        if (server != null && server.requireLock((EObject)identifiable)) {
            if (showLockMessage) {
                EObject lockable = server.getLockableElement((EObject)identifiable);
                String id = this.getId(lockable);
                String type = this.getType(identifiable.eClass());
                String messageTitle = Diagram_Messages.MSG_DIA_INVALID_ID_NULL_ONE;
                String message = Diagram_Messages.MSG_DIA_ELEMENT_NULL_ONE_MUST_BE_LOCKED_FIRST;
                MessageDialog.openWarning((Shell)this.editor.getSite().getShell(), (String)MessageFormat.format(messageTitle, id, type), (String)MessageFormat.format(message, id, type));
            }
            throw new OperationCanceledException();
        }
        String id = this.getId((EObject)identifiable);
        if (identifiable instanceof AccessPointType && id != null && id.startsWith("carnot:engine:")) {
            return;
        }
        String type = this.getType(identifiable.eClass());
        String icon = this.editor.getIconFactory().getIconFor((EObject)identifiable);
        if (this.fixCreate) {
            notFixed = false;
            EStructuralFeature feature = identifiable.eContainingFeature();
            EObject econtainer = identifiable.eContainer();
            this.noidDialog.initialize(econtainer.eGet(feature), icon, type, this.autoCreate);
            while (id == null || id.length() == 0) {
                if (!this.autoCreate || notFixed) {
                    switch (this.noidDialog.open()) {
                        case 0: {
                            id = this.noidDialog.getId();
                            this.autoCreate = this.noidDialog.getAutoPerform();
                            break;
                        }
                        case 1: {
                            throw new OperationCanceledException();
                        }
                    }
                } else if (this.autoCreate) {
                    this.noidDialog.updateId();
                    id = this.noidDialog.getId();
                }
                notFixed = true;
            }
        }
        if (this.fixReplace) {
            this.replaceDialog.initialize(id, icon, type, this.autoReplace);
            notFixed = false;
            while (this.hasBadCharacters(id)) {
                if (!this.autoReplace || notFixed) {
                    switch (this.replaceDialog.open()) {
                        case 0: {
                            id = this.replaceDialog.getId();
                            this.autoReplace = this.replaceDialog.getAutoPerform();
                            break;
                        }
                        case 1: {
                            throw new OperationCanceledException();
                        }
                    }
                } else if (this.autoReplace) {
                    this.replaceDialog.updateId();
                    id = this.replaceDialog.getId();
                }
                notFixed = true;
            }
        }
        if (this.fixPrefix) {
            this.prefixDialog.initialize(id, icon, type, this.autoPrefix);
            notFixed = false;
            while (!Character.isJavaIdentifierStart(id.charAt(0))) {
                if (!this.autoPrefix || notFixed) {
                    switch (this.prefixDialog.open()) {
                        case 0: {
                            id = this.prefixDialog.getId();
                            this.autoPrefix = this.prefixDialog.getAutoPerform();
                            break;
                        }
                        case 1: {
                            throw new OperationCanceledException();
                        }
                    }
                } else if (this.autoPrefix) {
                    this.prefixDialog.updateId();
                    id = this.prefixDialog.getId();
                }
                notFixed = true;
            }
        }
        if (!id.equals(this.getId((EObject)identifiable)) && (identifiable instanceof DataType || identifiable instanceof AccessPointType)) {
            command.add((Command)new SetValueCmd((EObject)identifiable, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getIIdentifiableElement_Id(), (Object)id));
        }
    }

    private String getId(EObject element) {
        return element instanceof IIdentifiableElement ? ((IIdentifiableElement)element).getId() : (element instanceof DataMappingType ? ((DataMappingType)element).getId() : null);
    }

    private String getType(EClass eClass) {
        String name = eClass.getName();
        if (name.length() > 4 && name.endsWith("Type")) {
            name = name.substring(0, name.length() - 4);
        }
        return name;
    }

    private boolean hasBadCharacters(String id) {
        return !ModelUtils.isValidId((String)id);
    }

    public static void run(WorkflowModelEditor editor) {
        try {
            new FixInvalidIdsAction(editor, null).fixAll();
        }
        catch (OperationCanceledException operationCanceledException) {}
    }

    public static void run(WorkflowModelEditor editor, IModelElement element) {
        try {
            new FixInvalidIdsAction(editor, element).fixOne();
        }
        catch (OperationCanceledException operationCanceledException) {}
    }
}

