/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.GroupSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.IConnectionSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IGraphicalObject;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ISymbolContainer;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractConnectionSymbolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractNodeSymbolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractSwimlaneEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.AddNodeSymbolCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DeleteValueCmd;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.HideConnectionSymbolsCmd;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.SetValueCmd;
import org.eclipse.stardust.modeling.core.modelserver.ModelServerUtils;
import org.eclipse.ui.IWorkbenchPart;

public class GroupSymbolsAction
extends SelectionAction {
    public GroupSymbolsAction(IWorkbenchPart part) {
        super(part);
        this.setId("org.eclipse.stardust.modeling.core.groupSymbols");
        this.setText(Diagram_Messages.GROUP_SYMBOLS_LABEL);
    }

    protected boolean calculateEnabled() {
        Command cmd = this.createGroupSymbolsCommand();
        return cmd != null ? cmd.canExecute() : false;
    }

    public void run() {
        this.execute(this.createGroupSymbolsCommand());
    }

    private Command createGroupSymbolsCommand() {
        CompoundCommand result = new CompoundCommand();
        HashSet<EObject> parents = new HashSet<EObject>();
        HashSet nodeEditParts = new HashSet();
        HashSet connections = new HashSet();
        Rectangle bounds = null;
        for (Object element : this.getSelectedObjects()) {
            if (element instanceof AbstractSwimlaneEditPart) {
                return UnexecutableCommand.INSTANCE;
            }
            if (element instanceof AbstractNodeSymbolEditPart) {
                Boolean lockedByCurrentUser;
                INodeSymbol node = (INodeSymbol)((AbstractNodeSymbolEditPart)element).getModel();
                ProcessDefinitionType container = ModelUtils.findContainingProcess((EObject)node);
                if (container == null) {
                    container = ModelUtils.findContainingDiagram((IGraphicalObject)node);
                }
                if ((lockedByCurrentUser = ModelServerUtils.isLockedByCurrentUser((EObject)container)) != null && lockedByCurrentUser.equals(Boolean.FALSE)) {
                    return UnexecutableCommand.INSTANCE;
                }
                if (node.eContainer() instanceof ISymbolContainer) {
                    parents.add(node.eContainer());
                } else {
                    result.add((Command)UnexecutableCommand.INSTANCE);
                }
                nodeEditParts.add(element);
                Rectangle nodeBounds = new Rectangle((int)node.getXPos(), (int)node.getYPos(), Math.max(0, node.getWidth()), Math.max(0, node.getHeight()));
                bounds = bounds == null ? nodeBounds : bounds.union(nodeBounds);
                continue;
            }
            if (!(element instanceof AbstractConnectionSymbolEditPart)) continue;
            result.add((Command)UnexecutableCommand.INSTANCE);
        }
        if (1 >= nodeEditParts.size() + connections.size()) {
            result.add((Command)UnexecutableCommand.INSTANCE);
        }
        if (1 == parents.size()) {
            if (bounds == null) {
                bounds = new Rectangle(0, 0, 0, 0);
            }
            CompoundCommand cmdAddToGroup = new CompoundCommand();
            GroupSymbolType group = CarnotWorkflowModelFactory.eINSTANCE.createGroupSymbolType();
            group.setXPos((long)bounds.x);
            group.setYPos((long)bounds.y);
            HashSet<INodeSymbol> nodes = new HashSet<INodeSymbol>();
            for (AbstractNodeSymbolEditPart nodeEditPart : nodeEditParts) {
                INodeSymbol node = (INodeSymbol)nodeEditPart.getModel();
                nodes.add(node);
                if (node.eContainmentFeature() != null) {
                    result.add((Command)new HideConnectionSymbolsCmd(nodeEditPart));
                    result.add((Command)new DeleteValueCmd(node.eContainer(), node, (EStructuralFeature)node.eContainmentFeature()));
                    cmdAddToGroup.add((Command)new SetValueCmd((EObject)node, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getINodeSymbol_XPos(), (Object)new Long(node.getXPos() - (long)bounds.x)));
                    cmdAddToGroup.add((Command)new SetValueCmd((EObject)node, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getINodeSymbol_YPos(), (Object)new Long(node.getYPos() - (long)bounds.y)));
                    cmdAddToGroup.add((Command)new SetValueCmd((EObject)group, (EStructuralFeature)node.eContainmentFeature(), (Object)node));
                    continue;
                }
                result.add((Command)UnexecutableCommand.INSTANCE);
            }
            Iterator i = connections.iterator();
            while (i.hasNext()) {
                IConnectionSymbol connection = (IConnectionSymbol)i.next();
                if (nodes.contains(connection.getSourceNode()) && nodes.contains(connection.getTargetNode())) {
                    if (connection.eContainmentFeature() != null) {
                        result.add((Command)new DeleteValueCmd(connection.eContainer(), connection, (EStructuralFeature)connection.eContainmentFeature()));
                        result.add((Command)new SetValueCmd((EObject)group, (EStructuralFeature)connection.eContainmentFeature(), (Object)connection));
                        continue;
                    }
                    result.add((Command)UnexecutableCommand.INSTANCE);
                    continue;
                }
                i.remove();
            }
            if (1 >= nodes.size() + connections.size()) {
                result.add((Command)UnexecutableCommand.INSTANCE);
            }
            AddNodeSymbolCommand cmdAddGroup = new AddNodeSymbolCommand();
            cmdAddGroup.setDiagram((ISymbolContainer)parents.iterator().next());
            cmdAddGroup.setNodeSymbol((INodeSymbol)group, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getISymbolContainer_GroupSymbol());
            result.add((Command)cmdAddGroup);
            result.add((Command)cmdAddToGroup);
        } else {
            result.add((Command)UnexecutableCommand.INSTANCE);
        }
        return result.unwrap();
    }
}

