/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.tree.ModelTreeEditPart;
import org.eclipse.stardust.modeling.core.modelserver.ModelServer;
import org.eclipse.stardust.modeling.core.modelserver.ModelServerUtils;
import org.eclipse.stardust.modeling.core.modelserver.RMSException;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;
import org.eclipse.ui.IWorkbenchPart;

public class LockAllAction
extends SelectionAction {
    public LockAllAction(WorkflowModelEditor editor) {
        super((IWorkbenchPart)editor);
        this.setText(Diagram_Messages.LB_LOCK_ALL);
        this.setToolTipText(Diagram_Messages.LB_LOCK_ALL);
        this.setId("org.eclipse.stardust.modeling.core.lockAllAction");
        this.setImageDescriptor(DiagramPlugin.getImageDescriptor("icons/full/obj16/lock.gif"));
    }

    protected boolean calculateEnabled() {
        if (this.getSelectedObjects().size() != 1) {
            return false;
        }
        Object selection = this.getSelectedObjects().get(0);
        if (selection instanceof ModelTreeEditPart) {
            ModelType model = (ModelType)((ModelTreeEditPart)selection).getModel();
            WorkflowModelEditor editor = GenericUtils.getWorkflowModelEditor(model);
            return editor.getModelServer().isModelShared();
        }
        return false;
    }

    public void run() {
        Object selection = this.getSelectedObjects().get(0);
        if (selection instanceof ModelTreeEditPart) {
            WorkflowModelEditor editor = (WorkflowModelEditor)this.getWorkbenchPart();
            if (editor.isDirty()) {
                ModelServerUtils.showMessageBox(Diagram_Messages.MSG_SAVE_MODEL_NEEDED);
                return;
            }
            final ModelServer modelServer = editor.getModelServer();
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        modelServer.lockAll(monitor);
                    }
                    catch (RMSException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            try {
                new ProgressMonitorDialog(editor.getSite().getShell()).run(true, true, op);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getCause();
                ModelServerUtils.showMessageBox(t.getMessage());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

