/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.ui.actions.Clipboard;
import org.eclipse.stardust.model.xpdl.carnot.LaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.util.ModelOidUtil;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.cap.AbstractMerger;
import org.eclipse.stardust.modeling.core.editors.cap.CopyPasteUtil;
import org.eclipse.stardust.modeling.core.editors.cap.DiagramMerger;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractSwimlaneEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.LaneEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.PoolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.AbstractPasteAction;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DelegatingCommand;
import org.eclipse.stardust.modeling.core.modelserver.ModelServerUtils;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;
import org.eclipse.stardust.modeling.core.utils.PoolLaneUtils;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class PasteSymbolAction
extends AbstractPasteAction {
    public PasteSymbolAction(IWorkbenchPart part) {
        super(part);
        this.setText(Diagram_Messages.LB_PasteSymbol);
        this.setToolTipText(Diagram_Messages.LB_PasteSymbol);
        this.setId("org.eclipse.stardust.modeling.core.pasteSymbolAction");
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        this.clipboard = Clipboard.getDefault();
    }

    protected boolean calculateEnabled() {
        boolean isEnabled = false;
        if (!this.isValidSelection()) {
            return false;
        }
        if (this.isValid != 1 && (isEnabled = this.isValidForDiagram())) {
            isEnabled = this.storage.isCopySymbols();
        }
        if (isEnabled) {
            ProcessDefinitionType targetProcess;
            EObject targetObject;
            if (!this.storage.getSourceModel().equals(this.targetModel)) {
                return false;
            }
            if (this.isValid == 4 && (targetObject = this.getTargetObject()) != null && (targetProcess = ModelUtils.findContainingProcess((EObject)targetObject)) != null && targetProcess.equals(this.storage.getSourceProcess())) {
                return true;
            }
            if (this.isValid == 3) {
                return true;
            }
        }
        return false;
    }

    public void run() {
        DiagramMerger util;
        Integer isValid;
        ChangeRecorder targetRecorder;
        block22: {
            ProcessDefinitionType targetProcess;
            Boolean lockedByCurrentUser;
            EObject checkSelection = CopyPasteUtil.getEObjectFromSelection(this.getSelectedObjects().get(0));
            if (!(checkSelection instanceof ModelType) && (lockedByCurrentUser = ModelServerUtils.isLockedByCurrentUser(checkSelection)) != null && lockedByCurrentUser.equals(Boolean.FALSE)) {
                ModelServerUtils.showMessageBox(Diagram_Messages.MSG_LOCK_NEEDED);
                return;
            }
            if (this.storage.getSourceModel().equals(this.targetModel)) {
                this.storage.setSameModel(true);
            } else {
                this.storage.setSameModel(false);
            }
            targetRecorder = new ChangeRecorder();
            targetRecorder.beginRecording(Collections.singleton(this.targetModel));
            isValid = CopyPasteUtil.validateSelection(this.copySet, false);
            EObject targetObject = this.getTargetObject();
            if (targetObject != null && (targetProcess = ModelUtils.findContainingProcess((EObject)targetObject)) != null) {
                this.storage.setTargetProcess(targetProcess);
            }
            util = new DiagramMerger(this.targetModel, this.copySet, this.storage, DiagramMerger.CREATE_SYMBOLS);
            WorkflowModelEditor targetEditor = GenericUtils.getWorkflowModelEditor(this.targetModel);
            ModelOidUtil modelOidUtil = null;
            if (targetEditor != null) {
                modelOidUtil = targetEditor.getModelManager().getModelOidUtil();
            }
            try {
                try {
                    if (modelOidUtil != null) {
                        modelOidUtil.setCopyPaste(true);
                    }
                    ((AbstractMerger)util).merge();
                }
                catch (Exception exception) {
                    if (modelOidUtil != null) {
                        modelOidUtil.setCopyPaste(false);
                    }
                    break block22;
                }
            }
            catch (Throwable throwable) {
                if (modelOidUtil != null) {
                    modelOidUtil.setCopyPaste(false);
                }
                throw throwable;
            }
            if (modelOidUtil != null) {
                modelOidUtil.setCopyPaste(false);
            }
        }
        if (util.modelChanged()) {
            CompoundCommand cmd = new CompoundCommand();
            if (isValid != 1) {
                EditPart targetEditPart;
                if (this.copySet.get(0) instanceof LaneSymbol) {
                    this.copyLanes = true;
                }
                if ((targetEditPart = this.storage.getTargetEditPart()) instanceof LaneEditPart || targetEditPart instanceof PoolEditPart) {
                    if (this.copyLanes) {
                        cmd.add((Command)new DelegatingCommand(){

                            @Override
                            public Command createDelegate() {
                                return PoolLaneUtils.reorderLanes((AbstractSwimlaneEditPart)targetEditPart, new Integer(2));
                            }
                        });
                    } else {
                        cmd.add((Command)new DelegatingCommand(){

                            @Override
                            public Command createDelegate() {
                                return PoolLaneUtils.resizeLane((AbstractSwimlaneEditPart)targetEditPart);
                            }
                        });
                    }
                    cmd.add((Command)new DelegatingCommand(){

                        @Override
                        public Command createDelegate() {
                            return PoolLaneUtils.reorderSiblings(targetEditPart, null);
                        }
                    });
                }
            }
            final ChangeDescription change = targetRecorder.endRecording();
            targetRecorder.dispose();
            cmd.add(new Command(){

                public void execute() {
                }

                public void undo() {
                    change.applyAndReverse();
                }

                public void redo() {
                    change.applyAndReverse();
                }
            });
            this.getCommandStack().execute((Command)cmd);
        } else if (targetRecorder.isRecording()) {
            ChangeDescription changes = targetRecorder.endRecording();
            targetRecorder.dispose();
            changes.apply();
        }
    }
}

