/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.io.IOException;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.tree.ModelTreeEditPart;
import org.eclipse.stardust.modeling.core.modelserver.ModelServer;
import org.eclipse.stardust.modeling.core.modelserver.ModelServerUtils;
import org.eclipse.stardust.modeling.core.modelserver.RMSException;
import org.eclipse.stardust.modeling.core.modelserver.ui.VcsFeedView;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class ShareModelAction
extends SelectionAction {
    public ShareModelAction(WorkflowModelEditor editor) {
        super((IWorkbenchPart)editor);
        this.setText(Diagram_Messages.LB_ShareModel);
        this.setToolTipText(Diagram_Messages.LB_ShareModel);
        this.setId("org.eclipse.stardust.modeling.core.shareModelAction");
        this.setImageDescriptor(DiagramPlugin.getImageDescriptor("icons/full/obj16/createrepos.gif"));
    }

    protected boolean calculateEnabled() {
        if (this.getSelectedObjects().size() != 1) {
            return false;
        }
        Object selection = this.getSelectedObjects().get(0);
        if (selection instanceof ModelTreeEditPart) {
            ModelType model = (ModelType)((ModelTreeEditPart)selection).getModel();
            WorkflowModelEditor editor = GenericUtils.getWorkflowModelEditor(model);
            ModelServer modelServer = editor.getModelServer();
            return !modelServer.isModelShared() && modelServer.isProjectShared();
        }
        return false;
    }

    public void run() {
        WorkflowModelEditor editor = (WorkflowModelEditor)this.getWorkbenchPart();
        if (editor.isDirty()) {
            ModelServerUtils.showMessageBox(Diagram_Messages.MSG_SAVE_MODEL_NEEDED);
            return;
        }
        try {
            try {
                editor.getEditorChangeTracker().setEnabled(false);
                editor.getModelServer().share();
            }
            catch (RMSException e) {
                ModelServerUtils.showMessageBox(e.getMessage());
                editor.getEditorChangeTracker().setEnabled(true);
                return;
            }
            catch (IOException e) {
                ModelServerUtils.showMessageBox(e.getMessage());
                editor.getEditorChangeTracker().setEnabled(true);
                return;
            }
        }
        finally {
            editor.getEditorChangeTracker().setEnabled(true);
        }
        ModelServerUtils.refreshTreeItem(editor.getWorkflowModel());
        editor.getEditDomain().getCommandStack().flush();
        IViewPart view = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.stardust.modeling.core.modelserver.ui.VcsFeedView");
        if (view != null) {
            ((VcsFeedView)view).updateAction(true);
        }
    }
}

