/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.tree.ModelTreeEditPart;
import org.eclipse.stardust.modeling.core.modelserver.ModelServerUtils;
import org.eclipse.stardust.modeling.core.modelserver.RMSException;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class UnLockAllAction
extends SelectionAction {
    public UnLockAllAction(WorkflowModelEditor editor) {
        super((IWorkbenchPart)editor);
        this.setText(Diagram_Messages.LB_UNLOCK_ALL);
        this.setToolTipText(Diagram_Messages.LB_UNLOCK_ALL);
        this.setId("org.eclipse.stardust.modeling.core.unlockAllAction");
        this.setImageDescriptor(DiagramPlugin.getImageDescriptor("icons/full/obj16/unlock.gif"));
    }

    protected boolean calculateEnabled() {
        if (this.getSelectedObjects().size() != 1) {
            return false;
        }
        Object selection = this.getSelectedObjects().get(0);
        if (selection instanceof ModelTreeEditPart) {
            ModelType model = (ModelType)((ModelTreeEditPart)selection).getModel();
            WorkflowModelEditor editor = GenericUtils.getWorkflowModelEditor(model);
            return editor.getModelServer().isModelShared();
        }
        return false;
    }

    public void run() {
        Object selection = this.getSelectedObjects().get(0);
        if (selection instanceof ModelTreeEditPart) {
            final WorkflowModelEditor editor = (WorkflowModelEditor)this.getWorkbenchPart();
            if (editor.isDirty()) {
                ModelServerUtils.showMessageBox(Diagram_Messages.MSG_SAVE_MODEL_NEEDED);
                return;
            }
            Dialog messageBox = new Dialog(Display.getDefault().getActiveShell()){

                protected void configureShell(Shell shell) {
                    super.configureShell(shell);
                    shell.setText(Diagram_Messages.LB_UNLOCK_ALL);
                }

                protected Control createDialogArea(Composite parent) {
                    Composite panel = (Composite)super.createDialogArea(parent);
                    FormBuilder.createLabel((Composite)panel, (String)Diagram_Messages.MSG_UNLOCK_ALL);
                    return panel;
                }
            };
            if (messageBox.open() == 0) {
                IRunnableWithProgress op = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            editor.getModelServer().unlockAll(monitor);
                        }
                        catch (RMSException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                };
                try {
                    new ProgressMonitorDialog(editor.getSite().getShell()).run(true, true, op);
                }
                catch (InvocationTargetException e) {
                    Throwable t = e.getCause();
                    ModelServerUtils.showMessageBox(t.getMessage());
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

