/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.commands;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.VariableContextHelper;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.ContainedElementCommand;

public class SetValueCmd
extends ContainedElementCommand {
    private Object value;
    private Object undoValue;
    private EStructuralFeature feature;
    private boolean wasSet;
    private int position = -1;

    public SetValueCmd(int parentLevel, EStructuralFeature feature, Object object) {
        this(parentLevel, null, feature, -1, object);
    }

    public SetValueCmd(EObject parent, EStructuralFeature feature, Object object) {
        this(0, parent, feature, -1, object);
    }

    public SetValueCmd(EObject parent, EStructuralFeature feature, int position, Object object) {
        this(0, parent, feature, position, object);
    }

    public SetValueCmd(int parentLevel, EObject parent, EStructuralFeature feature, int position, Object object) {
        super(parentLevel);
        this.setParent(parent);
        this.value = object;
        this.feature = feature;
        this.position = position;
    }

    public SetValueCmd(EObject parent, EStructuralFeature feature, boolean value) {
        this(parent, feature, -1, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public void execute() {
        this.redo();
    }

    public void redo() {
        EObject parent = this.getContainer();
        if (parent != null) {
            Object ref = parent.eGet(this.feature);
            if (ref instanceof List) {
                if (this.position < 0) {
                    ((List)ref).add(this.getValue());
                } else {
                    ((List)ref).add(this.position, this.getValue());
                }
            } else {
                this.wasSet = parent.eIsSet(this.feature);
                this.undoValue = parent.eGet(this.feature);
                if (parent instanceof ModelType) {
                    ModelType modelType = (ModelType)parent;
                    VariableContextHelper.getInstance().updateContextID(modelType, this.getValue().toString());
                }
                parent.eSet(this.feature, this.getValue());
            }
        }
    }

    public void undo() {
        EObject parent = this.getContainer();
        if (parent != null) {
            Object ref = parent.eGet(this.feature);
            if (ref instanceof List) {
                ((List)ref).remove(this.getValue());
            } else if (this.wasSet) {
                if (parent instanceof ModelType) {
                    ModelType modelType = (ModelType)parent;
                    VariableContextHelper.getInstance().updateContextID(modelType, this.undoValue.toString());
                }
                parent.eSet(this.feature, this.undoValue);
            } else {
                parent.eUnset(this.feature);
            }
        }
    }

    public Object getValue() {
        return this.value;
    }

    public Object getUndoValue() {
        return this.undoValue;
    }
}

