/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.tree;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractTreeEditPart;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.merge.ShareUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.ExtendedAttributeType;
import org.eclipse.stardust.model.xpdl.xpdl2.ExtendedAttributesType;
import org.eclipse.stardust.model.xpdl.xpdl2.Extensible;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.util.ExtendedAttributeUtil;
import org.eclipse.stardust.modeling.common.ui.jface.IImageManager;
import org.eclipse.stardust.modeling.common.ui.jface.IconWithOverlays;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.NotificationAdaptee;
import org.eclipse.stardust.modeling.core.editors.parts.NotificationAdapter;
import org.eclipse.stardust.modeling.core.editors.parts.PropertySourceFactory;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.policies.TreeElementComponentEditPolicy;
import org.eclipse.stardust.modeling.core.modelserver.jobs.CollisionInfo;
import org.eclipse.stardust.modeling.core.modelserver.jobs.CollisionState;
import org.eclipse.stardust.modeling.core.modelserver.jobs.StateCache;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertySource;

public abstract class AbstractEObjectTreeEditPart
extends AbstractTreeEditPart
implements NotificationAdaptee {
    public static final CarnotWorkflowModelPackage PKG_CWM = CarnotWorkflowModelPackage.eINSTANCE;
    public static final int STATE_OK = 0;
    public static final int STATE_WARNINGS = 1;
    public static final int STATE_ERRORS = 2;
    private EStructuralFeature[] childrenFeatures;
    private String iconPath;
    private int state = 0;
    private EObject eObjectModel;
    private NotificationAdapter notificationAdapter;
    private IPropertySource propertySource;
    private WorkflowModelEditor editor;

    public void removeChild(EditPart child) {
        super.removeChild(child);
    }

    public void setState(int state) {
        this.state = state;
        if (this.checkTreeItem()) {
            this.getWidget().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    AbstractEObjectTreeEditPart.this.refreshVisuals();
                }
            });
        }
    }

    protected String getIconPath() {
        return this.iconPath;
    }

    public void setIconPath(String iconPath) {
        this.iconPath = iconPath;
    }

    protected Image getIcon() {
        String iconLocator = this.getIconPath();
        if (StringUtils.isEmpty((String)iconLocator)) {
            return null;
        }
        IImageManager imageManager = DiagramPlugin.getDefault().getImageManager();
        if (this.state == 2) {
            return imageManager.getIcon(iconLocator, 4);
        }
        if (this.state == 1) {
            return imageManager.getIcon(iconLocator, 3);
        }
        EObject object = this.getEObjectModel();
        if (object.eIsProxy()) {
            return imageManager.getIcon(iconLocator, 101);
        }
        String linkUri = this.getLinkUri(object);
        if (linkUri != null) {
            if (this.isRef(object)) {
                return imageManager.getIcon(iconLocator, 101);
            }
            return imageManager.getIcon(iconLocator, 100);
        }
        return imageManager.getIcon(iconLocator, 1);
    }

    private boolean isRef(EObject object) {
        if (object instanceof DataType) {
            return ((DataType)object).getExternalReference() != null;
        }
        if (object instanceof ActivityType) {
            return ((ActivityType)object).getExternalRef() != null;
        }
        return object instanceof IModelParticipant && ModelUtils.findContainingModel((EObject)object) != null && !this.editor.getModel().equals(ModelUtils.findContainingModel((EObject)object));
    }

    private boolean isProvidingInterface(EObject object) {
        ProcessDefinitionType process;
        return object instanceof ProcessDefinitionType && (process = (ProcessDefinitionType)object).getFormalParameterMappings() != null && process.getExternalRef() == null;
    }

    private String getLinkUri(EObject object) {
        if (object instanceof IExtensibleElement) {
            return AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)object), (String)"carnot:connection:uri");
        }
        if (object instanceof Extensible) {
            return ExtendedAttributeUtil.getAttributeValue((Extensible)((Extensible)object), (String)"carnot:connection:uri");
        }
        return null;
    }

    protected AbstractEObjectTreeEditPart(WorkflowModelEditor editor, EObject model) {
        this(editor, model, model, null, null);
    }

    protected AbstractEObjectTreeEditPart(WorkflowModelEditor editor, EObject model, String iconPath) {
        this(editor, model, model, iconPath, null);
    }

    protected AbstractEObjectTreeEditPart(WorkflowModelEditor editor, EObject model, String iconPath, EStructuralFeature[] childrenFeatures) {
        this(editor, model, model, iconPath, childrenFeatures);
    }

    protected AbstractEObjectTreeEditPart(WorkflowModelEditor editor, Object model, EObject eObjectModel, String iconPath, EStructuralFeature[] childrenFeatures) {
        this.setModel(model);
        this.setIconPath(iconPath);
        this.setChildrenFeatures(childrenFeatures);
        this.eObjectModel = eObjectModel;
        this.editor = editor;
    }

    public EObject getEObjectModel() {
        return this.eObjectModel != null ? this.eObjectModel : (EObject)this.getModel();
    }

    protected Image getImage() {
        Image image = this.getIcon();
        image = this.addProcessInterfaceOverlay(image);
        image = this.addPrivateModifierOverlay(image);
        ModelType model = ModelUtils.findContainingModel((EObject)this.eObjectModel);
        WorkflowModelEditor editor = GenericUtils.getWorkflowModelEditor(model);
        if (editor != null && ShareUtils.isLockableElement((Object)this.eObjectModel) && ShareUtils.isModelShared((ModelType)model)) {
            return editor.getModelServer().getIcon(image, this.eObjectModel);
        }
        return image;
    }

    private Image addProcessInterfaceOverlay(Image image) {
        if (image != null && this.getEObjectModel() != null && this.getEObjectModel() instanceof ProcessDefinitionType && this.isProvidingInterface(this.getEObjectModel())) {
            IconWithOverlays iwo = new IconWithOverlays(image, IconWithOverlays.OVR_IF);
            iwo.defaultPosition = 0;
            image = iwo.createImage();
        }
        return image;
    }

    private Image addPrivateModifierOverlay(Image image) {
        String visibilityString = null;
        if (image != null && this.getEObjectModel() != null) {
            AttributeType visibility;
            TypeDeclarationType declaration;
            ExtendedAttributeType visibility2;
            if (this.getEObjectModel() instanceof TypeDeclarationType && (visibility2 = ExtendedAttributeUtil.getAttribute((ExtendedAttributesType)(declaration = (TypeDeclarationType)this.getEObjectModel()).getExtendedAttributes(), (String)"carnot:engine:visibility")) != null) {
                visibilityString = visibility2.getValue();
            }
            if ((this.getEObjectModel() instanceof ApplicationType || this.getEObjectModel() instanceof DataType || this.getEObjectModel() instanceof IModelParticipant) && (visibility = AttributeUtil.getAttribute((IExtensibleElement)((IExtensibleElement)this.getEObjectModel()), (String)"carnot:engine:visibility")) != null) {
                visibilityString = visibility.getValue();
            }
            if (visibilityString == null || visibilityString == "" || visibilityString.equalsIgnoreCase("Public")) {
                return image;
            }
            IconWithOverlays iwo = new IconWithOverlays(image, IconWithOverlays.OVR_PRIVATE);
            iwo.defaultPosition = 0;
            image = iwo.createImage();
        }
        return image;
    }

    public List getCurrentModelChildren() {
        return this.getModelChildren();
    }

    protected List getModelChildren() {
        if (this.childrenFeatures != null) {
            List children = CollectionUtils.newList();
            int i = 0;
            while (i < this.childrenFeatures.length) {
                EStructuralFeature feature = this.childrenFeatures[i];
                Object value = this.getEObjectModel().eGet(feature);
                if (value instanceof List) {
                    List items = CollectionUtils.newList((Collection)((List)value));
                    Collections.sort(items, ModelUtils.IDENTIFIABLE_COMPARATOR);
                    for (Object o : items) {
                        this.addChild(children, o);
                    }
                } else {
                    this.addChild(children, value);
                }
                ++i;
            }
            return children;
        }
        return super.getModelChildren();
    }

    private void addChild(List<Object> children, Object o) {
        if (this.accept(o)) {
            children.add(o);
        }
    }

    protected boolean accept(Object o) {
        return true;
    }

    @Override
    public void handleNotification(Notification n) {
        if (n.getPosition() == -1 && n.getEventType() != 5 && n.getEventType() != 6) {
            this.refreshVisuals();
            if ((PKG_CWM.getIIdentifiableElement_Id().equals(n.getFeature()) || PKG_CWM.getIIdentifiableElement_Name().equals(n.getFeature())) && this.getParent() != null) {
                this.getParent().refresh();
            }
        } else {
            this.refreshChildren();
        }
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            EObject model = this.getEObjectModel();
            if (model != null) {
                model.eAdapters().add((Object)this.getNotificationAdapter());
            }
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            EObject model = this.getEObjectModel();
            if (model != null) {
                try {
                    model.eAdapters().remove((Object)this.getNotificationAdapter());
                }
                catch (Exception exception) {}
            }
            super.deactivate();
        }
    }

    public Object getAdapter(Class key) {
        Object adapter;
        if (EditPart.class == key) {
            adapter = this;
        } else if (IPropertySource.class == key) {
            adapter = this.getPropertySource();
        } else {
            if (EObject.class.equals((Object)key) && this.getModel() instanceof EObject) {
                return this.getModel();
            }
            adapter = super.getAdapter(key);
        }
        return adapter;
    }

    protected EditPart getEditPartForChild(Object child) {
        return (EditPart)this.getViewer().getEditPartRegistry().get(child);
    }

    protected NotificationAdapter getNotificationAdapter() {
        if (this.notificationAdapter == null) {
            this.notificationAdapter = new NotificationAdapter(this);
        }
        return this.notificationAdapter;
    }

    protected IPropertySource getPropertySource() {
        if (this.propertySource == null) {
            this.propertySource = this.createPropertySource();
        }
        return this.propertySource;
    }

    protected IPropertySource createPropertySource() {
        return PropertySourceFactory.getPropertySource((EditPart)this, this.getEObjectModel());
    }

    public EStructuralFeature[] getChildrenFeatures() {
        return this.childrenFeatures;
    }

    public void setChildrenFeatures(EStructuralFeature[] childrenFeatures) {
        this.childrenFeatures = childrenFeatures;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new TreeElementComponentEditPolicy());
    }

    public WorkflowModelEditor getEditor() {
        return this.editor;
    }

    public String getLabel() {
        return super.getText();
    }

    public final String getText() {
        StateCache stateCache;
        CollisionInfo stateInfo;
        String label = this.getLabel();
        ModelType model = ModelUtils.findContainingModel((EObject)this.eObjectModel);
        WorkflowModelEditor editor = GenericUtils.getWorkflowModelEditor(model);
        if (editor != null && ShareUtils.isLockableElement((Object)this.eObjectModel) && ShareUtils.isModelShared((ModelType)model) && (stateInfo = (stateCache = editor.getModelServer().getStateCache()).getState(this.eObjectModel)).getState() == CollisionState.LOCKED_BY_OTHER) {
            String owner = stateInfo.getOwner();
            if (owner == null) {
                return MessageFormat.format(Diagram_Messages.LBL_LOCKED, label);
            }
            return MessageFormat.format(Diagram_Messages.LBL_NULL_LOCKED_BY_ONE, label, owner);
        }
        return label == null ? "" : label;
    }

    public void refreshTextAndIcon() {
        super.refreshVisuals();
    }
}

