/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.tree;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.editpolicies.RootComponentEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.spi.SpiExtensionRegistry;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackages;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.ValidationIssueManager;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelOutlinePage;
import org.eclipse.stardust.modeling.core.editors.parts.tree.AbstractEObjectTreeEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.tree.ChildCategoryNode;
import org.eclipse.stardust.modeling.core.editors.parts.tree.OutlineTreeEditor;
import org.eclipse.stardust.modeling.core.modelserver.ModelServerUtils;
import org.eclipse.stardust.modeling.repository.common.ObjectRepositoryActivator;
import org.eclipse.stardust.modeling.repository.common.RepositoryPackage;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PartInitException;

public class ModelTreeEditPart
extends AbstractEObjectTreeEditPart {
    private static final CarnotWorkflowModelPackage PKG_CWM = CarnotWorkflowModelPackage.eINSTANCE;
    private ChildCategoryNode.Spec catApplications;
    private ChildCategoryNode.Spec catData;
    private ChildCategoryNode.Spec catParticipants;
    private ChildCategoryNode.Spec catConnections;

    protected ModelTreeEditPart(WorkflowModelEditor editor, ModelType model, String iconPath) {
        super(editor, (EObject)model, iconPath, new EStructuralFeature[]{CarnotWorkflowModelPackage.eINSTANCE.getModelType_ProcessDefinition(), CarnotWorkflowModelPackage.eINSTANCE.getModelType_Diagram(), CarnotWorkflowModelPackage.eINSTANCE.getModelType_LinkType()});
        IIdentifiableModelElement parent = ModelUtils.getIdentifiableModelProxy((EObject)model, ModelType.class);
        ValidationIssueManager manager = this.getEditor().getIssueManager();
        this.catApplications = new ChildCategoryNode.Spec((EObject)parent, Diagram_Messages.LB_Applications, editor.getIconFactory().getIconFor((EObject)PKG_CWM.getApplicationType()), new EStructuralFeature[]{PKG_CWM.getModelType_Application()});
        this.catData = new ChildCategoryNode.Spec((EObject)parent, Diagram_Messages.DATA_LABEL, editor.getIconFactory().getIconFor((EObject)PKG_CWM.getDataType()), new EStructuralFeature[]{PKG_CWM.getModelType_Data()});
        this.catParticipants = new ChildCategoryNode.Spec((EObject)parent, Diagram_Messages.LB_Participants, editor.getIconFactory().getIconFor((EObject)PKG_CWM.getIModelParticipant()), new EStructuralFeature[]{PKG_CWM.getModelType_Organization(), PKG_CWM.getModelType_Role(), PKG_CWM.getModelType_ConditionalPerformer(), PKG_CWM.getModelType_Modeler()});
        manager.addValidationEventListener(this.catApplications);
        manager.addValidationEventListener(this.catData);
        manager.addValidationEventListener(this.catParticipants);
        if (this.hasConnectionExtensions()) {
            this.catConnections = new ChildCategoryNode.Spec((EObject)editor.getConnectionManager().getRepository(), Diagram_Messages.CONNECTION_LABEL, ObjectRepositoryActivator.getIcon(), new EStructuralFeature[]{RepositoryPackage.eINSTANCE.getRepository_Connection()});
            manager.addValidationEventListener(this.catConnections);
        }
    }

    private boolean hasConnectionExtensions() {
        Map map = SpiExtensionRegistry.instance().getExtensions("org.eclipse.stardust.modeling.repository.common", "connections");
        return map != null && !map.isEmpty();
    }

    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new RootComponentEditPolicy());
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new DirectEditPolicy(){

            protected Command getDirectEditCommand(DirectEditRequest request) {
                return null;
            }

            protected void showCurrentEditValue(DirectEditRequest request) {
            }
        });
    }

    public void performRequest(Request req) {
        if (req.getType() == "direct edit") {
            Boolean lockedByCurrentUser = ModelServerUtils.isLockedByCurrentUser((EObject)this.getModel());
            if (lockedByCurrentUser == null || lockedByCurrentUser.equals(Boolean.TRUE)) {
                WorkflowModelOutlinePage outline = (WorkflowModelOutlinePage)this.getEditor().getOutlinePage();
                TreeItem treeItem = (TreeItem)this.getWidget();
                OutlineTreeEditor editor = outline.getOutlineTreeEditor();
                editor.setItem(treeItem, this.getModel());
                return;
            }
            ModelServerUtils.showMessageBox(Diagram_Messages.MSG_LOCK_NEEDED);
            return;
        }
        super.performRequest(req);
    }

    @Override
    public String getLabel() {
        return ((ModelType)this.getModel()).getName();
    }

    @Override
    protected List<?> getModelChildren() {
        ExternalPackages externalPackages;
        ArrayList<ChildCategoryNode.Spec> result = new ArrayList<ChildCategoryNode.Spec>();
        if (this.hasConnectionExtensions()) {
            result.add(this.catConnections);
        }
        if ((externalPackages = ((ModelType)this.getModel()).getExternalPackages()) != null && !externalPackages.getExternalPackage().isEmpty()) {
            result.add((ChildCategoryNode.Spec)externalPackages);
        }
        result.add((ChildCategoryNode.Spec)((ModelType)this.getModel()).getTypeDeclarations());
        result.add(this.catApplications);
        result.add(this.catData);
        result.add(this.catParticipants);
        List modelChildren = super.getModelChildren();
        result.addAll(modelChildren);
        return result;
    }

    @Override
    public Object getAdapter(Class key) {
        if (key.equals(IModelElement.class)) {
            return ModelUtils.getIdentifiableModelProxy((EObject)((ModelType)this.getModel()), ModelType.class);
        }
        return super.getAdapter(key);
    }

    @Override
    public void handleNotification(Notification n) {
        super.handleNotification(n);
        if (n != null && PKG_CWM.getModelType_ProcessDefinition().equals(n.getFeature())) {
            if (n.getEventType() == 1) {
                ProcessDefinitionType process = (ProcessDefinitionType)n.getOldValue();
                EList diagrams = process.getDiagram();
                for (DiagramType diagramType : diagrams) {
                    this.getEditor().closeDiagramPage(diagramType);
                }
            }
        } else if (n != null && PKG_CWM.getModelType_Diagram().equals(n.getFeature()) && n.getEventType() == 1) {
            DiagramType diagram = (DiagramType)n.getOldValue();
            DiagramType activeDiagram = this.getEditor().getActiveDiagram();
            this.getEditor().closeDiagramPage(diagram);
            if (activeDiagram != null && activeDiagram.equals(diagram)) {
                try {
                    this.getEditor().showDiagramPage((DiagramType)n.getNewValue());
                }
                catch (PartInitException partInitException) {}
            }
        }
    }
}

