/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.modelserver;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.merge.ShareUtils;
import org.eclipse.stardust.model.xpdl.carnot.merge.UUIDUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.WorkflowModelManager;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.cap.CopyPasteUtil;
import org.eclipse.stardust.modeling.core.modelserver.LockFileUtils;
import org.eclipse.stardust.modeling.core.modelserver.ModelServer;
import org.eclipse.stardust.modeling.core.modelserver.ModelServerUtils;
import org.eclipse.stardust.modeling.core.modelserver.RMSException;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;

public class LockUtil {
    private static Map<WorkflowModelEditor, LockUtil> instances;
    private WorkflowModelEditor editor;
    private ModelType localModel;
    private ModelType remoteModelHead;
    private Map<String, EObject> localMap;
    private Map<String, EObject> remoteMapHead;
    private List<EObject> newElements = new ArrayList<EObject>();
    private List<EObject> removedElements = new ArrayList<EObject>();
    private List<EObject> changedElements = new ArrayList<EObject>();
    private List<EObject> allElements = new ArrayList<EObject>();
    private WorkflowModelManager manager;
    private long localModelTimeStamp = 0L;

    public static LockUtil getLockUtil(WorkflowModelEditor editor) {
        LockUtil instance = null;
        if (instances == null) {
            instances = new HashMap<WorkflowModelEditor, LockUtil>();
        }
        if ((instance = instances.get(editor)) == null) {
            instance = new LockUtil(editor);
            instances.put(editor, instance);
        }
        return instance;
    }

    private LockUtil(WorkflowModelEditor editor) {
        this.editor = editor;
    }

    public void analyze(IProgressMonitor monitor) throws RMSException {
        monitor.subTask(Diagram_Messages.TASK_READING_LOCAL_MD);
        ModelServer modelServer = this.editor.getModelServer();
        ModelType model = modelServer.getModel();
        Resource resource = model.eResource();
        this.getLocalModel(resource);
        monitor.subTask(Diagram_Messages.TASK_READING_REMOTE_MD);
        try {
            this.remoteModelHead = modelServer.getRemoteModel(true);
        }
        catch (IOException iOException) {
            throw new RMSException("...", 1);
        }
        if (this.remoteModelHead == null) {
            throw new RMSException(Diagram_Messages.EXC_JOB_FAILED, 0);
        }
        monitor.subTask(Diagram_Messages.TASK_ANALYZING_DIFFERENCES);
        this.localMap = ModelServerUtils.createUuidToElementMap(this.localModel);
        this.remoteMapHead = ModelServerUtils.createUuidToElementMap(this.remoteModelHead);
        HashMap<String, EObject> remoteMapClone = new HashMap<String, EObject>(this.remoteMapHead);
        remoteMapClone.keySet().removeAll(this.localMap.keySet());
        ArrayList tempRemovedElements = new ArrayList(remoteMapClone.values());
        for (EObject element : tempRemovedElements) {
            if (!LockFileUtils.hasLockFile(element, modelServer.getModel())) continue;
            this.removedElements.add(element);
        }
        this.newElements = ModelServerUtils.getElementsWithoutUuid(this.localModel);
        if (!this.removedElements.isEmpty()) {
            this.allElements.addAll(this.removedElements);
            this.localMap.values().removeAll(this.removedElements);
        }
        if (!this.newElements.isEmpty()) {
            this.allElements.addAll(this.newElements);
            this.localMap.values().removeAll(this.newElements);
        }
        for (Map.Entry<String, EObject> entry : this.localMap.entrySet()) {
            boolean changed;
            EObject element = entry.getValue();
            if (!ShareUtils.isLockableElement((Object)element) || !LockFileUtils.hasLockFile(element, modelServer.getModel()) || !(changed = ModelServerUtils.isChanged(element, ModelServerUtils.findByUUID(this.remoteModelHead, UUIDUtils.getUUID((EObject)element))))) continue;
            this.changedElements.add(element);
        }
    }

    private void getLocalModel(Resource resource) throws RMSException {
        URI uri = resource.getURI();
        int segmentCount = uri.segmentCount();
        String fileName = "platform:";
        int i = 1;
        while (i < segmentCount) {
            fileName = String.valueOf(fileName) + "/" + uri.segment(i);
            ++i;
        }
        java.net.URI uri_ = java.net.URI.create(fileName);
        File file = new File(uri_.getPath());
        if (!file.isAbsolute()) {
            file = new File(Platform.getLocation().toFile(), file.toString());
        }
        if (file.exists() && this.localModelTimeStamp != 0L) {
            if (file.lastModified() > this.localModelTimeStamp) {
                this.manager = null;
            }
        } else {
            this.manager = null;
        }
        if (this.manager == null) {
            if (file.exists()) {
                this.localModelTimeStamp = file.lastModified();
            }
            this.manager = new WorkflowModelManager();
            try {
                this.manager.load(resource.getURI());
            }
            catch (IOException iOException) {
                throw new RMSException("...", 0);
            }
            this.localModel = this.manager.getModel();
        }
    }

    public static String getMessageLockedAlready(Map<EObject, String> failed) {
        String message = "The following model elements could not be locked:\n";
        for (Map.Entry<EObject, String> entry : failed.entrySet()) {
            EObject element = entry.getKey();
            String user = entry.getValue();
            message = String.valueOf(message) + GenericUtils.getElementId(element) + " (locked by " + user + ")\n";
        }
        return message;
    }

    public String checkUpdateNeeded(List<EObject> elements) {
        String updateElements = "";
        for (EObject element : elements) {
            EObject sameElement = CopyPasteUtil.getSameElement(element, (EObject)this.localModel);
            if (sameElement == null || !this.hasChanged(sameElement)) continue;
            updateElements = String.valueOf(updateElements) + GenericUtils.getElementId(element) + "\n";
        }
        return updateElements;
    }

    public boolean hasChanged(EObject element) {
        return this.changedElements.contains(element);
    }
}

