/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.modelserver;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.merge.ShareUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.modelserver.LockFileUtils;
import org.eclipse.stardust.modeling.core.modelserver.ModelHistoryEntry;
import org.eclipse.stardust.modeling.core.modelserver.ModelServerUtils;
import org.eclipse.stardust.modeling.core.modelserver.RMSException;
import org.eclipse.stardust.modeling.core.modelserver.Vcs;
import org.eclipse.stardust.modeling.core.modelserver.VcsStatus;
import org.eclipse.stardust.modeling.core.modelserver.jobs.JobUtils;
import org.eclipse.stardust.modeling.core.modelserver.jobs.StateCache;
import org.eclipse.stardust.modeling.repository.common.ExtendedModelManager;

public class ModelServerHelper {
    protected EObject cachedModelElement;
    protected StateCache stateCache;
    protected int modelHistoryEntries = 0;
    protected int statusFileValue = 0;
    protected boolean shareJob = false;
    protected Boolean createLockFilesFinished = Boolean.FALSE;
    protected boolean enableRefreshStatusJob = true;
    protected Long lastRefresh = null;
    protected JobUtils jobUtils = null;
    protected ModelType model;
    protected ModelType remoteModel;
    protected IProject project;
    protected IFolder modelLockFolder;
    protected IFolder modelCacheFolder;
    protected long retryConnection;
    protected boolean retry = true;
    protected long lastRequest = 0L;
    private long remoteModelTimeStamp = 0L;

    public void setCachedModelElement(EObject cachedModelElement) {
        this.cachedModelElement = cachedModelElement;
    }

    public ModelType getModel() {
        return this.model;
    }

    public JobUtils getJobUtils() {
        return this.jobUtils;
    }

    public boolean isEnableRefreshStatusJob() {
        return this.enableRefreshStatusJob;
    }

    public String getModelName() {
        return " (" + this.model.getName() + ")";
    }

    private ModelType getRemoteModel() throws RMSException, IOException {
        IFile modelFile = ModelServerUtils.getModelFile(this.model);
        Vcs vcs = ModelServerUtils.getVcs(this.getProject());
        InputStream in = vcs.getHeadRevision(modelFile);
        if (in != null) {
            ExtendedModelManager emm = new ExtendedModelManager();
            emm.load(URI.createURI((String)("vcs:/resource/" + modelFile.getName())), in);
            return emm.getModel();
        }
        return null;
    }

    public ModelType getRemoteModel(boolean useCache) throws RMSException, IOException {
        Vcs vcs;
        if (!useCache) {
            return this.getRemoteModel();
        }
        IFile modelFile = ModelServerUtils.getModelFile(this.model);
        IFile file = this.getCacheFile(modelFile, vcs = ModelServerUtils.getVcs(this.getProject()));
        if (!file.exists()) {
            this.cleanCache();
            InputStream in = vcs.getHeadRevision(modelFile);
            if (in != null) {
                return this.createRemoteModel(modelFile, file, in);
            }
        } else {
            return this.getCachedModel(file);
        }
        return null;
    }

    private void cleanCache() {
        IFolder modelCacheFolder = this.getModelCacheFolder();
        try {
            IResource[] members = modelCacheFolder.members();
            if (members != null) {
                int i = 0;
                while (i < members.length) {
                    if (members[i] instanceof IFile && members[i].exists()) {
                        ((IFile)members[i]).delete(true, null);
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
        this.remoteModel = null;
    }

    protected IFile getCacheFile(IFile modelFile, Vcs vcs) {
        VcsStatus status = vcs.getStatus((IResource)modelFile);
        Long headRevision = status.getHeadRevision();
        IFolder folder = this.getModelCacheFolder();
        String fileName = String.valueOf(headRevision.toString()) + "_" + modelFile.getName();
        IFile file = folder.getFile(fileName);
        return file;
    }

    private synchronized ModelType getCachedModel(IFile cacheFile) throws IOException {
        String fileName = "platform:" + cacheFile.getFullPath().toString();
        java.net.URI uri_ = java.net.URI.create(fileName);
        File file = new File(uri_.getPath());
        if (!file.isAbsolute()) {
            file = new File(Platform.getLocation().toFile(), file.toString());
        }
        if (file.exists() && this.remoteModelTimeStamp != 0L && file.lastModified() == this.remoteModelTimeStamp && this.remoteModel != null) {
            return this.remoteModel;
        }
        if (file.exists()) {
            this.remoteModelTimeStamp = file.lastModified();
        }
        ExtendedModelManager emm = new ExtendedModelManager();
        emm.load(URI.createPlatformResourceURI((String)cacheFile.getFullPath().toString(), (boolean)false));
        this.remoteModel = emm.getModel();
        return this.remoteModel;
    }

    private synchronized ModelType createRemoteModel(IFile modelFile, IFile cacheFile, InputStream in) throws IOException {
        ExtendedModelManager emm = new ExtendedModelManager();
        emm.load(URI.createPlatformResourceURI((String)cacheFile.getFullPath().toString(), (boolean)false), in);
        emm.save(URI.createPlatformResourceURI((String)cacheFile.getFullPath().toString(), (boolean)false));
        this.remoteModel = emm.getModel();
        return this.remoteModel;
    }

    public boolean isLockedAll() {
        return this.stateCache.isLockedAll();
    }

    public boolean shareJob() {
        return this.shareJob;
    }

    public void cleanShareJob() {
        this.shareJob = false;
    }

    public Long getLastRefresh() {
        return this.lastRefresh;
    }

    public void setLastRefresh(Long value) {
        this.lastRefresh = value;
    }

    public Boolean isCreateLockFilesFinished() {
        return this.createLockFilesFinished;
    }

    public void setCreateLockFilesFinished(Boolean finished) {
        this.createLockFilesFinished = finished;
    }

    public void setRetryConnection(long retryConnection) {
        this.retryConnection = retryConnection;
    }

    public void setRetry(boolean retry) {
        this.retry = retry;
        if (retry) {
            this.lastRequest = this.retryConnection;
        }
    }

    public IProject getProject() {
        if (this.project == null) {
            this.project = ShareUtils.getProject((Resource)this.model.eResource());
        }
        return this.project;
    }

    public IFolder getModelCacheFolder() {
        if (this.modelCacheFolder == null) {
            IFolder folder = this.getModelLockFolder();
            IFolder cache = folder.getFolder("CACHE");
            if (!cache.exists()) {
                try {
                    cache.create(true, true, null);
                    this.modelCacheFolder = cache;
                }
                catch (CoreException coreException) {}
            } else {
                this.modelCacheFolder = cache;
            }
        }
        return this.modelCacheFolder;
    }

    public IFolder getModelLockFolder() {
        if (this.modelLockFolder == null) {
            this.modelLockFolder = ShareUtils.getLockFolder((ModelType)this.model);
        }
        return this.modelLockFolder;
    }

    public boolean isProjectShared() {
        try {
            return ModelServerUtils.getVcs2(this.getProject()) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected synchronized boolean isShared(IFile lockFile) {
        try {
            Vcs vcs = ModelServerUtils.getVcs(this.getProject());
            return vcs.isShared((IResource)lockFile, false);
        }
        catch (RMSException e) {
            if (e.getType() == 1) {
                ModelServerUtils.showMessageBox(e.getMessage());
            }
            return false;
        }
    }

    public boolean isLockedByOther(EObject eObject) {
        VcsStatus lockInfo = this.getLockInfo(eObject);
        return lockInfo.isLocked() && !lockInfo.isLockedByCurrentUser();
    }

    public boolean isLockableElement(IAdaptable adaptable) {
        return ShareUtils.isLockableElement((Object)ModelUtils.getEObject((IAdaptable)adaptable));
    }

    public synchronized VcsStatus getLockInfo(EObject eObject) {
        IFile file = LockFileUtils.getLockFile(eObject);
        if (file == null || !file.exists()) {
            return new VcsStatus(2, false, null, null, null, null);
        }
        String data = LockFileUtils.readLockFile(file);
        if (data == null) {
            return new VcsStatus(2, false, null, null, null, null);
        }
        int status = 0;
        try {
            status = Integer.parseInt(data);
        }
        catch (NumberFormatException numberFormatException) {
            status = data.equals(ModelServerUtils.getUser(file)) ? 1 : 2;
        }
        boolean isLockedByCurrentUser = false;
        String remoteLockOwner = null;
        if (status == 1) {
            isLockedByCurrentUser = true;
        } else if (status == 2) {
            remoteLockOwner = data;
            try {
                VcsStatus vcsStatus = ModelServerUtils.getVcs(this.getProject()).getStatus((IResource)file);
                remoteLockOwner = vcsStatus.getLastCommitAuthor();
            }
            catch (Exception exception) {
                return new VcsStatus(2, false, null, null, null, null);
            }
        }
        return new VcsStatus(1, isLockedByCurrentUser, remoteLockOwner, null, null, null);
    }

    public List<ModelHistoryEntry> getModelHistory(ModelType model, IProgressMonitor monitor) throws RMSException {
        List<ModelHistoryEntry> folderEntries = ModelServerUtils.getVcs(this.getProject()).getHistory((IResource)this.getModelLockFolder(), monitor);
        IFile modelFile = ModelServerUtils.getModelFile(model);
        List<ModelHistoryEntry> modelEntries = ModelServerUtils.getVcs(this.getProject()).getHistory((IResource)modelFile, monitor);
        ArrayList<ModelHistoryEntry> mergedEntries = new ArrayList<ModelHistoryEntry>();
        mergedEntries.addAll(folderEntries);
        for (ModelHistoryEntry modelEntry : modelEntries) {
            boolean found = false;
            for (ModelHistoryEntry folderEntry : folderEntries) {
                if (!folderEntry.getRevision().equals(modelEntry.getRevision()) || !folderEntry.getTimestamp().equals(modelEntry.getTimestamp()) || !folderEntry.getComment().equals(modelEntry.getComment())) continue;
                found = true;
                break;
            }
            if (found) continue;
            mergedEntries.add(modelEntry);
        }
        return mergedEntries;
    }
}

