/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.modelserver;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.CompareHelper;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IdentifiableReference;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.merge.MergeUtils;
import org.eclipse.stardust.model.xpdl.carnot.merge.ShareUtils;
import org.eclipse.stardust.model.xpdl.carnot.merge.UUIDUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackages;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationsType;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlPackage;
import org.eclipse.stardust.modeling.common.ui.jface.IconWithOverlays;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.createUtils.CreationUtils;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.cap.CopyPasteUtil;
import org.eclipse.stardust.modeling.core.editors.parts.tree.AbstractEObjectTreeEditPart;
import org.eclipse.stardust.modeling.core.modelserver.ElementReference;
import org.eclipse.stardust.modeling.core.modelserver.IMergeUtils;
import org.eclipse.stardust.modeling.core.modelserver.LockFileUtils;
import org.eclipse.stardust.modeling.core.modelserver.ModelCopier;
import org.eclipse.stardust.modeling.core.modelserver.RMSException;
import org.eclipse.stardust.modeling.core.modelserver.Vcs;
import org.eclipse.stardust.modeling.core.modelserver.jobs.CollisionState;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.xsd.XSDPackage;
import org.w3c.dom.Node;

public class ModelServerUtils {
    public static int LOCKED_BY_USER = 1;
    public static int LOCKED_BY_OTHER = 2;
    public static int REMOVED = 3;
    public static Image imageAdded = DiagramPlugin.getDefault().getImageManager().getImage("icons/full/obj16/added_ov.gif");
    public static Image imageEdited = DiagramPlugin.getDefault().getImageManager().getImage("icons/full/obj16/edited_ov.gif");
    public static Image imageDeleted = DiagramPlugin.getDefault().getImageManager().getImage("icons/full/obj16/deleted_ov.gif");
    public static Image imageLocked = DiagramPlugin.getDefault().getImageManager().getImage("icons/full/obj16/locked_ov.gif");
    public static Image imageProtected = DiagramPlugin.getDefault().getImageManager().getImage("icons/full/obj16/protected_ov.gif");
    public static Image imageVCS = DiagramPlugin.getDefault().getImageManager().getImage("icons/full/obj16/version_controlled.gif");
    private static final CarnotWorkflowModelPackage PKG_CWM = CarnotWorkflowModelPackage.eINSTANCE;
    private static final Map<IProject, Vcs> vcsCache = new HashMap<IProject, Vcs>();
    private static final Set<String> unsupportedProviderIds = new HashSet<String>();
    private static Map<Integer, Map<Image, Map<Image, Image>>> imageCache = new HashMap<Integer, Map<Image, Map<Image, Image>>>();

    public static void showMessageBox(String message) {
        ModelServerUtils.showMessageBox(message, Diagram_Messages.MSG_BOX_RMS_OPERATION);
    }

    public static void showMessageBox(String message, String title) {
        if (Display.getDefault().getActiveShell() != null) {
            MessageBox messageBox = new MessageBox(Display.getDefault().getActiveShell(), 40);
            messageBox.setText(title);
            messageBox.setMessage(message);
            messageBox.open();
        }
    }

    public static String getUser(IFile file) {
        return String.valueOf(System.getProperty("user.name")) + file.getLocation().toOSString();
    }

    public static String convertCommitString(String input) {
        ByteArrayInputStream is = new ByteArrayInputStream(input.getBytes());
        String data = new String();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is, "ISO-8859-1"));
            String line = null;
            while ((line = reader.readLine()) != null) {
                data = String.valueOf(data) + line + " ";
            }
            reader.close();
        }
        catch (Exception exception) {}
        return data;
    }

    public static Boolean isLockedByCurrentUser(EObject modelElement) {
        WorkflowModelEditor editor;
        if (modelElement instanceof IModelElementNodeSymbol) {
            modelElement = ((IModelElementNodeSymbol)modelElement).getModelElement();
        }
        if (modelElement == null) {
            return null;
        }
        ProcessDefinitionType process = ModelUtils.findContainingProcess((EObject)modelElement);
        if (process != null) {
            modelElement = process;
        }
        if ((editor = GenericUtils.getWorkflowModelEditor(ModelUtils.findContainingModel((EObject)modelElement))) != null && editor.getModelServer().isModelShared() && LockFileUtils.getLockFile(modelElement) != null && LockFileUtils.getLockFile(modelElement).exists()) {
            if (editor.getModelServer().getStateCache().getState(modelElement).getState() == CollisionState.LOCKED_BY_USER) {
                return true;
            }
            return false;
        }
        return null;
    }

    public static EObject getLockableElementFromSelection(Object selection) {
        AbstractEObjectTreeEditPart treeEditPart;
        Object modelElement;
        if (selection instanceof AbstractEObjectTreeEditPart && ShareUtils.isLockableElement((Object)(modelElement = (treeEditPart = (AbstractEObjectTreeEditPart)selection).getModel()))) {
            return (EObject)modelElement;
        }
        return null;
    }

    public static Vcs getVcs(IProject project) throws RMSException {
        Vcs vcs = ModelServerUtils.getVcs2(project);
        if (vcs == null) {
            throw new RMSException(Diagram_Messages.EXC_PROJECT_IS_NOT_SHARED, 0);
        }
        return vcs;
    }

    public static Vcs getVcs2(IProject project) {
        if (RepositoryProvider.isShared((IProject)project)) {
            Vcs vcs = vcsCache.get(project);
            if (vcs != null) {
                return vcs;
            }
            RepositoryProvider repositoryProvider = RepositoryProvider.getProvider((IProject)project);
            String providerId = repositoryProvider.getID();
            if (unsupportedProviderIds.contains(providerId)) {
                throw new RuntimeException(MessageFormat.format(Diagram_Messages.EXC_UNSUPPORTED_REPOSITORY_PROVIDER_NO_EXTENSION_FOUND_FOR, repositoryProvider.getClass().getName()));
            }
            if (Platform.getExtensionRegistry() != null) {
                IConfigurationElement[] extensions = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.stardust.modeling.core.vcsConnector");
                int j = 0;
                while (j < extensions.length) {
                    if (extensions[j].getAttribute("repositoryProviderId").equals(providerId)) {
                        try {
                            vcs = (Vcs)extensions[j].createExecutableExtension("vcsConnectorClass");
                            vcs.setRepositoryProvider(repositoryProvider);
                            vcsCache.put(project, vcs);
                            return vcs;
                        }
                        catch (Exception e) {
                            unsupportedProviderIds.add(providerId);
                            throw new RuntimeException(String.valueOf(Diagram_Messages.EXC_ERROR_INITIALIZING_REPOSITORY_PROVIDER_FOR) + repositoryProvider.getClass().getName(), e);
                        }
                    }
                    ++j;
                }
            }
            unsupportedProviderIds.add(providerId);
            throw new RuntimeException(String.valueOf(Diagram_Messages.EXC_UNSUPPORTED_REPOSITORY_PROVIDER_NO_EXTENSION_FOUND_FOR) + repositoryProvider.getClass().getName());
        }
        vcsCache.remove(project);
        return null;
    }

    public static IFolder createLockFiles(IProject project, ModelType model) {
        try {
            IFolder lockFolder;
            if (UUIDUtils.getUUID((EObject)model) == null) {
                UUIDUtils.setUUID((EObject)model);
            }
            if ((lockFolder = ShareUtils.getLockFolder((ModelType)model)) == null) {
                throw new RuntimeException(Diagram_Messages.EXC_UNABLE_TO_FIND_LOCK_FOLDER);
            }
            if (!lockFolder.exists()) {
                lockFolder.create(true, true, null);
            }
            ModelServerUtils.createLockFileIfNotExists(lockFolder, (EObject)model, 0);
            IFolder subFolder = LockFileUtils.getLockFolder(XpdlPackage.eINSTANCE.getTypeDeclarationType(), lockFolder);
            if (!subFolder.exists()) {
                subFolder.create(true, true, null);
            }
            ModelServerUtils.createLockFileIfNotExists(lockFolder, (List<? extends EObject>)model.getTypeDeclarations().getTypeDeclaration());
            subFolder = LockFileUtils.getLockFolder(PKG_CWM.getApplicationType(), lockFolder);
            if (!subFolder.exists()) {
                subFolder.create(true, true, null);
            }
            ModelServerUtils.createLockFileIfNotExists(lockFolder, (List<? extends EObject>)model.getApplication());
            subFolder = LockFileUtils.getLockFolder(PKG_CWM.getDataType(), lockFolder);
            if (!subFolder.exists()) {
                subFolder.create(true, true, null);
            }
            ModelServerUtils.createLockFileIfNotExists(lockFolder, (List<? extends EObject>)model.getData());
            subFolder = LockFileUtils.getLockFolder(PKG_CWM.getRoleType(), lockFolder);
            if (!subFolder.exists()) {
                subFolder.create(true, true, null);
            }
            ModelServerUtils.createLockFileIfNotExists(lockFolder, (List<? extends EObject>)model.getRole());
            subFolder = LockFileUtils.getLockFolder(PKG_CWM.getConditionalPerformerType(), lockFolder);
            if (!subFolder.exists()) {
                subFolder.create(true, true, null);
            }
            ModelServerUtils.createLockFileIfNotExists(lockFolder, (List<? extends EObject>)model.getConditionalPerformer());
            subFolder = LockFileUtils.getLockFolder(PKG_CWM.getOrganizationType(), lockFolder);
            if (!subFolder.exists()) {
                subFolder.create(true, true, null);
            }
            ModelServerUtils.createLockFileIfNotExists(lockFolder, (List<? extends EObject>)model.getOrganization());
            subFolder = LockFileUtils.getLockFolder(PKG_CWM.getProcessDefinitionType(), lockFolder);
            if (!subFolder.exists()) {
                subFolder.create(true, true, null);
            }
            ModelServerUtils.createLockFileIfNotExists(lockFolder, (List<? extends EObject>)model.getProcessDefinition());
            subFolder = LockFileUtils.getLockFolder(PKG_CWM.getDiagramType(), lockFolder);
            if (!subFolder.exists()) {
                subFolder.create(true, true, null);
            }
            ModelServerUtils.createLockFileIfNotExists(lockFolder, (List<? extends EObject>)model.getDiagram());
            subFolder = LockFileUtils.getLockFolder(PKG_CWM.getLinkTypeType(), lockFolder);
            if (!subFolder.exists()) {
                subFolder.create(true, true, null);
            }
            ModelServerUtils.createLockFileIfNotExists(lockFolder, (List<? extends EObject>)model.getLinkType());
            WorkflowModelEditor editor = GenericUtils.getWorkflowModelEditor(model);
            editor.doSave((IProgressMonitor)new NullProgressMonitor());
            editor.getEditDomain().getCommandStack().flush();
            return lockFolder;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private static void createLockFileIfNotExists(IFolder modelLockFolder, List<? extends EObject> domain) throws Exception {
        int i = 0;
        while (i < domain.size()) {
            EObject me = domain.get(i);
            ModelServerUtils.createLockFileIfNotExists(modelLockFolder, me, 0);
            ++i;
        }
    }

    public static IFile getModelFile(ModelType model) {
        Resource eResource = model.eResource();
        if (eResource != null) {
            URI eUri = eResource.getURI();
            return ResourcesPlugin.getWorkspace().getRoot().getFile(Path.fromPortableString((String)eUri.toPlatformString(true)));
        }
        return null;
    }

    public static IFile createLockFileIfNotExists(IFolder lockFolder, EObject element, int value) throws CoreException, IOException {
        String fileName;
        IFile file;
        if (element instanceof DataType && ((DataType)element).isPredefined()) {
            return null;
        }
        String uuid = UUIDUtils.getUUID((EObject)element);
        if (uuid == null && (uuid = UUIDUtils.setUUID((EObject)element)) == null) {
            return null;
        }
        IFolder elementLockFolder = LockFileUtils.getLockFolder(element.eClass(), lockFolder);
        if (!elementLockFolder.exists()) {
            elementLockFolder.create(true, true, null);
        }
        if (!(file = elementLockFolder.getFile(fileName = LockFileUtils.getFileName(element, uuid))).exists()) {
            file.create((InputStream)new ByteArrayInputStream(Integer.toString(value).getBytes("ISO-8859-1")), true, null);
        }
        return file;
    }

    public static Map<String, EObject> createUuidToElementMap(ModelType model) {
        HashMap<String, EObject> map = new HashMap<String, EObject>();
        String uuid = UUIDUtils.getUUID((EObject)model);
        map.put(uuid, (EObject)model);
        ModelServerUtils.addToMap(map, (List<? extends EObject>)model.getTypeDeclarations().getTypeDeclaration());
        ModelServerUtils.addToMap(map, (List<? extends EObject>)model.getApplication());
        ModelServerUtils.addToMap(map, (List<? extends EObject>)model.getData());
        ModelServerUtils.addToMap(map, (List<? extends EObject>)model.getRole());
        ModelServerUtils.addToMap(map, (List<? extends EObject>)model.getConditionalPerformer());
        ModelServerUtils.addToMap(map, (List<? extends EObject>)model.getOrganization());
        ModelServerUtils.addToMap(map, (List<? extends EObject>)model.getProcessDefinition());
        ModelServerUtils.addToMap(map, (List<? extends EObject>)model.getDiagram());
        ModelServerUtils.addToMap(map, (List<? extends EObject>)model.getLinkType());
        return map;
    }

    public static List<EObject> getElementsWithoutUuid(ModelType model) {
        List list = CollectionUtils.newList();
        String uuid = UUIDUtils.getUUID((EObject)model);
        if (uuid == null) {
            list.add(model);
        }
        ModelServerUtils.addToList(list, (List<? extends EObject>)model.getTypeDeclarations().getTypeDeclaration());
        ModelServerUtils.addToList(list, (List<? extends EObject>)model.getApplication());
        ModelServerUtils.addToList(list, (List<? extends EObject>)model.getData());
        ModelServerUtils.addToList(list, (List<? extends EObject>)model.getRole());
        ModelServerUtils.addToList(list, (List<? extends EObject>)model.getConditionalPerformer());
        ModelServerUtils.addToList(list, (List<? extends EObject>)model.getOrganization());
        ModelServerUtils.addToList(list, (List<? extends EObject>)model.getProcessDefinition());
        ModelServerUtils.addToList(list, (List<? extends EObject>)model.getDiagram());
        ModelServerUtils.addToList(list, (List<? extends EObject>)model.getLinkType());
        return list;
    }

    private static void addToList(List<EObject> list, List<? extends EObject> domain) {
        int i = 0;
        while (i < domain.size()) {
            String uuid;
            EObject me = domain.get(i);
            if (!(me instanceof DataType && ((DataType)me).isPredefined() || (uuid = UUIDUtils.getUUID((EObject)me)) != null)) {
                list.add(me);
            }
            ++i;
        }
    }

    private static void addToMap(Map<String, EObject> map, List<? extends EObject> domain) {
        int i = 0;
        while (i < domain.size()) {
            EObject me = domain.get(i);
            String uuid = UUIDUtils.getUUID((EObject)me);
            if (uuid != null) {
                map.put(uuid, me);
            }
            ++i;
        }
    }

    public static void mergeElements2(List<EObject> sourceModelElements, ModelType sourceModel, ModelType targetModel) {
        Map<String, EObject> map = ModelServerUtils.createUuidToElementMap(targetModel);
        for (EObject sourceElement : sourceModelElements) {
            EObject targetElement = map.get(UUIDUtils.getUUID((EObject)sourceElement));
            if (targetElement == null) continue;
            if (sourceElement instanceof ModelType) {
                ModelCopier copier = new ModelCopier();
                copier.copy((ModelType)sourceElement, (ModelType)targetElement);
                continue;
            }
            MergeUtils.replace((EObject)targetElement, (EObject)sourceElement);
        }
        if (!sourceModelElements.isEmpty()) {
            ModelServerUtils.replaceReferences(sourceModelElements, targetModel);
        }
    }

    public static void mergeElements3(List<EObject> targetModelElements, ModelType sourceModel, ModelType targetModel) {
        Map<String, EObject> sourceMap = ModelServerUtils.createUuidToElementMap(sourceModel);
        int i = 0;
        while (i < targetModelElements.size()) {
            EObject targetElement = targetModelElements.get(i);
            EObject sourceElement = sourceMap.get(UUIDUtils.getUUID((EObject)targetElement));
            if (sourceElement != null) {
                if (sourceElement instanceof ModelType) {
                    ModelCopier copier = new ModelCopier();
                    copier.copy((ModelType)sourceElement, (ModelType)targetElement);
                } else {
                    MergeUtils.replace((EObject)targetElement, (EObject)sourceElement);
                    targetModelElements.set(i, sourceElement);
                }
            } else {
                targetModelElements.remove(i);
            }
            ++i;
        }
        if (!targetModelElements.isEmpty()) {
            ModelServerUtils.replaceReferences(targetModelElements, targetModel);
        }
    }

    private static void replaceReferences(List<EObject> targetModelElements, ModelType targetModel) {
        Map<String, EObject> targetMap = ModelServerUtils.createUuidToElementMap(targetModel);
        int i = 0;
        while (i < targetModelElements.size()) {
            EObject targetElement = targetModelElements.get(i);
            if (!(targetElement instanceof ModelType)) {
                TreeIterator contents = targetElement.eAllContents();
                while (contents.hasNext()) {
                    EObject item = (EObject)contents.next();
                    ModelServerUtils.replaceReferences(targetModel, targetMap, item);
                }
                ModelServerUtils.replaceReferences(targetModel, targetMap, targetElement);
            }
            ++i;
        }
    }

    private static void replaceReferences(ModelType targetModel, Map<String, EObject> targetMap, EObject item) {
        AttributeType attribute;
        IdentifiableReference reference;
        EList crossReferences = item.eCrossReferences();
        EContentsEList.FeatureIterator featureIterator = (EContentsEList.FeatureIterator)crossReferences.iterator();
        List objects = CollectionUtils.newList();
        List references = CollectionUtils.newList();
        while (featureIterator.hasNext()) {
            objects.add((EObject)featureIterator.next());
            references.add(featureIterator.feature());
        }
        int i = 0;
        while (i < objects.size()) {
            block12: {
                EStructuralFeature feature;
                EObject replacement;
                EObject eObject;
                block14: {
                    ModelType externalModel;
                    block13: {
                        eObject = (EObject)objects.get(i);
                        externalModel = ModelUtils.findContainingModel((EObject)eObject);
                        if (externalModel == targetModel) break block12;
                        replacement = null;
                        if (!ShareUtils.isLockableElement((Object)eObject)) break block13;
                        String uuid = UUIDUtils.getUUID((EObject)eObject);
                        if (uuid != null) {
                            replacement = targetMap.get(uuid);
                        }
                        break block14;
                    }
                    if (externalModel == null && XSDPackage.eINSTANCE.equals(eObject.eClass().getEPackage())) break block12;
                    if (externalModel != null) {
                        replacement = ModelServerUtils.getSameModelElement(eObject, targetModel, externalModel);
                    }
                }
                if ((feature = (EStructuralFeature)references.get(i)).isChangeable()) {
                    if (replacement == null || objects.contains(replacement)) {
                        EcoreUtil.remove((EObject)item, (EStructuralFeature)feature, (Object)eObject);
                    } else {
                        EcoreUtil.replace((EObject)item, (EStructuralFeature)feature, (Object)eObject, (Object)replacement);
                    }
                }
            }
            ++i;
        }
        if (item instanceof AttributeType && (reference = (attribute = (AttributeType)item).getReference()) != null) {
            ModelServerUtils.replaceReferences(targetModel, targetMap, (EObject)reference);
        }
    }

    public static EObject getSameModelElement(EObject object, ModelType targetModel, ModelType sourceModel) {
        if (object == null) {
            return null;
        }
        if (object == sourceModel) {
            return targetModel;
        }
        EObject targetParent = ModelServerUtils.getSameModelElement(object.eContainer(), targetModel, sourceModel);
        if (targetParent != null) {
            if (object instanceof ExternalPackage) {
                return ((ExternalPackages)targetParent).getExternalPackage(((ExternalPackage)object).getId());
            }
            if (object instanceof TypeDeclarationType) {
                return ((TypeDeclarationsType)targetParent).getTypeDeclaration(((TypeDeclarationType)object).getId());
            }
            EStructuralFeature feature = object.eContainingFeature();
            Object obj = targetParent.eGet(feature);
            if (obj instanceof FeatureMap) {
                obj = ((FeatureMap)obj).get((EStructuralFeature)object.eContainmentFeature(), true);
            }
            if (obj instanceof List) {
                List list = (List)obj;
                if (object instanceof IIdentifiableElement) {
                    return (EObject)ModelUtils.findElementById((List)list, (String)((IIdentifiableElement)object).getId());
                }
                if (object instanceof IModelElement) {
                    return ModelUtils.findElementByOid((List)list, (long)((IModelElement)object).getElementOid());
                }
                if (XSDPackage.eINSTANCE.equals(object.eClass().getEPackage())) {
                    return ModelUtils.findElementByFeature((List)list, (Object)object, (String)"name");
                }
            } else if (obj instanceof EObject) {
                return (EObject)obj;
            }
        }
        return null;
    }

    public static IResource[] removeElements(List<? extends EObject> elements, ModelType model, IProject project, ModelType sameModel) {
        ArrayList<IFile> lockfiles = new ArrayList<IFile>();
        for (EObject eObject : elements) {
            EObject eObject2 = CopyPasteUtil.getSameModelElement(eObject, model, null);
            ModelType parent = eObject2 instanceof TypeDeclarationType ? model.getTypeDeclarations() : model;
            IFolder lockFolder = null;
            lockFolder = sameModel != null ? LockFileUtils.getLockFolder(eObject2, sameModel) : LockFileUtils.getLockFolder(eObject2, model);
            MergeUtils.deleteElement((EObject)eObject2, (EObject)parent);
            IFile file = LockFileUtils.getFile(lockFolder, eObject2);
            if (file == null || !file.exists()) continue;
            lockfiles.add(file);
        }
        return lockfiles.toArray(new IResource[lockfiles.size()]);
    }

    public static void unsetUUIDs(List<? extends EObject> domain) {
        int i = 0;
        while (i < domain.size()) {
            EObject me = domain.get(i);
            UUIDUtils.unsetUUID((EObject)me);
            ++i;
        }
    }

    public static IProject getProject(EObject eObject) {
        return ShareUtils.getProject((Resource)eObject.eResource());
    }

    public static ElementReference extractElementReference(String path) {
        try {
            int pathSeparator = 47;
            if (path.indexOf(pathSeparator) == -1) {
                pathSeparator = 92;
            }
            String lockFileName = path.substring(path.lastIndexOf(pathSeparator) + 1);
            String fileName = lockFileName.substring(0, lockFileName.lastIndexOf(46));
            String elementTypeName = fileName.substring(0, fileName.indexOf("__"));
            EReference elementType = ModelServerUtils.getElementType(elementTypeName);
            String elementId = fileName.substring(fileName.indexOf("__") + 2);
            if (elementType != null && elementId != null) {
                return new ElementReference(elementType, elementId);
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static EReference getElementType(String elementTypeName) {
        if (PKG_CWM.getModelType_Application().getName().equals(elementTypeName)) {
            return PKG_CWM.getModelType_Application();
        }
        if (PKG_CWM.getModelType_ConditionalPerformer().getName().equals(elementTypeName)) {
            return PKG_CWM.getModelType_ConditionalPerformer();
        }
        if (PKG_CWM.getModelType_Organization().getName().equals(elementTypeName)) {
            return PKG_CWM.getModelType_Organization();
        }
        if (PKG_CWM.getModelType_Role().getName().equals(elementTypeName)) {
            return PKG_CWM.getModelType_Role();
        }
        if (PKG_CWM.getModelType_Data().getName().equals(elementTypeName)) {
            return PKG_CWM.getModelType_Data();
        }
        if (PKG_CWM.getModelType_ProcessDefinition().getName().equals(elementTypeName)) {
            return PKG_CWM.getModelType_ProcessDefinition();
        }
        if (PKG_CWM.getModelType_Diagram().getName().equals(elementTypeName)) {
            return PKG_CWM.getModelType_Diagram();
        }
        if (PKG_CWM.getModelType_LinkType().getName().equals(elementTypeName)) {
            return PKG_CWM.getModelType_LinkType();
        }
        if (XpdlPackage.Literals.TYPE_DECLARATIONS_TYPE__TYPE_DECLARATION.getName().equals(elementTypeName)) {
            return XpdlPackage.Literals.TYPE_DECLARATIONS_TYPE__TYPE_DECLARATION;
        }
        return null;
    }

    public static EObject findByUUID(ModelType model, String uuid) {
        Map<String, EObject> map = ModelServerUtils.createUuidToElementMap(model);
        return map.get(uuid);
    }

    public static boolean isChanged(EObject local, EObject remote) {
        EcoreUtil.EqualityHelper eqHelper = new EcoreUtil.EqualityHelper(){
            private static final long serialVersionUID = 1L;
            private boolean referenceTraversed = false;
            private Stack<EStructuralFeature> currentFeature = new Stack();

            public boolean equals(EObject eObject1, EObject eObject2) {
                if (eObject1 == null) {
                    return eObject2 == null;
                }
                if (eObject2 == null) {
                    return false;
                }
                Object eObject1MappedValue = this.get(eObject1);
                if (eObject1MappedValue != null) {
                    return eObject1MappedValue == eObject2;
                }
                Object eObject2MappedValue = this.get(eObject2);
                if (eObject2MappedValue != null) {
                    return eObject2MappedValue == eObject1;
                }
                if (eObject1 == eObject2) {
                    this.put(eObject1, eObject2);
                    this.put(eObject2, eObject1);
                    return true;
                }
                EClass eClass = eObject1.eClass();
                if (eClass != eObject2.eClass()) {
                    return false;
                }
                this.put(eObject1, eObject2);
                this.put(eObject2, eObject1);
                if (this.referenceTraversed) {
                    String uuid1 = UUIDUtils.getUUID((EObject)eObject1);
                    String uuid2 = UUIDUtils.getUUID((EObject)eObject2);
                    if (uuid1 != null && uuid1.equals(uuid2)) {
                        return true;
                    }
                    if (eObject1 instanceof IIdentifiableElement && eObject1.eContainer() instanceof ModelType) {
                        return CompareHelper.areEqual((Object)((IIdentifiableElement)eObject1).getId(), (Object)((IIdentifiableElement)eObject2).getId());
                    }
                }
                int i = 0;
                int size = eClass.getFeatureCount();
                while (i < size) {
                    EClassifier classifier;
                    Class clazz;
                    EStructuralFeature feature = eClass.getEStructuralFeature(i);
                    if (!(feature.isDerived() || feature.isTransient() || CarnotWorkflowModelPackage.eINSTANCE.getIModelElement_ElementOid().equals(feature) || Node.class.isAssignableFrom(clazz = (classifier = feature.getEType()).getInstanceClass()) || eObject1 instanceof ModelType && classifier instanceof EClass && (CarnotWorkflowModelPackage.eINSTANCE.getIExtensibleElement().isSuperTypeOf((EClass)classifier) || XpdlPackage.eINSTANCE.getTypeDeclarationsType().isSuperTypeOf((EClass)classifier)) || this.haveEqualFeature(eObject1, eObject2, feature))) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }

            protected boolean haveEqualReference(EObject object1, EObject object2, EReference reference) {
                Object value1 = object1.eGet((EStructuralFeature)reference);
                Object value2 = object2.eGet((EStructuralFeature)reference);
                if (value1 == null && value2 != null) {
                    String uuid2 = UUIDUtils.getUUID((EObject)((EObject)value2));
                    if (!StringUtils.isEmpty((String)uuid2)) {
                        ModelType localModel = ModelUtils.findContainingModel((EObject)object1);
                        EObject compareElement = ModelServerUtils.findByUUID(localModel, uuid2);
                        if (compareElement == null) {
                            return true;
                        }
                    } else {
                        if (object1 instanceof DataType && ((DataType)object1).getExternalReference() != null) {
                            return true;
                        }
                        if (object1 instanceof ActivityType && ((ActivityType)object1).getExternalRef() != null) {
                            return true;
                        }
                        if (object1 instanceof ProcessDefinitionType && ((ProcessDefinitionType)object1).getExternalRef() != null) {
                            return true;
                        }
                    }
                }
                this.referenceTraversed = true;
                return super.haveEqualReference(object1, object2, reference);
            }

            protected boolean haveEqualFeature(EObject eObject1, EObject eObject2, EStructuralFeature feature) {
                try {
                    this.currentFeature.push(feature);
                    if (CarnotWorkflowModelPackage.eINSTANCE.getIExtensibleElement_Attribute().equals(feature)) {
                        boolean bl = this.haveEqualDynamicAttribute(eObject1, eObject2);
                        return bl;
                    }
                    boolean bl = feature instanceof EReference ? this.haveEqualReference(eObject1, eObject2, (EReference)feature) : this.haveEqualAttribute(eObject1, eObject2, (EAttribute)feature);
                    return bl;
                }
                finally {
                    this.currentFeature.pop();
                }
            }

            protected boolean haveEqualAttribute(EObject object1, EObject object2, EAttribute attribute) {
                if (object1 instanceof AttributeType && object2 instanceof AttributeType && attribute == CarnotWorkflowModelPackage.eINSTANCE.getAttributeType_Value() && AttributeUtil.isReference((AttributeType)((AttributeType)object1)) && AttributeUtil.isReference((AttributeType)((AttributeType)object2))) {
                    return this.equals(((AttributeType)object1).getReference().getIdentifiable(), ((AttributeType)object2).getReference().getIdentifiable());
                }
                return super.haveEqualAttribute(object1, object2, attribute);
            }

            public boolean equals(List<EObject> list1, List<EObject> list2) {
                int size = Math.max(list1.size(), list2.size());
                int i = 0;
                while (i < size) {
                    EObject eObject1 = i < list1.size() ? list1.get(i) : null;
                    EObject eObject2 = i < list2.size() ? list2.get(i) : null;
                    String uuid1 = UUIDUtils.getUUID((EObject)eObject1);
                    String uuid2 = UUIDUtils.getUUID((EObject)eObject2);
                    if (uuid1 != null && uuid2 != null) {
                        uuid1.equals(uuid2);
                    }
                    if (!this.equals(eObject1, eObject2) && eObject1 != null) {
                        if (eObject2 == null) {
                            return false;
                        }
                        return false;
                    }
                    ++i;
                }
                return true;
            }

            private boolean haveEqualDynamicAttribute(EObject object1, EObject object2) {
                ModelType localModel = ModelUtils.findContainingModel((EObject)object1);
                ModelType remoteModel = ModelUtils.findContainingModel((EObject)object2);
                List list1 = (List)object1.eGet((EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getIExtensibleElement_Attribute());
                List list2 = (List)object2.eGet((EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getIExtensibleElement_Attribute());
                List outer = list1;
                List inner = list2;
                int size = list1.size();
                if (size != list2.size() && list2.size() > size) {
                    outer = list2;
                    inner = list1;
                }
                for (AttributeType attribute2 : outer) {
                    EObject compareElement;
                    ModelType model;
                    EObject object;
                    String uuid2;
                    boolean found = false;
                    for (AttributeType attribute1 : inner) {
                        if (!attribute1.getName().equals(attribute2.getName())) continue;
                        found = true;
                        if (this.equals((EObject)attribute1, (EObject)attribute2)) break;
                        return false;
                    }
                    if (found) continue;
                    return AttributeUtil.isReference((AttributeType)attribute2) && !StringUtils.isEmpty((String)(uuid2 = UUIDUtils.getUUID((EObject)(object = AttributeUtil.getReferenceElement((AttributeType)attribute2))))) && (model = ModelUtils.findContainingModel((EObject)object)).equals(remoteModel) && (compareElement = ModelServerUtils.findByUUID(localModel, uuid2)) == null;
                }
                return true;
            }
        };
        return !eqHelper.equals(local, remote);
    }

    public static void refreshTreeItem(ModelType model) {
        Map<String, EObject> localMap = ModelServerUtils.createUuidToElementMap(model);
        ModelServerUtils.refreshTreeItems(localMap.values());
    }

    public static void refreshTreeItems(Collection<EObject> elements) {
        for (EObject element : elements) {
            CreationUtils.refreshTreeItem(element);
        }
    }

    public static Image getIconWithOverlay(IMergeUtils mergeUtils, EObject element, Image baseImage) {
        if (mergeUtils.isRemovedElement(element)) {
            return ModelServerUtils.getIconWithOverlay(baseImage, imageDeleted, 1);
        }
        if (mergeUtils.isNewElement(element)) {
            return ModelServerUtils.getIconWithOverlay(baseImage, imageAdded, 1);
        }
        if (mergeUtils.hasChanged(element)) {
            return ModelServerUtils.getIconWithOverlay(baseImage, imageEdited, 1);
        }
        return null;
    }

    public static Image getIconWithOverlay(Image baseImage, Image overlay, int location) {
        if (baseImage != null && overlay != null) {
            Image icon;
            Map<Image, Image> cache;
            Map<Image, Map<Image, Image>> locationCache = imageCache.get(location);
            if (locationCache == null) {
                locationCache = new HashMap<Image, Map<Image, Image>>();
                imageCache.put(location, locationCache);
            }
            if ((cache = locationCache.get(overlay)) == null) {
                cache = new HashMap<Image, Image>();
                locationCache.put(overlay, cache);
            }
            if ((icon = cache.get(baseImage)) == null) {
                icon = new IconWithOverlays(baseImage, overlay, location).createImage();
                cache.put(baseImage, icon);
            }
            return icon;
        }
        return null;
    }
}

