/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.modelserver.jobs;

import org.eclipse.stardust.modeling.core.modelserver.jobs.CollisionState;

public class CollisionInfo {
    public static final CollisionInfo DEFAULT = new CollisionInfo(CollisionState.DEFAULT, null);
    public static final CollisionInfo ADDED = new CollisionInfo(CollisionState.ADDED, null);
    public static final CollisionInfo REMOVED = new CollisionInfo(CollisionState.REMOVED, null);
    public static final CollisionInfo LOCKED_BY_OTHER = new CollisionInfo(CollisionState.LOCKED_BY_OTHER, null);
    public static final CollisionInfo LOCKED_BY_USER = new CollisionInfo(CollisionState.LOCKED_BY_USER, null);
    private CollisionState state;
    private String owner;

    private CollisionInfo(CollisionState state, String owner) {
        this.state = state;
        this.owner = owner;
    }

    public CollisionState getState() {
        return this.state;
    }

    public String getOwner() {
        return this.owner;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.owner == null ? 0 : this.owner.hashCode());
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CollisionInfo other = (CollisionInfo)obj;
        if (this.owner == null ? other.owner != null : !this.owner.equals(other.owner)) {
            return false;
        }
        return !(this.state == null ? other.state != null : !this.state.equals((Object)other.state));
    }

    public static CollisionInfo create(CollisionState state, String owner) {
        assert (state != null);
        if (owner == null) {
            switch (state) {
                case DEFAULT: {
                    return DEFAULT;
                }
                case ADDED: {
                    return ADDED;
                }
                case REMOVED: {
                    return REMOVED;
                }
                case LOCKED_BY_OTHER: {
                    return LOCKED_BY_OTHER;
                }
                case LOCKED_BY_USER: {
                    return LOCKED_BY_USER;
                }
            }
        }
        return new CollisionInfo(state, owner);
    }
}

