/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.modelserver.jobs;

import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.common.CompareHelper;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.modelserver.LockFileUtils;
import org.eclipse.stardust.modeling.core.modelserver.ModelServer;
import org.eclipse.stardust.modeling.core.modelserver.ModelServerUtils;
import org.eclipse.stardust.modeling.core.modelserver.RMSException;
import org.eclipse.stardust.modeling.core.modelserver.Vcs;
import org.eclipse.stardust.modeling.core.modelserver.VcsStatus;
import org.eclipse.stardust.modeling.core.modelserver.jobs.CollisionInfo;
import org.eclipse.stardust.modeling.core.modelserver.jobs.StateCache;
import org.eclipse.stardust.modeling.core.modelserver.ui.VcsFeedView;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class RefreshStatusJob
extends Job {
    private NullProgressMonitor NULL_MONITOR = new NullProgressMonitor();
    private ModelServer modelServer;
    private boolean jobInterrupted = false;

    public RefreshStatusJob(ModelServer server) {
        super(Diagram_Messages.LB_REFRESH_STATUS_JOB);
        this.setPriority(30);
        this.modelServer = server;
    }

    public void callSchedule() {
        if (this.jobInterrupted) {
            this.jobInterrupted = false;
            this.schedule(5000L);
            return;
        }
        if (PlatformUI.getPreferenceStore().getBoolean("collisionRefresh")) {
            int refreshRate = PlatformUI.getPreferenceStore().getInt("collisionRefreshRate");
            this.schedule(refreshRate * 1000);
        } else {
            this.modelServer.getJobUtils().setRefreshStatusJob(null);
        }
    }

    protected IStatus run(final IProgressMonitor monitor) {
        WorkflowModelEditor editor;
        ModelType model;
        StateCache stateCache;
        Vcs vcs;
        block21: {
            block20: {
                block19: {
                    block18: {
                        vcs = ModelServerUtils.getVcs2(this.modelServer.getProject());
                        if (vcs != null) break block18;
                        this.modelServer.getJobUtils().setRefreshStatusJob(null);
                        IStatus iStatus = Status.CANCEL_STATUS;
                        this.modelServer.refreshLocal(monitor);
                        return iStatus;
                    }
                    if (this.modelServer.isEnableRefreshStatusJob()) break block19;
                    this.jobInterrupted = true;
                    monitor.done();
                    this.callSchedule();
                    IStatus iStatus = Status.OK_STATUS;
                    this.modelServer.refreshLocal(monitor);
                    return iStatus;
                }
                if (PlatformUI.getPreferenceStore().getBoolean("collisionRefresh")) break block20;
                monitor.done();
                IStatus iStatus = Status.OK_STATUS;
                this.modelServer.refreshLocal(monitor);
                return iStatus;
            }
            stateCache = this.modelServer.getStateCache();
            model = this.modelServer.getModel();
            editor = GenericUtils.getWorkflowModelEditor(model);
            if (editor != null) break block21;
            monitor.done();
            this.modelServer.getJobUtils().setRefreshStatusJob(null);
            IStatus iStatus = Status.OK_STATUS;
            this.modelServer.refreshLocal(monitor);
            return iStatus;
        }
        try {
            try {
                Map<String, EObject> localMap = ModelServerUtils.createUuidToElementMap(model);
                monitor.beginTask(String.valueOf(Diagram_Messages.LB_REFRESH_STATUS_JOB) + this.modelServer.getModelName(), localMap.size() + 1);
                IResource[] placeholder = new IResource[1];
                for (EObject element : localMap.values()) {
                    if (monitor.isCanceled()) break;
                    monitor.subTask(this.modelServer.getLabel(element));
                    IFile lockFile = LockFileUtils.getLockFile(element);
                    if (lockFile == null) {
                        stateCache.setState(element, CollisionInfo.ADDED);
                    } else if (!lockFile.exists()) {
                        stateCache.setState(element, CollisionInfo.REMOVED);
                    } else {
                        VcsStatus status = vcs.getStatus((IResource)lockFile);
                        if (status.getStatus() == 2) {
                            placeholder[0] = lockFile;
                            vcs.update(placeholder, (IProgressMonitor)this.NULL_MONITOR);
                            stateCache.setState(element, CollisionInfo.REMOVED);
                        } else if (!CompareHelper.areEqual((Object)status.getHeadRevision(), (Object)status.getBaseRevision())) {
                            placeholder[0] = lockFile;
                            vcs.update(placeholder, (IProgressMonitor)this.NULL_MONITOR);
                            stateCache.updateState(element, status);
                        } else {
                            stateCache.updateState(element, status);
                        }
                    }
                    monitor.worked(1);
                }
                if (PlatformUI.getPreferenceStore().getBoolean("collisionUpdate")) {
                    IWorkbenchWindow window = editor.getSite().getWorkbenchWindow();
                    IWorkbenchPage page = window.getActivePage();
                    final IViewPart view = page.findView("org.eclipse.stardust.modeling.core.modelserver.ui.VcsFeedView");
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (view != null) {
                                List[] history = new List[1];
                                try {
                                    history[0] = RefreshStatusJob.this.modelServer.getModelHistory(model, monitor);
                                    ((VcsFeedView)view).replaceData(history[0]);
                                }
                                catch (RMSException rMSException) {}
                            }
                        }
                    });
                }
                monitor.worked(1);
            }
            catch (Exception exception) {
                this.jobInterrupted = true;
                this.modelServer.refreshLocal(monitor);
            }
        }
        catch (Throwable throwable) {
            this.modelServer.refreshLocal(monitor);
            throw throwable;
        }
        this.modelServer.refreshLocal(monitor);
        this.modelServer.setLastRefresh(new Long(System.currentTimeMillis()));
        monitor.done();
        this.callSchedule();
        return Status.OK_STATUS;
    }
}

