/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.modelserver.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlPackage;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.ui.IModelElementContainer;
import org.eclipse.swt.graphics.Image;

public class ModelContainer {
    private static final CarnotWorkflowModelPackage PKG_CWM = CarnotWorkflowModelPackage.eINSTANCE;
    private Container container = new Container();
    private WorkflowModelEditor editor;

    public ModelContainer(WorkflowModelEditor editor) {
        this.editor = editor;
    }

    public Container getContainer() {
        return this.container;
    }

    public class Container
    implements IModelElementContainer {
        private ModelType model;
        private TypeDeclarations typeDeclarations = new TypeDeclarations();
        private Applications applications = new Applications();
        private Datas datas = new Datas();
        private Participants participants = new Participants();
        private List processDefinitions;
        private List diagrams;
        private List linkTypes;

        public void setModel(ModelType model) {
            this.model = model;
        }

        public void setProcessDefinitions(List processDefinitions) {
            this.processDefinitions = processDefinitions;
        }

        public void setDiagrams(List diagrams) {
            this.diagrams = diagrams;
        }

        public void setLinkTypes(List linkTypes) {
            this.linkTypes = linkTypes;
        }

        public TypeDeclarations getTypeDeclarations() {
            return this.typeDeclarations;
        }

        public Applications getApplications() {
            return this.applications;
        }

        public Datas getDatas() {
            return this.datas;
        }

        public Participants getParticipants() {
            return this.participants;
        }

        @Override
        public List getContent() {
            ArrayList<Object> content = new ArrayList<Object>();
            if (this.model != null) {
                content.add(this.model);
            }
            if (!this.getTypeDeclarations().getContent().isEmpty()) {
                content.add(this.getTypeDeclarations());
            }
            if (!this.getApplications().getContent().isEmpty()) {
                content.add(this.getApplications());
            }
            if (!this.getDatas().getContent().isEmpty()) {
                content.add(this.getDatas());
            }
            if (!this.getParticipants().getContent().isEmpty()) {
                content.add(this.getParticipants());
            }
            if (this.processDefinitions != null && !this.processDefinitions.isEmpty()) {
                for (EObject element : this.processDefinitions) {
                    content.add(element);
                }
            }
            if (this.diagrams != null && !this.diagrams.isEmpty()) {
                for (EObject element : this.diagrams) {
                    content.add(element);
                }
            }
            if (this.linkTypes != null && !this.linkTypes.isEmpty()) {
                for (EObject element : this.linkTypes) {
                    content.add(element);
                }
            }
            return content;
        }

        @Override
        public Image getImage() {
            return null;
        }

        @Override
        public String getLabel() {
            return Diagram_Messages.LBL_ALL_ELEMENTS;
        }

        @Override
        public void setChecked(boolean checked) {
        }

        public class Applications
        implements IModelElementContainer {
            List content = new ArrayList();

            @Override
            public List getContent() {
                return this.content;
            }

            @Override
            public Image getImage() {
                String iconPath = ModelContainer.this.editor.getIconFactory().getIconFor((EObject)PKG_CWM.getApplicationType());
                return DiagramPlugin.getDefault().getImageManager().getImage(iconPath);
            }

            @Override
            public String getLabel() {
                return Diagram_Messages.LB_Applications;
            }

            @Override
            public void setChecked(boolean checked) {
            }
        }

        public class Datas
        implements IModelElementContainer {
            List content = new ArrayList();

            @Override
            public List getContent() {
                return this.content;
            }

            @Override
            public Image getImage() {
                String iconPath = ModelContainer.this.editor.getIconFactory().getIconFor((EObject)PKG_CWM.getDataType());
                return DiagramPlugin.getDefault().getImageManager().getImage(iconPath);
            }

            @Override
            public String getLabel() {
                return Diagram_Messages.DATA_LABEL;
            }

            @Override
            public void setChecked(boolean checked) {
            }
        }

        public class Participants
        implements IModelElementContainer {
            List content = new ArrayList();

            @Override
            public List getContent() {
                return this.content;
            }

            @Override
            public Image getImage() {
                String iconPath = ModelContainer.this.editor.getIconFactory().getIconFor((EObject)PKG_CWM.getIModelParticipant());
                return DiagramPlugin.getDefault().getImageManager().getImage(iconPath);
            }

            @Override
            public String getLabel() {
                return Diagram_Messages.LB_Participants;
            }

            @Override
            public void setChecked(boolean checked) {
            }
        }

        public class TypeDeclarations
        implements IModelElementContainer {
            List content = new ArrayList();

            @Override
            public List getContent() {
                return this.content;
            }

            @Override
            public Image getImage() {
                String iconPath = ModelContainer.this.editor.getIconFactory().getIconFor((EObject)XpdlPackage.eINSTANCE.getTypeDeclarationsType());
                return DiagramPlugin.getDefault().getImageManager().getImage(iconPath);
            }

            @Override
            public String getLabel() {
                return Diagram_Messages.STRUCTURED_DATA_LABEL;
            }

            @Override
            public void setChecked(boolean checked) {
            }
        }
    }
}

