/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.modelserver.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.CurrentModelFinder;
import org.eclipse.stardust.modeling.core.modelserver.ModelHistoryEntry;
import org.eclipse.stardust.modeling.core.modelserver.ModelServer;
import org.eclipse.stardust.modeling.core.modelserver.ModelServerUtils;
import org.eclipse.stardust.modeling.core.modelserver.RMSException;
import org.eclipse.stardust.modeling.core.modelserver.ui.vcsfeedtable.VcsFeedTable;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class VcsFeedView
extends ViewPart
implements IPartListener {
    private Composite parent;
    private CurrentModelFinder modelFinder;
    private VcsFeedTable vcsFeedTable;
    private Action refreshAction;
    private ModelType currentModel;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.modelFinder = CurrentModelFinder.getInstance();
        this.modelFinder.addListener(this);
    }

    public void dispose() {
        this.modelFinder.removeListener(this);
        super.dispose();
    }

    public void replaceData(List<ModelHistoryEntry> modelHistoryEntries) {
        if (this.vcsFeedTable != null) {
            this.vcsFeedTable.replaceData(modelHistoryEntries);
        }
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        parent.setLayout((Layout)gridLayout);
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        this.refreshAction = new Action(Diagram_Messages.LB_Refresh, DiagramPlugin.getImageDescriptor("icons/full/obj16/refresh.gif")){

            public void run() {
                WorkflowModelEditor editor = GenericUtils.getWorkflowModelEditor(VcsFeedView.this.currentModel);
                if (editor == null) {
                    return;
                }
                final ModelServer modelServer = editor.getModelServer();
                if (modelServer != null && modelServer.isModelShared()) {
                    final List[] history = new List[1];
                    IRunnableWithProgress commitOperation = new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                history[0] = modelServer.getModelHistory(VcsFeedView.this.currentModel, monitor);
                            }
                            catch (RMSException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    };
                    try {
                        new ProgressMonitorDialog(editor.getSite().getShell()).run(true, true, commitOperation);
                        VcsFeedView.this.replaceData(history[0]);
                    }
                    catch (InvocationTargetException e) {
                        Throwable t = e.getCause();
                        ModelServerUtils.showMessageBox(t.getMessage());
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        this.refreshAction.setToolTipText("");
        tbm.add((IAction)this.refreshAction);
        this.getViewSite().getActionBars().updateActionBars();
        TabFolder tabFolder = new TabFolder(parent, 0);
        tabFolder.setLayoutData((Object)new GridData(1808));
        TabItem processDefinitionStatisticsTabItem = new TabItem(tabFolder, 0);
        processDefinitionStatisticsTabItem.setText(Diagram_Messages.TXT_COLLABORATIVE_MODELING_FEED);
        this.vcsFeedTable = new VcsFeedTable((Composite)tabFolder);
        processDefinitionStatisticsTabItem.setControl((Control)this.vcsFeedTable.getTable());
        this.replaceData(Collections.EMPTY_LIST);
        this.updateAction(false);
    }

    public void setFocus() {
        this.parent.setFocus();
    }

    public void updateAction(boolean forceUpdate) {
        WorkflowModelEditor editor;
        ModelType model = CurrentModelFinder.getModel();
        if (!forceUpdate && this.currentModel != null && model != null && this.currentModel.equals(model)) {
            return;
        }
        this.currentModel = model;
        boolean isShared = false;
        if (model != null && (editor = GenericUtils.getWorkflowModelEditor(model)) != null) {
            isShared = editor.getModelServer().isModelShared();
        }
        if (model == null || !isShared) {
            this.replaceData(Collections.EMPTY_LIST);
            this.refreshAction.setEnabled(false);
        } else {
            this.replaceData(Collections.EMPTY_LIST);
            this.refreshAction.setEnabled(true);
        }
    }

    public void partActivated(IWorkbenchPart part) {
        this.updateAction(false);
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        this.updateAction(false);
    }

    public void partDeactivated(IWorkbenchPart part) {
        this.updateAction(false);
    }

    public void partOpened(IWorkbenchPart part) {
    }
}

