/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.modelserver.ui.vcsfeedtable;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.ui.TableUtil;
import org.eclipse.stardust.modeling.core.modelserver.ModelHistoryEntry;
import org.eclipse.stardust.modeling.core.modelserver.ui.vcsfeedtable.VcsFeedTableContentProvider;
import org.eclipse.stardust.modeling.core.modelserver.ui.vcsfeedtable.VcsFeedTableLabelProvider;
import org.eclipse.stardust.modeling.core.modelserver.ui.vcsfeedtable.VcsFeedTableModel;
import org.eclipse.stardust.modeling.core.modelserver.ui.vcsfeedtable.VcsFeedTableSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class VcsFeedTable {
    private TableViewer tableViewer;
    private VcsFeedTableSorter tableSorter;

    public VcsFeedTable(Composite parent) {
        this.tableViewer = new TableViewer(parent, 65536);
        Table table = this.tableViewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.createColumns(this.tableViewer);
        TableUtil.setInitialColumnSizes(table, new int[]{10, 20, 20, 20, 20});
        this.tableSorter = new VcsFeedTableSorter();
        this.tableViewer.setSorter((ViewerSorter)this.tableSorter);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new VcsFeedTableLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new VcsFeedTableContentProvider());
        List<ModelHistoryEntry> emptyList = Collections.emptyList();
        this.tableViewer.setInput((Object)new VcsFeedTableModel(emptyList));
    }

    public Table getTable() {
        return this.tableViewer.getTable();
    }

    public void updateData(List<ModelHistoryEntry> modelHistoryEntries) {
        VcsFeedTableModel vcsFeedTableModel = (VcsFeedTableModel)this.tableViewer.getInput();
        vcsFeedTableModel.setModelHistoryEntries(modelHistoryEntries);
        Iterator<ModelHistoryEntry> i = modelHistoryEntries.iterator();
        while (i.hasNext()) {
            this.tableViewer.update((Object)i.next(), null);
        }
    }

    public void replaceData(List<ModelHistoryEntry> modelHistoryEntries) {
        this.tableViewer.setInput((Object)new VcsFeedTableModel(modelHistoryEntries));
        this.tableViewer.refresh();
    }

    private void createColumns(final TableViewer viewer) {
        Table table = viewer.getTable();
        String[] titles = new String[]{Diagram_Messages.LB_VCS_FEED_VIEW_REVISION, Diagram_Messages.LB_VCS_FEED_VIEW_DATE, Diagram_Messages.LB_VCS_FEED_VIEW_AUTHOR, Diagram_Messages.LB_VCS_FEED_VIEW_EVENT, Diagram_Messages.LB_VCS_FEED_VIEW_COMMENT};
        int i = 0;
        while (i < titles.length) {
            final int index = i;
            TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 16384);
            final TableColumn column = viewerColumn.getColumn();
            column.setText(titles[i]);
            column.setMoveable(true);
            column.setResizable(true);
            column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    VcsFeedTable.this.tableSorter.setColumn(index);
                    int dir = viewer.getTable().getSortDirection();
                    dir = viewer.getTable().getSortColumn() == column ? (dir == 128 ? 1024 : 128) : 1024;
                    viewer.getTable().setSortDirection(dir);
                    viewer.getTable().setSortColumn(column);
                    viewer.refresh();
                }
            });
            ++i;
        }
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
    }
}

