/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.modelserver.ui.vcsfeedtable;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.stardust.modeling.core.modelserver.ModelHistoryEntry;

public class VcsFeedTableSorter
extends ViewerSorter {
    private int propertyIndex = 0;
    private static final int DESCENDING = 1;
    private int direction = 1;

    public void setColumn(int column) {
        if (column == this.propertyIndex) {
            this.direction = 1 - this.direction;
        } else {
            this.propertyIndex = column;
            this.direction = 1;
        }
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        ModelHistoryEntry p1 = (ModelHistoryEntry)e1;
        ModelHistoryEntry p2 = (ModelHistoryEntry)e2;
        int rc = 0;
        switch (this.propertyIndex) {
            case 0: {
                rc = p1.getRevision().compareTo(p2.getRevision());
                break;
            }
            case 1: {
                rc = p1.getTimestamp().compareTo(p2.getTimestamp());
                break;
            }
            case 2: {
                rc = p1.getAuthor().compareTo(p2.getAuthor());
                break;
            }
            case 3: {
                String event1 = this.extractEvent(p1.getComment());
                String event2 = this.extractEvent(p2.getComment());
                rc = event1.compareTo(event2);
                break;
            }
            case 4: {
                String comment1 = this.extractComment(p1.getComment());
                String comment2 = this.extractComment(p2.getComment());
                rc = comment1.compareTo(comment2);
                break;
            }
            default: {
                rc = 0;
            }
        }
        if (this.direction == 1) {
            rc = -rc;
        }
        return rc;
    }

    private String extractComment(String comment) {
        if (comment.indexOf("/") > -1) {
            String[] stringArray = comment.split("/");
            return stringArray[1];
        }
        return "";
    }

    private String extractEvent(String comment) {
        if (comment.indexOf("/") > -1) {
            String[] stringArray = comment.split("/");
            return stringArray[0];
        }
        return comment;
    }
}

