/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.properties;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stardust.model.xpdl.carnot.ActivitySymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.EndEventSymbol;
import org.eclipse.stardust.model.xpdl.carnot.FlowControlType;
import org.eclipse.stardust.model.xpdl.carnot.GatewaySymbol;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ISymbolContainer;
import org.eclipse.stardust.model.xpdl.carnot.JoinSplitType;
import org.eclipse.stardust.model.xpdl.carnot.LoopType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.StartEventSymbol;
import org.eclipse.stardust.model.xpdl.carnot.TransitionConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.util.DiagramUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledText;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.SetActivityControlFlowCmd;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.utils.WidgetBindingManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;

public class ActivityControlFlowPropertyPage
extends AbstractModelElementPropertyPage {
    private static final int JOIN = 0;
    private static final int SPLIT = 1;
    private static final int LOOP = 2;
    private static final String[] NAMES = new String[]{Diagram_Messages.LB_TITLE_Join, Diagram_Messages.LB_TITLE_Split, Diagram_Messages.LB_TITLE_Loop};
    private Button[] joinButtons;
    private Button[] splitButtons;
    private Button[] loopButtons;
    private LabeledText loopConditionText;

    @Override
    protected void performDefaults() {
        super.performDefaults();
        this.setSelectedButton(this.joinButtons, this.getActivity().getJoin().getValue());
        this.setSelectedButton(this.splitButtons, this.getActivity().getSplit().getValue());
        this.setSelectedButton(this.loopButtons, this.getActivity().getLoopType().getValue());
    }

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        WidgetBindingManager wBndMgr = this.getWidgetBindingManager();
        this.getActivity();
        this.setSelectedButton(this.joinButtons, this.getActivity().getJoin().getValue());
        this.setSelectedButton(this.splitButtons, this.getActivity().getSplit().getValue());
        this.setSelectedButton(this.loopButtons, this.getActivity().getLoopType().getValue());
        wBndMgr.bind(this.loopConditionText, (EObject)element, (EStructuralFeature)PKG_CWM.getActivityType_LoopCondition());
        if (element instanceof GatewaySymbol) {
            switch (((GatewaySymbol)element).getFlowKind().getValue()) {
                case 1: {
                    this.disableButtons(this.splitButtons);
                    break;
                }
                case 2: {
                    this.disableButtons(this.joinButtons);
                }
            }
            this.disableButtons(this.loopButtons);
            this.loopConditionText.getText().setEnabled(false);
        } else {
            this.enableLoopCondition();
        }
        if (this.isStartActivity()) {
            this.disableButtons(this.joinButtons);
        }
        if (this.isEndActivity()) {
            this.disableButtons(this.splitButtons);
        }
    }

    private boolean isEndActivity() {
        ActivityType activity = this.getActivity();
        ProcessDefinitionType process = (ProcessDefinitionType)activity.eContainer();
        EList diagramList = process.getDiagram();
        int i = 0;
        while (i < diagramList.size()) {
            DiagramType diagram = (DiagramType)diagramList.get(i);
            List activitySymbolList = DiagramUtil.getSymbols((ISymbolContainer)diagram, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getISymbolContainer_ActivitySymbol(), (IModelElement)activity);
            int j = 0;
            while (j < activitySymbolList.size()) {
                ActivitySymbolType activitySymbol = (ActivitySymbolType)activitySymbolList.get(j);
                EList outTransitions = activitySymbol.getOutTransitions();
                int k = 0;
                while (k < outTransitions.size()) {
                    TransitionConnectionType connection = (TransitionConnectionType)outTransitions.get(k);
                    if (connection.getTargetActivitySymbol() instanceof EndEventSymbol) {
                        return true;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private boolean isStartActivity() {
        ActivityType activity = this.getActivity();
        ProcessDefinitionType process = (ProcessDefinitionType)activity.eContainer();
        EList diagramList = process.getDiagram();
        int i = 0;
        while (i < diagramList.size()) {
            DiagramType diagram = (DiagramType)diagramList.get(i);
            List activitySymbolList = DiagramUtil.getSymbols((ISymbolContainer)diagram, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getISymbolContainer_ActivitySymbol(), (IModelElement)activity);
            int j = 0;
            while (j < activitySymbolList.size()) {
                ActivitySymbolType activitySymbol = (ActivitySymbolType)activitySymbolList.get(j);
                EList inTransitions = activitySymbol.getInTransitions();
                int k = 0;
                while (k < inTransitions.size()) {
                    TransitionConnectionType connection = (TransitionConnectionType)inTransitions.get(k);
                    if (connection.getSourceActivitySymbol() instanceof StartEventSymbol) {
                        return true;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private void setSelectedButton(Button[] buttons, int value) {
        int i = 0;
        while (i < buttons.length) {
            if (buttons[i] != null) {
                buttons[i].setSelection(i == value);
            }
            ++i;
        }
    }

    private void disableButtons(Button[] buttons) {
        int i = 0;
        while (i < buttons.length) {
            if (buttons[i] != null) {
                buttons[i].setEnabled(false);
            }
            ++i;
        }
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
    }

    private void setJoinSplitType(int flowType, int gatewayType) {
        SetActivityControlFlowCmd cmd = new SetActivityControlFlowCmd(this.getEditor(), this.getActivity(), FlowControlType.get((int)flowType), JoinSplitType.get((int)gatewayType));
        if (cmd.canExecute()) {
            cmd.execute();
        }
    }

    private ActivityType getActivity() {
        return (ActivityType)this.getModelElement();
    }

    private void setLoopType(LoopType type) {
        this.getActivity().setLoopType(type);
    }

    @Override
    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)1);
        this.joinButtons = new Button[JoinSplitType.VALUES.size()];
        this.createGroup(composite, this.joinButtons, 0, JoinSplitType.VALUES, 0);
        this.splitButtons = new Button[JoinSplitType.VALUES.size()];
        this.createGroup(composite, this.splitButtons, 1, JoinSplitType.VALUES, 0);
        this.loopButtons = new Button[LoopType.VALUES.size()];
        Group loopGroup = this.createGroup(composite, this.loopButtons, 2, LoopType.VALUES, 1);
        this.loopButtons[1].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActivityControlFlowPropertyPage.this.enableLoopCondition();
            }
        });
        Composite conditionComposite = FormBuilder.createComposite((Composite)loopGroup, (int)2, (int)LoopType.VALUES.size());
        this.loopConditionText = FormBuilder.createLabeledText((Composite)conditionComposite, (String)Diagram_Messages.LB_FORMBUILDER_LoopCondition);
        return composite;
    }

    private void enableLoopCondition() {
        this.loopConditionText.getText().setEnabled(!this.loopButtons[1].getSelection());
    }

    private Group createGroup(Composite composite, Button[] buttons, int type, List<? extends Enumerator> enums, int start) {
        Group group = FormBuilder.createGroup((Composite)composite, (String)NAMES[type], (int)enums.size());
        int i = start;
        while (i < enums.size()) {
            Enumerator rawEnum = enums.get(i);
            buttons[i] = this.createRadioButton(group, String.valueOf(ModelUtils.getFlowTypeText((String)rawEnum.getLiteral())) + "  ", rawEnum.getValue(), type);
            ++i;
        }
        return group;
    }

    private Button createRadioButton(Group joinGroup, final String name, final int value, final int type) {
        Button button = FormBuilder.createRadioButton((Composite)joinGroup, (String)name);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((Button)e.widget).getSelection()) {
                    switch (type) {
                        case 0: {
                            ActivityControlFlowPropertyPage.this.setJoinSplitType(1, value);
                            break;
                        }
                        case 1: {
                            ActivityControlFlowPropertyPage.this.setJoinSplitType(2, value);
                            break;
                        }
                        case 2: {
                            ActivityControlFlowPropertyPage.this.setLoopType(LoopType.getByName((String)name.trim()));
                        }
                    }
                }
            }
        });
        return button;
    }
}

