/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.properties;

import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityImplementationType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationContextTypeType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.ContextType;
import org.eclipse.stardust.model.xpdl.carnot.DataMappingConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.DataMappingType;
import org.eclipse.stardust.model.xpdl.carnot.DataSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.AccessPointUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ActivityUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.util.NameIdUtils;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.AbstractWidgetAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.EFeatureAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.EObjectAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.IModelAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.IWidgetAdapter;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledText;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledViewer;
import org.eclipse.stardust.modeling.common.ui.jface.widgets.LabelWithStatus;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.ui.AccessPathBrowserComposite;
import org.eclipse.stardust.modeling.core.editors.ui.EObjectLabelProvider;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.properties.IButtonManager;
import org.eclipse.stardust.modeling.core.ui.Data2DataPathModelAdapter2;
import org.eclipse.stardust.modeling.core.ui.Data2DataPathWidgetAdapter2;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;
import org.eclipse.stardust.modeling.core.utils.WidgetBindingManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class DataMappingPropertyPage
extends AbstractModelElementPropertyPage {
    protected LabeledText txtId;
    protected LabeledText txtName;
    private LabelWithStatus dataLabel;
    private ComboViewer dataText;
    private LabelWithStatus dataPathLabel;
    private AccessPathBrowserComposite dataPathBrowser;
    private LabelWithStatus apLabel;
    private ComboViewer accessPointText;
    private LabelWithStatus accessPathLabel;
    private AccessPathBrowserComposite accessPathBrowser;
    private Button[] buttons;
    private WidgetBindingManager binding;
    private List<AccessPointType> accessPoints = CollectionUtils.newList();
    private ModelType model;
    private ActivityType activity;
    private DataMappingType dataMapping;
    private DirectionType direction;
    private String dataMappingContext;
    private ModifyListener listener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (GenericUtils.getAutoIdValue()) {
                String computedId = NameIdUtils.createIdFromName(null, (EObject)DataMappingPropertyPage.this.getModelElement());
                DataMappingPropertyPage.this.txtId.getText().setText(computedId);
            }
        }
    };

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        this.txtName.getText().removeModifyListener(this.listener);
        this.binding = this.getWidgetBindingManager();
        this.dataMapping = (DataMappingType)element;
        this.model = ModelUtils.findContainingModel((EObject)this.dataMapping);
        ApplicationContextTypeType ctxType = (ApplicationContextTypeType)ModelUtils.findIdentifiableElement((EObject)this.model, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getModelType_ApplicationContextType(), (String)this.dataMapping.getContext());
        this.dataText.getCombo().setEnabled(this.getData() == null);
        this.dataMappingContext = this.dataMapping.getContext();
        this.binding.getModelBindingManager().bind((IModelAdapter)new Data2DataPathModelAdapter2(this.model, this.model.getData()), (IWidgetAdapter)new Data2DataPathWidgetAdapter2((StructuredViewer)this.dataText, this.dataPathBrowser, this.dataMapping.getDirection()));
        this.binding.bind(new LabeledViewer((StructuredViewer)this.dataText, this.dataLabel), (EObject)this.dataMapping, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getDataMappingType_Data());
        this.binding.getModelBindingManager().bind((EObject)this.dataMapping, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getDataMappingType_Data(), (IWidgetAdapter)new AbstractWidgetAdapter(){

            public void updateVisuals(Object value) {
                ActivityType activity = (ActivityType)DataMappingPropertyPage.this.dataMapping.eContainer();
                if (activity != null) {
                    ActivityUtil.updateConnections((ActivityType)activity);
                }
            }
        });
        this.binding.bind(new LabeledText(this.dataPathBrowser.getMethodText(), this.dataPathLabel), (EObject)this.dataMapping, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getDataMappingType_DataPath());
        boolean hasApplicationPath = ctxType.isHasApplicationPath();
        this.activity = (ActivityType)this.dataMapping.eContainer();
        if (hasApplicationPath) {
            this.accessPointText.getCombo().setEnabled(true);
            this.updateAccessPoints();
            this.direction = this.dataMapping.getDirection();
            if (DirectionType.IN_LITERAL.equals((Object)this.direction)) {
                this.direction = DirectionType.OUT_LITERAL;
            } else if (DirectionType.OUT_LITERAL.equals((Object)this.direction)) {
                this.direction = DirectionType.IN_LITERAL;
            }
            this.binding.getModelBindingManager().bind((IModelAdapter)new Data2DataPathModelAdapter2(this.activity, this.accessPoints), (IWidgetAdapter)new Data2DataPathWidgetAdapter2((StructuredViewer)this.accessPointText, this.accessPathBrowser, this.direction));
            this.binding.bind(new LabeledViewer((StructuredViewer)this.accessPointText, this.apLabel), (EObject)this.dataMapping, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getDataMappingType_ApplicationAccessPoint(), new EFeatureAdapter(){

                public Object toModel(EObjectAdapter binding, Object value) {
                    return value == null ? null : ((AccessPointType)value).getId();
                }

                public Object fromModel(EObjectAdapter binding, Object value) {
                    for (AccessPointType ap : DataMappingPropertyPage.this.accessPoints) {
                        if (!ap.getId().equals(value)) continue;
                        return ap;
                    }
                    return null;
                }
            });
            this.binding.bind(new LabeledText(this.accessPathBrowser.getMethodText(), this.accessPathLabel), (EObject)this.dataMapping, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getDataMappingType_ApplicationPath());
        } else if (ActivityImplementationType.ROUTE_LITERAL.equals((Object)this.activity.getImplementation())) {
            this.accessPointText.getCombo().setEnabled(!AccessPointUtil.isIn((DirectionType)this.dataMapping.getDirection()));
            this.accessPathBrowser.setAccessPoint(null, null);
            if (AccessPointUtil.isIn((DirectionType)this.dataMapping.getDirection())) {
                this.txtId.getText().addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        String value = DataMappingPropertyPage.this.dataMapping.getApplicationAccessPoint();
                        DataMappingPropertyPage.this.dataMapping.setApplicationAccessPoint(DataMappingPropertyPage.this.txtId.getText().getText());
                        DataMappingPropertyPage.this.accessPointText.getCombo().setText(DataMappingPropertyPage.this.txtId.getText().getText());
                        List dataMappings = ActivityUtil.getDataMappings((ActivityType)DataMappingPropertyPage.this.activity, (!AccessPointUtil.isIn((DirectionType)DataMappingPropertyPage.this.dataMapping.getDirection()) ? 1 : 0) != 0, (String)"default");
                        for (DataMappingType ap : dataMappings) {
                            if (ap.getApplicationAccessPoint() == null || !ap.getApplicationAccessPoint().equals(value)) continue;
                            ap.setApplicationAccessPoint(DataMappingPropertyPage.this.txtId.getText().getText());
                        }
                    }
                });
            } else {
                this.binding.getModelBindingManager().bind((EObject)this.activity, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getActivityType_DataMapping(), (IWidgetAdapter)new AbstractWidgetAdapter(){

                    public void updateVisuals(Object value) {
                        List dataMappings = ActivityUtil.getDataMappings((ActivityType)DataMappingPropertyPage.this.activity, (!AccessPointUtil.isIn((DirectionType)DataMappingPropertyPage.this.dataMapping.getDirection()) ? 1 : 0) != 0, (String)"default");
                        ISelection selection = DataMappingPropertyPage.this.accessPointText.getSelection();
                        if (!DataMappingPropertyPage.this.accessPointText.getCombo().isDisposed()) {
                            if (DataMappingPropertyPage.this.accessPointText.getContentProvider() == null) {
                                DataMappingPropertyPage.this.accessPointText.setContentProvider((IContentProvider)new ArrayContentProvider());
                            }
                            DataMappingPropertyPage.this.accessPointText.setInput((Object)dataMappings);
                            DataMappingPropertyPage.this.accessPointText.setSelection(selection);
                        }
                    }
                });
                this.binding.bind(new LabeledViewer((StructuredViewer)this.accessPointText, this.apLabel), (EObject)this.dataMapping, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getDataMappingType_ApplicationAccessPoint(), new EFeatureAdapter(){

                    public Object toModel(EObjectAdapter binding, Object value) {
                        if (value instanceof DataMappingType) {
                            return ((DataMappingType)value).getId();
                        }
                        return null;
                    }

                    public Object fromModel(EObjectAdapter binding, Object value) {
                        List dataMappings = ActivityUtil.getDataMappings((ActivityType)DataMappingPropertyPage.this.activity, (!AccessPointUtil.isIn((DirectionType)DataMappingPropertyPage.this.dataMapping.getDirection()) ? 1 : 0) != 0, (String)"default");
                        for (DataMappingType ap : dataMappings) {
                            if (!ap.getId().equals(value)) continue;
                            return ap;
                        }
                        return null;
                    }
                });
            }
        } else {
            this.accessPointText.getCombo().setEnabled(false);
            this.accessPointText.setSelection(null);
            this.accessPathBrowser.setAccessPoint(null, null);
        }
        if (StringUtils.isEmpty((String)this.dataMapping.getName())) {
            this.dataMapping.setName(this.dataMapping.getId());
        }
        this.binding.bind(this.txtName, (EObject)element, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getIIdentifiableElement_Name());
        this.txtName.getText().addModifyListener(this.listener);
        this.binding.bind(this.txtId, (EObject)element, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getIIdentifiableElement_Id());
    }

    private void updateAccessPoints() {
        this.accessPoints.clear();
        this.accessPoints.addAll(ActivityUtil.getAccessPoints((ActivityType)this.activity, (DirectionType.IN_LITERAL == this.dataMapping.getDirection() ? 1 : 0) != 0, (String)this.dataMapping.getContext()));
    }

    private DataType getData() {
        IAdaptable element = this.getElement();
        if (element instanceof EditPart) {
            Object model = ((EditPart)element).getModel();
            if (model instanceof DataMappingConnectionType) {
                model = ((DataMappingConnectionType)model).getDataSymbol();
            }
            if (model instanceof DataSymbolType) {
                model = ((DataSymbolType)model).getData();
            }
            if (model instanceof DataType) {
                return (DataType)model;
            }
        }
        return null;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            IButtonManager manager = (IButtonManager)this.getElement().getAdapter(IButtonManager.class);
            manager.updateButtons(this.getModelElement(), this.buttons);
            this.refreshAccessPoint();
        }
        super.setVisible(visible);
    }

    public void refreshAccessPoint() {
        if (this.dataMapping == null) {
            this.dataMapping = (DataMappingType)this.getModelElement();
        }
        if (!this.dataMapping.getContext().equals(this.dataMappingContext)) {
            this.loadFieldsFromElement(null, (IModelElement)this.dataMapping);
        }
        String ap = this.dataMapping.getApplicationAccessPoint();
        this.accessPointText.refresh();
        this.dataMapping.setApplicationAccessPoint(ap);
    }

    @Override
    public void contributeVerticalButtons(Composite parent) {
        IButtonManager manager = (IButtonManager)this.getElement().getAdapter(IButtonManager.class);
        this.buttons = manager.createButtons(parent);
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
    }

    @Override
    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)2);
        this.txtName = FormBuilder.createLabeledText((Composite)composite, (String)Diagram_Messages.LB_Name);
        this.txtName.setTextLimit(80);
        this.txtId = FormBuilder.createLabeledText((Composite)composite, (String)Diagram_Messages.LB_ID);
        this.txtId.setTextLimit(80);
        boolean autoIdButtonValue = GenericUtils.getAutoIdValue();
        if (autoIdButtonValue) {
            this.txtId.getText().setEditable(false);
        }
        this.dataLabel = FormBuilder.createLabelWithRightAlignedStatus((Composite)composite, (String)Diagram_Messages.LB_Data);
        this.dataText = new ComboViewer(FormBuilder.createCombo((Composite)composite));
        this.dataText.setSorter(new ViewerSorter());
        this.dataText.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.dataText.setLabelProvider((IBaseLabelProvider)new EObjectLabelProvider(this.getEditor()));
        this.dataPathLabel = FormBuilder.createLabelWithRightAlignedStatus((Composite)composite, (String)Diagram_Messages.LB_DataPath);
        this.dataPathBrowser = new AccessPathBrowserComposite(this.getEditor(), composite, Diagram_Messages.LB_DataPath, this.supportsPrimitiveBrowsing());
        this.apLabel = FormBuilder.createLabelWithRightAlignedStatus((Composite)composite, (String)Diagram_Messages.LB_AccessPoint);
        this.accessPointText = new ComboViewer(FormBuilder.createCombo((Composite)composite));
        this.accessPointText.setSorter(new ViewerSorter());
        this.accessPointText.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.accessPointText.setLabelProvider((IBaseLabelProvider)new EObjectLabelProvider(this.getEditor()));
        this.accessPathLabel = FormBuilder.createLabelWithRightAlignedStatus((Composite)composite, (String)Diagram_Messages.LB_AccessPointPath);
        this.accessPathBrowser = new AccessPathBrowserComposite(this.getEditor(), composite, Diagram_Messages.LB_AccessPointPath, this.supportsPrimitiveBrowsing());
        return composite;
    }

    private boolean supportsPrimitiveBrowsing() {
        ContextType contextType;
        ApplicationType app;
        DataMappingType dmt;
        ActivityType act;
        IModelElement modelElement;
        boolean browsePrimAllowed = true;
        if (this.getElement().getAdapter(IModelElement.class) != null && (modelElement = (IModelElement)this.getElement().getAdapter(IModelElement.class)) instanceof DataMappingType && (act = (ActivityType)(dmt = (DataMappingType)modelElement).eContainer()).getApplication() != null && (app = act.getApplication()).isInteractive() && app.getContext() != null && !app.getContext().isEmpty() && (contextType = (ContextType)app.getContext().get(0)).getType() != null && contextType.getType().getId().equalsIgnoreCase("externalWebApp")) {
            browsePrimAllowed = false;
        }
        return browsePrimAllowed;
    }
}

