/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.stardust.common.CompareHelper;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.ui.CarnotPreferenceNode;
import org.eclipse.stardust.modeling.core.editors.ui.CarnotPropertyPageContributor;
import org.eclipse.stardust.modeling.core.editors.ui.EObjectLabelProvider;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.properties.IButtonManager;
import org.eclipse.stardust.modeling.core.properties.ModelElementAdaptable;
import org.eclipse.stardust.modeling.core.properties.OutlineProvider;
import org.eclipse.stardust.modeling.core.spi.ConfigurationElement;

public class DefaultOutlineProvider
implements OutlineProvider {
    AbstractModelElementPropertyPage page;
    private EStructuralFeature elementListFeature;
    private EStructuralFeature idFeature;
    private EStructuralFeature nameFeature;
    private String parentNodeId;
    private String pageClassName;
    private Class<?> pageClass;
    private IFilter filter;

    public DefaultOutlineProvider(AbstractModelElementPropertyPage page, EStructuralFeature elementListFeature, EStructuralFeature idFeature, EStructuralFeature nameFeature, String parentNodeId, String pageClassName) {
        this(page, elementListFeature, idFeature, nameFeature, parentNodeId, pageClassName, null);
    }

    public DefaultOutlineProvider(AbstractModelElementPropertyPage page, EStructuralFeature elementListFeature, EStructuralFeature idFeature, EStructuralFeature nameFeature, String parentNodeId, Class<?> pageClass) {
        this(page, elementListFeature, idFeature, nameFeature, parentNodeId, pageClass.getName(), null);
        this.pageClass = pageClass;
    }

    public DefaultOutlineProvider(AbstractModelElementPropertyPage page, EStructuralFeature elementListFeature, EStructuralFeature idFeature, EStructuralFeature nameFeature, String parentNodeId, String pageClassName, IFilter filter) {
        this.page = page;
        this.elementListFeature = elementListFeature;
        this.idFeature = idFeature;
        this.nameFeature = nameFeature;
        this.parentNodeId = parentNodeId;
        this.pageClassName = pageClassName;
        this.filter = filter;
    }

    @Override
    public void addNodeTo(String parentNodeId, CarnotPreferenceNode node) {
        this.page.addNodeTo(parentNodeId, node, new EObjectLabelProvider(this.getEditor()));
    }

    @Override
    public IAdaptable getAdaptable() {
        return new ModelElementAdaptable(new Class[]{IButtonManager.class, IModelElementNodeSymbol.class}, new Object[]{this.page}, this.page.getElement());
    }

    public WorkflowModelEditor getEditor() {
        return this.page.getEditor();
    }

    @Override
    public EStructuralFeature getElementListFeature() {
        return this.elementListFeature;
    }

    @Override
    public String getParentNodeId() {
        return this.parentNodeId;
    }

    @Override
    public PreferenceManager getPreferenceManager() {
        return this.page.getPreferenceManager();
    }

    @Override
    public void removeChildrenNodes(String node) {
        this.page.removePreferenceNodes(node, false);
    }

    @Override
    public void removeNode(String node) {
        this.page.removePreferenceNodes(node, true);
    }

    @Override
    public void updateVisuals() {
        this.page.refreshTree();
    }

    @Override
    public ConfigurationElement createPageConfiguration(IModelElement element) {
        if (this.pageClass == null) {
            return ConfigurationElement.createPageConfiguration(this.getId(element), this.getName(element), this.getEditor().getIconFactory().getIconFor((EObject)element), this.pageClassName);
        }
        return ConfigurationElement.createPageConfiguration(this.getId(element), this.getName(element), this.getEditor().getIconFactory().getIconFor((EObject)element), this.pageClass);
    }

    public String getName(IModelElement element) {
        Object value = element.eGet(this.nameFeature);
        return value == null ? "" : value.toString();
    }

    @Override
    public String getId(IModelElement element) {
        Object value = element.eGet(this.idFeature);
        return value == null ? null : value.toString();
    }

    @Override
    public IFilter getFilter() {
        return this.filter;
    }

    @Override
    public void addNodesFor(String parentNodeId, IModelElement element, ModelElementAdaptable adaptable, int index) {
        List<CarnotPreferenceNode> nodes = this.retrievePagesFor(adaptable);
        if (nodes.isEmpty()) {
            return;
        }
        if (nodes.size() > 1) {
            HashMap<String, CarnotPreferenceNode> map = new HashMap<String, CarnotPreferenceNode>();
            ArrayList<CarnotPreferenceNode> toRemove = new ArrayList<CarnotPreferenceNode>();
            for (CarnotPreferenceNode node : nodes) {
                CarnotPreferenceNode other = (CarnotPreferenceNode)((Object)map.get(node.getId()));
                if (other == null) {
                    map.put(node.getId(), node);
                    continue;
                }
                if (other.category == null && node.category != null || CompareHelper.areEqual((Object)parentNodeId, (Object)node.category)) {
                    toRemove.add(other);
                    map.put(node.getId(), node);
                    continue;
                }
                toRemove.add(node);
            }
            nodes.removeAll(toRemove);
        }
        CarnotPreferenceNode general = null;
        if (nodes.size() == 1) {
            general = nodes.get(0);
        } else {
            for (CarnotPreferenceNode node : nodes) {
                if (!"_cwm_general_".equals(node.getId())) continue;
                general = node;
                break;
            }
            if (general == null) {
                general = nodes.get(0);
            }
            nodes.remove((Object)general);
            for (CarnotPreferenceNode node : nodes) {
                general.add((IPreferenceNode)node);
            }
        }
        general.setId(this.getId(element));
        general.setSortOrder(index);
        this.addNodeTo(parentNodeId, general);
    }

    protected List<CarnotPreferenceNode> retrievePagesFor(ModelElementAdaptable adaptable) {
        return CarnotPropertyPageContributor.instance().contributePropertyPages(adaptable);
    }
}

