/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.spi.actionTypes.delegateActivity;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.OrganizationType;
import org.eclipse.stardust.model.xpdl.carnot.ParticipantType;
import org.eclipse.stardust.model.xpdl.carnot.spi.IActionPropertyPage;
import org.eclipse.stardust.model.xpdl.carnot.util.ActionTypeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.ui.EObjectLabelProvider;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class DelegateActivityPropertyPage
extends AbstractModelElementPropertyPage
implements IActionPropertyPage {
    private static final String RANDOM_USER = Diagram_Messages.RANDOM_USER;
    private static final String PARTICIPANT = Diagram_Messages.PARTICIPANT;
    private static final String CURRENT_USER = Diagram_Messages.CURRENT_USER;
    private static final String DEFAULT_PERFORMER = Diagram_Messages.DEFAULT_PERFORMER;
    private static final String SEND_TO_WORKLIST = Diagram_Messages.SEND_TO_WORKLIST;
    private static final String RANDOM_USER_VAL = "randomUser";
    private static final String PARTICIPANT_VAL = "participant";
    private static final String CURRENT_USER_VAL = "currentUser";
    private static final String DEFAULT_PERFORMER_VAL = "defaultPerformer";
    private static final String DELEGATE_ACTIVITY_TYPE = "delegateActivity";
    private Button defaultPerformerButton;
    private Button currentUserButton;
    private Button participantButton;
    private Button randomUserButton;
    private ListViewer vwParticipants;
    private Composite participantComposite;
    private StackLayout participantCompLayout;
    private Composite emptyComposite;
    private Composite listComposite;

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        if (ActionTypeUtil.getActionType((IModelElement)element).getId().equals(DELEGATE_ACTIVITY_TYPE) && this.defaultPerformerButton != null) {
            IModelParticipant target = (IModelParticipant)AttributeUtil.getIdentifiable((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:target");
            String targetWorklistAttr = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:targetWorklist");
            this.initParticipantList(element, target);
            if (targetWorklistAttr != null) {
                this.defaultPerformerButton.setSelection(targetWorklistAttr.equals(DEFAULT_PERFORMER_VAL));
                this.currentUserButton.setSelection(targetWorklistAttr.equals(CURRENT_USER_VAL));
                this.participantButton.setSelection(targetWorklistAttr.equals(PARTICIPANT_VAL));
                this.randomUserButton.setSelection(targetWorklistAttr.equals(RANDOM_USER_VAL));
                if (this.participantButton.getSelection()) {
                    this.setListComposite();
                }
            }
        }
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        if (ActionTypeUtil.getActionType((IModelElement)element).getId().equals(DELEGATE_ACTIVITY_TYPE) && this.defaultPerformerButton != null) {
            ((IExtensibleElement)element).getAttribute().clear();
            String value = "";
            IModelParticipant participantValue = null;
            if (this.defaultPerformerButton.getSelection()) {
                value = DEFAULT_PERFORMER_VAL;
            } else if (this.currentUserButton.getSelection()) {
                value = CURRENT_USER_VAL;
            } else if (this.participantButton.getSelection()) {
                Object selectedParticipant;
                value = PARTICIPANT_VAL;
                ISelection selection = this.vwParticipants.getSelection();
                if (!selection.isEmpty() && selection instanceof IStructuredSelection && (selectedParticipant = ((IStructuredSelection)selection).getFirstElement()) instanceof IModelParticipant) {
                    participantValue = (IModelParticipant)selectedParticipant;
                }
            } else if (this.randomUserButton.getSelection()) {
                value = RANDOM_USER_VAL;
            }
            AttributeUtil.setReference((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:target", participantValue);
            AttributeUtil.setAttribute((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:targetWorklist", (String)"ag.carnot.workflow.spi.providers.actions.delegate.TargetWorklist", (String)value);
        }
    }

    @Override
    public Control createBody(Composite parent) {
        Group sendToWorklistGroup = FormBuilder.createGroup((Composite)parent, (String)SEND_TO_WORKLIST, (int)4);
        ((GridLayout)sendToWorklistGroup.getLayout()).marginHeight = 10;
        sendToWorklistGroup.setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
        this.defaultPerformerButton = FormBuilder.createRadioButton((Composite)sendToWorklistGroup, (String)DEFAULT_PERFORMER);
        this.defaultPerformerButton.setSelection(true);
        this.currentUserButton = FormBuilder.createRadioButton((Composite)sendToWorklistGroup, (String)CURRENT_USER);
        this.participantButton = FormBuilder.createRadioButton((Composite)sendToWorklistGroup, (String)PARTICIPANT);
        this.randomUserButton = FormBuilder.createRadioButton((Composite)sendToWorklistGroup, (String)RANDOM_USER);
        this.participantComposite = FormBuilder.createComposite((Composite)parent, (int)1, (int)2);
        this.participantCompLayout = new StackLayout();
        this.participantComposite.setLayout((Layout)this.participantCompLayout);
        this.emptyComposite = FormBuilder.createComposite((Composite)this.participantComposite, (int)1);
        this.listComposite = FormBuilder.createComposite((Composite)this.participantComposite, (int)1);
        this.vwParticipants = new ListViewer(FormBuilder.createList((Composite)this.listComposite));
        this.vwParticipants.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.vwParticipants.setLabelProvider((IBaseLabelProvider)new EObjectLabelProvider(this.getEditor()));
        this.vwParticipants.setSorter(new ViewerSorter());
        this.participantCompLayout.topControl = this.emptyComposite;
        this.defaultPerformerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DelegateActivityPropertyPage.this.setEmptyComposite();
            }
        });
        this.currentUserButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DelegateActivityPropertyPage.this.setEmptyComposite();
            }
        });
        this.participantButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DelegateActivityPropertyPage.this.setListComposite();
            }
        });
        this.randomUserButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DelegateActivityPropertyPage.this.setEmptyComposite();
            }
        });
        return parent;
    }

    private void setEmptyComposite() {
        this.participantCompLayout.topControl = this.emptyComposite;
        this.participantComposite.layout();
    }

    private void initParticipantList(IModelElement element, IModelParticipant target) {
        ArrayList<IModelParticipant> participants = new ArrayList<IModelParticipant>();
        ActivityType activityType = ModelUtils.findContainingActivity((EObject)element);
        if (activityType.getPerformer() != null) {
            for (IModelParticipant modelParticipant : this.getActivityPerformer(activityType.getPerformer())) {
                participants.add(modelParticipant);
            }
        }
        this.vwParticipants.setInput(participants);
        this.vwParticipants.setSelection((ISelection)(target == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)target)), true);
    }

    private List getActivityPerformer(IModelParticipant performer) {
        ArrayList participants = new ArrayList();
        DelegateActivityPropertyPage.getReferencedPerformer(performer, participants, new HashSet());
        return participants;
    }

    private static void getReferencedPerformer(IModelParticipant performer, List participants, Set visitedParticipants) {
        if (performer != null && !visitedParticipants.contains(performer)) {
            participants.add(performer);
            visitedParticipants.add(performer);
            if (performer instanceof OrganizationType) {
                for (ParticipantType ref : ((OrganizationType)performer).getParticipant()) {
                    DelegateActivityPropertyPage.getReferencedPerformer(ref.getParticipant(), participants, visitedParticipants);
                }
            }
        }
    }

    private void setListComposite() {
        this.participantCompLayout.topControl = this.listComposite;
        this.participantComposite.layout();
    }
}

