/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.spi.applicationTypes.webservice;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Part;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.extensions.soap12.SOAP12Binding;
import javax.wsdl.extensions.soap12.SOAP12Body;
import javax.wsdl.extensions.soap12.SOAP12Operation;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.stardust.common.error.PublicException;
import org.eclipse.stardust.engine.core.runtime.utils.XmlUtils;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JaxWSResource {
    private static final String CANNOT_PARSE_WSDL_FILE = Diagram_Messages.WebServiceResource_ErrorMessage;
    private static HashMap<String, String> jaxbDefaultMappings = new HashMap();

    static {
        jaxbDefaultMappings.put("string", String.class.getName());
        jaxbDefaultMappings.put("integer", BigInteger.class.getName());
        jaxbDefaultMappings.put("int", Integer.class.getName());
        jaxbDefaultMappings.put("long", Long.class.getName());
        jaxbDefaultMappings.put("short", Short.class.getName());
        jaxbDefaultMappings.put("decimal", BigDecimal.class.getName());
        jaxbDefaultMappings.put("float", Float.class.getName());
        jaxbDefaultMappings.put("double", Double.class.getName());
        jaxbDefaultMappings.put("boolean", Boolean.class.getName());
        jaxbDefaultMappings.put("byte", Byte.class.getName());
        jaxbDefaultMappings.put("QName", QName.class.getName());
        jaxbDefaultMappings.put("base64Binary", String.valueOf(Byte.TYPE.getName()) + "[]");
        jaxbDefaultMappings.put("hexBinary", String.valueOf(Byte.TYPE.getName()) + "[]");
        jaxbDefaultMappings.put("unsignedInt", Long.class.getName());
        jaxbDefaultMappings.put("unsignedShort", Integer.class.getName());
        jaxbDefaultMappings.put("unsignedByte", Short.class.getName());
        jaxbDefaultMappings.put("anySimpleType", Object.class.getName());
        jaxbDefaultMappings.put("NOTATION", QName.class.getName());
        jaxbDefaultMappings.put("dateTime", XMLGregorianCalendar.class.getName());
        jaxbDefaultMappings.put("time", XMLGregorianCalendar.class.getName());
        jaxbDefaultMappings.put("date", XMLGregorianCalendar.class.getName());
        jaxbDefaultMappings.put("gYearMonth", XMLGregorianCalendar.class.getName());
        jaxbDefaultMappings.put("gYear", XMLGregorianCalendar.class.getName());
        jaxbDefaultMappings.put("gMonthDay", XMLGregorianCalendar.class.getName());
        jaxbDefaultMappings.put("gDay", XMLGregorianCalendar.class.getName());
        jaxbDefaultMappings.put("gMonth", XMLGregorianCalendar.class.getName());
        jaxbDefaultMappings.put("duration", Duration.class.getName());
    }

    public static String getDefaultMappedClass(QName type) {
        String javaName = null;
        if ("http://www.w3.org/2001/XMLSchema".equals(type.getNamespaceURI())) {
            String localName = type.getLocalPart();
            javaName = jaxbDefaultMappings.get(localName);
        }
        return javaName;
    }

    public static Definition getDefinition(String wsdlURI) {
        try {
            String wsdl = XmlUtils.resolveResourceUri((String)wsdlURI);
            return JaxWSResource.getDefinition(wsdl, JaxWSResource.newDocument(wsdl));
        }
        catch (Exception e) {
            throw new PublicException(CANNOT_PARSE_WSDL_FILE, (Throwable)e);
        }
    }

    public static Definition getDefinition(String wsdlURI, InputSource source) {
        try {
            return JaxWSResource.getDefinition(wsdlURI, JaxWSResource.newDocument(source));
        }
        catch (Exception e) {
            throw new PublicException(CANNOT_PARSE_WSDL_FILE, (Throwable)e);
        }
    }

    public static Definition getDefinition(String wsdlURI, Document document) {
        try {
            WSDLFactory factory = WSDLFactory.newInstance();
            WSDLReader reader = factory.newWSDLReader();
            return reader.readWSDL(wsdlURI, document);
        }
        catch (WSDLException e) {
            throw new PublicException(CANNOT_PARSE_WSDL_FILE, (Throwable)e);
        }
    }

    public static Document newDocument(String uri) throws ParserConfigurationException, SAXException, IOException {
        return JaxWSResource.newDocument(new InputSource(uri));
    }

    public static Document newDocument(InputSource source) throws ParserConfigurationException, SAXException, IOException {
        Document doc = XmlUtils.parseSource((InputSource)source, null);
        if (source.getByteStream() != null) {
            source.getByteStream().close();
        } else if (source.getCharacterStream() != null) {
            source.getCharacterStream().close();
        }
        return doc;
    }

    public static String getBindingStyle(Binding binding) {
        String style = null;
        if (binding != null) {
            style = "message";
            List extensions = binding.getExtensibilityElements();
            int i = 0;
            while (i < extensions.size()) {
                ExtensibilityElement element = (ExtensibilityElement)extensions.get(i);
                if (element instanceof SOAPBinding) {
                    style = ((SOAPBinding)element).getStyle();
                    break;
                }
                if (element instanceof SOAP12Binding) {
                    style = ((SOAP12Binding)element).getStyle();
                    break;
                }
                ++i;
            }
        }
        return style;
    }

    public static String getSoapActionUri(BindingOperation operation) {
        String soapAction = null;
        if (operation != null) {
            List extensions = operation.getExtensibilityElements();
            int i = 0;
            while (i < extensions.size()) {
                ExtensibilityElement element = (ExtensibilityElement)extensions.get(i);
                if (element instanceof SOAPOperation) {
                    soapAction = ((SOAPOperation)element).getSoapActionURI();
                    break;
                }
                if (element instanceof SOAP12Operation) {
                    soapAction = ((SOAP12Operation)element).getSoapActionURI();
                    break;
                }
                ++i;
            }
        }
        return soapAction;
    }

    public static String getOperationStyle(BindingOperation operation) {
        String style = null;
        if (operation != null) {
            List extensions = operation.getExtensibilityElements();
            int i = 0;
            while (i < extensions.size()) {
                ExtensibilityElement element = (ExtensibilityElement)extensions.get(i);
                if (element instanceof SOAPOperation) {
                    style = ((SOAPOperation)element).getStyle();
                    break;
                }
                if (element instanceof SOAP12Operation) {
                    style = ((SOAP12Operation)element).getStyle();
                    break;
                }
                ++i;
            }
        }
        return style;
    }

    public static String getOperationProtocol(BindingOperation operation) {
        String soapProtocol = "SOAP 1.1 Protocol";
        if (operation != null) {
            List extensions = operation.getExtensibilityElements();
            int i = 0;
            while (i < extensions.size()) {
                ExtensibilityElement element = (ExtensibilityElement)extensions.get(i);
                if (element instanceof SOAPOperation) {
                    soapProtocol = "SOAP 1.1 Protocol";
                    break;
                }
                if (element instanceof SOAP12Operation) {
                    soapProtocol = "SOAP 1.2 Protocol";
                    break;
                }
                ++i;
            }
        }
        return soapProtocol;
    }

    public static String getOperationUse(BindingOperation operation) {
        String use = null;
        if (operation != null) {
            List extensions = null;
            BindingInput input = operation.getBindingInput();
            if (input != null) {
                extensions = input.getExtensibilityElements();
            } else {
                BindingOutput output = operation.getBindingOutput();
                if (output != null) {
                    extensions = output.getExtensibilityElements();
                }
            }
            if (extensions != null) {
                int i = 0;
                while (i < extensions.size()) {
                    ExtensibilityElement element = (ExtensibilityElement)extensions.get(i);
                    if (element instanceof SOAPBody) {
                        use = ((SOAPBody)element).getUse();
                        break;
                    }
                    if (element instanceof SOAP12Body) {
                        use = ((SOAP12Body)element).getUse();
                        break;
                    }
                    ++i;
                }
            }
        }
        return use;
    }

    public static QName getType(Part part) {
        QName type = part.getTypeName();
        if (type == null) {
            type = part.getElementName();
        }
        return type;
    }
}

