/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.spi.conditionTypes.processStatechange;

import org.eclipse.emf.common.util.EList;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.EventHandlerType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.spi.IConditionPropertyPage;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.spi.DefaultModelElementPropertyPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;

public class ProcessStateChangePropertyPage
extends DefaultModelElementPropertyPage
implements IConditionPropertyPage {
    private static final String SOURCE_STATE = Diagram_Messages.SOURCE_STATE;
    private static final String INTERRUPTED = Diagram_Messages.INTERRUPTED;
    private static final String ABORTED = Diagram_Messages.ABORTED;
    private static final String COMPLETED = Diagram_Messages.COMPLETED;
    private static final String ACTIVE = Diagram_Messages.ACTIVE;
    private static final String N_A = "N/A";
    private static final String TARGET_STATE = Diagram_Messages.TARGET_STATE;
    private static final String INTERRUPTED_VAL = "3";
    private static final String ABORTED_VAL = "1";
    private static final String COMPLETED_VAL = "2";
    private static final String ACTIVE_VAL = "0";
    private Button interruptedSourceStateButton;
    private Button activeSourceStateButton;
    private Button naSourceStateButton;
    private Button naTargetStateButton;
    private Button activeTargetStateButton;
    private Button completedTargetStateButton;
    private Button abortedTargetStateButton;
    private Button interruptedTargetStateButton;
    private AttributeType sourceStateAttribute;
    private AttributeType targetStateAttribute;
    private EList attributes;

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        this.init((EventHandlerType)element);
        this.setSourceStateValue();
        this.setTargetStateValue();
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        EventHandlerType eventHandler = (EventHandlerType)element;
        if (this.naSourceStateButton != null) {
            this.setSourceStateAttribute(eventHandler);
            this.setTargetStateAttribute(eventHandler);
        }
    }

    private void init(EventHandlerType eventHandler) {
        this.attributes = eventHandler.getAttribute();
        for (AttributeType handlerAttribute : this.attributes) {
            if (handlerAttribute.getName().equals("carnot:engine:targetState")) {
                this.targetStateAttribute = handlerAttribute;
                continue;
            }
            if (!handlerAttribute.getName().equals("carnot:engine:sourceState")) continue;
            this.sourceStateAttribute = handlerAttribute;
        }
    }

    private void setTargetStateValue() {
        if (this.targetStateAttribute == null) {
            this.naTargetStateButton.setSelection(true);
        } else {
            switch (Integer.parseInt(this.targetStateAttribute.getValue())) {
                case 0: {
                    this.activeTargetStateButton.setSelection(true);
                    break;
                }
                case 1: {
                    this.abortedTargetStateButton.setSelection(true);
                    break;
                }
                case 2: {
                    this.completedTargetStateButton.setSelection(true);
                    break;
                }
                case 3: {
                    this.interruptedTargetStateButton.setSelection(true);
                    break;
                }
                default: {
                    this.naTargetStateButton.setSelection(true);
                }
            }
        }
    }

    private void setSourceStateValue() {
        if (this.sourceStateAttribute == null) {
            this.naSourceStateButton.setSelection(true);
        } else {
            switch (Integer.parseInt(this.sourceStateAttribute.getValue())) {
                case 0: {
                    this.activeSourceStateButton.setSelection(true);
                    break;
                }
                case 3: {
                    this.interruptedSourceStateButton.setSelection(true);
                    break;
                }
                default: {
                    this.naSourceStateButton.setSelection(true);
                }
            }
        }
    }

    @Override
    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)1, (int)3);
        ((GridLayout)composite.getLayout()).marginHeight = 0;
        ((GridLayout)composite.getLayout()).marginWidth = 0;
        this.createSourceStateGroup(composite);
        this.createTargetStateGroup(composite);
        return composite;
    }

    private void createTargetStateGroup(Composite composite) {
        Group targetStateGroup = FormBuilder.createGroup((Composite)composite, (String)TARGET_STATE, (int)4);
        this.naTargetStateButton = FormBuilder.createRadioButton((Composite)targetStateGroup, (String)N_A, (int)4);
        this.activeTargetStateButton = FormBuilder.createRadioButton((Composite)targetStateGroup, (String)ACTIVE);
        this.completedTargetStateButton = FormBuilder.createRadioButton((Composite)targetStateGroup, (String)COMPLETED);
        this.abortedTargetStateButton = FormBuilder.createRadioButton((Composite)targetStateGroup, (String)ABORTED);
        this.interruptedTargetStateButton = FormBuilder.createRadioButton((Composite)targetStateGroup, (String)INTERRUPTED);
    }

    private void createSourceStateGroup(Composite composite) {
        Group sourceStateGroup = FormBuilder.createGroup((Composite)composite, (String)SOURCE_STATE, (int)2);
        this.naSourceStateButton = FormBuilder.createRadioButton((Composite)sourceStateGroup, (String)N_A);
        FormBuilder.createLabel((Composite)sourceStateGroup, (String)"");
        this.activeSourceStateButton = FormBuilder.createRadioButton((Composite)sourceStateGroup, (String)ACTIVE);
        this.interruptedSourceStateButton = FormBuilder.createRadioButton((Composite)sourceStateGroup, (String)INTERRUPTED);
    }

    private void setTargetStateAttribute(EventHandlerType eventHandler) {
        if (this.targetStateAttribute == null && !this.naTargetStateButton.getSelection()) {
            AttributeUtil.setAttribute((IExtensibleElement)eventHandler, (String)"carnot:engine:targetState", (String)"ag.carnot.workflow.runtime.ProcessInstanceState", (String)ACTIVE_VAL);
            this.targetStateAttribute = AttributeUtil.getAttribute((IExtensibleElement)eventHandler, (String)"carnot:engine:targetState");
        }
        if (this.activeTargetStateButton.getSelection()) {
            this.targetStateAttribute.setValue(ACTIVE_VAL);
        }
        if (this.completedTargetStateButton.getSelection()) {
            this.targetStateAttribute.setValue(COMPLETED_VAL);
        } else if (this.abortedTargetStateButton.getSelection()) {
            this.targetStateAttribute.setValue(ABORTED_VAL);
        } else if (this.interruptedTargetStateButton.getSelection()) {
            this.targetStateAttribute.setValue(INTERRUPTED_VAL);
        } else if (this.naTargetStateButton.getSelection()) {
            this.attributes.remove((Object)this.targetStateAttribute);
        }
    }

    private void setSourceStateAttribute(EventHandlerType eventHandler) {
        if (this.sourceStateAttribute == null && this.naSourceStateButton != null && !this.naSourceStateButton.getSelection()) {
            AttributeUtil.setAttribute((IExtensibleElement)eventHandler, (String)"carnot:engine:sourceState", (String)"ag.carnot.workflow.runtime.ProcessInstanceState", (String)ACTIVE_VAL);
            this.sourceStateAttribute = AttributeUtil.getAttribute((IExtensibleElement)eventHandler, (String)"carnot:engine:sourceState");
        }
        if (this.interruptedSourceStateButton.getSelection()) {
            this.sourceStateAttribute.setValue(INTERRUPTED_VAL);
        } else if (this.activeSourceStateButton.getSelection()) {
            this.sourceStateAttribute.setValue(ACTIVE_VAL);
        } else if (this.naSourceStateButton.getSelection() && this.sourceStateAttribute != null) {
            this.attributes.remove((Object)this.sourceStateAttribute);
        }
    }

    @Override
    public void setDelegateContainer(AbstractModelElementPropertyPage page) {
    }
}

